/* 
** Routine zum Scannen der Modula 3 Kommentare
** (Modifizierte Version von Ccomment.c)
**
** Autor: Thomas Roemke (C)
**
** Da Modula-2 Kommentare sich nicht von Modula-3 Kommentaren
** unterscheiden, habe ich das hier uebernommen und ueberarbeitet.
**
** Martin Husemann, 04.05.90
*/

#include <string.h>
#include "err.h"
#include "gla.h"
#include "source.h"

/* Produce NOTEs on nested comments */
/* This should be set by command line handling */
int flag_warn_comments = 0;

/*
**  Rueckgabewert: Zeiger auf das erste Zeichen nach dem Kommentar
*/

char *auxM3Comment(start, length)
char *start;	/* Start des Kommentars */ 
int length;	/* Laenge der erkannten Zeichenkette von gla, d.h. start+length=erstes Zeichen */
{
register char c;
register char *p = start + length; /* first char not yet processed */
register int level=1;
POSITION comm_pos, save_pos;

save_pos = curpos;
top: while( (c = *p++) && c != '(' && c != '*' && c != '\n' );
	/*
	** 4 Faelle:         
	**		Fall1:  mit '('  faengt ein geschachtelter Kommentar an
	**		Fall2:	mit '*'  koennte eine Kommentarebene beendet werden
	**		Fall3:	bei '\n' muessen die interne Variablen gesetzt werden 
	**		Fall4:  bei '\0' muss der interne Buffer neu gefuellt werden
	*/

	/* Fall 1: */
	if(c == '(') {
		if(*p == '*') {
		  level++; 		/* Hier faengt ein geschachtelter Kommentar an */
		  if (flag_warn_comments && (level>1)) 
		    {
		      char msg[128];
		      comm_pos.line = LineNum;
		      comm_pos.col  = (p - StartLine) -1;
		      (void)sprintf(msg, "nested comment (level %d) starts here", level);
		      message(NOTE, msg, 0, &comm_pos);
		    }
		}
		goto top;
	}
	else
	/* Fall 2: */
	if( c == '*') { 
		if( *p == ')' ) { 		/* Hier ist ein Kommentar zu Ende */ 
			level--;		/* erniedrige den Level */
			if(level) {  	      /* sind noch Level abzuarbeiten ?  Ja, dann weiter*/
			  if (flag_warn_comments) 
			    {
			      char msg[128];
			      comm_pos.line = LineNum;
			      comm_pos.col  = (p - StartLine);
			      (void)sprintf(msg, "nested comment (level %d) ends here", level+1);
			      message(NOTE, msg, 0, &comm_pos);
			    }
			  goto top;
			} else return(++p);	/* Nein, fertig */
		} 
		else goto top;			/* War kein Kommentarende */
	} 
	else 
	/* Fall 3: */
	if(c == '\n'){
		LineNum++;
		StartLine = p-1;
		goto top;
	} 
	else { /* Fall 4: */
		refillBuf(p-1);
		p = TokenEnd;
		if ( *p == '\0') {
			char	msg[128];
			StartLine = p;
			comm_pos.line = LineNum;
			comm_pos.col  = (p - StartLine);

			(void) sprintf(msg,"file ends in comment (nesting level %d)",level);
			message(NOTE, "this comment continues to end of file", 0, &save_pos);
			message(FATAL, msg, 0, &comm_pos);
			return p;
		}
		else
			goto top;
	}
}	



