/* mime.h - interface to mime.c, which is based on NCSA httpd's http_mime.c */
/* by Reinier Post */

#include <stdio.h>

#define MIME_HEADERS_STRING_LEN 16383
  /* this accept header can be very very very long */
  /* this emerged on Solaris only */

extern void kill_mime();

extern int init_mime();
/* returns 0 on success, -1 on problem reading mime.types,      */
/* -2 on memory shortage                                        */

extern void dump_types();
extern int is_content_type(char *type);
extern void set_content_type(char *file);
extern int url_says_html(char *url);  /* RP */
extern void set_location(char *l);  /* RP */
extern void get_location(char *l);  /* RP */
  /* assumes l is a buffer of size >= HUGE_STRING_LEN */
extern int scan_script_header(FILE *f, FILE *fd);
extern void add_type(char *fn, char *t, FILE *out);
extern void add_encoding(char *fn, char *t,FILE *out);
extern void set_content_length(int l);
extern void set_last_modified(time_t t);
extern void set_http_status(int status);  /* RP */
extern void set_http_reason(char *reason);  /* RP */
extern int raw_get_http_header(int fd); /* 0 on success, -1 on failure */
extern void raw_get_mime_headers(int fd);
extern void set_mime_headers_from_cgi_env();
extern void send_redirect(FILE *fd,char *url);
extern void send_http_header(FILE *fd);
extern int raw_send_http_header(int fd);
/* returns write's error code */
extern void send_cgi_header(FILE *fd);
extern int raw_send_http_request(char *request, char *input, int fd);
/* returns whatever write returns */

/* new functions - implementation is currently out of date */
extern int raw_send_mime_headers(int file);
extern int is_regular_document_header();
/* returns whether or not the MIME headers last scanned indicated a */
/* successful document retrieval (with the document attached) */
/* used to single out errors, redirections, etc. */
