;;;
;;; $Id: vcs-init.el,v 1.2 17-Sep-1992 21:51:53 EDT don Exp $
;;;
;;;

;; the main package
(load "vcs")

;; support for sccs
(load "vcs-sccs")

;; support for rcs
(load "vcs-rcs")

;; support for local version control wrappers
; (load "vcs-local")

(defvar vcs-auto-lookup t
  "*Specifies that vcs should automatically try to lookup a file when
find-file fails.")

(defvar vcs-show-lock-status t
  "*Specifies that vcs should display the lock status of a file in the
buffer's mode line")

(defvar vcs-use-default-bindings t
  "*Specifies that vcs should add default bindings to the global key map")


;;;
;;;
;;;


(if (and vcs-auto-lookup
	 (not (memq 'vcs-try-file find-file-not-found-hooks)))
    (setq find-file-not-found-hooks
	  (cons 'vcs-try-file
		find-file-not-found-hooks)))
   
(if (not (memq 'vcs-mark-as-read-only find-file-hooks))
    (setq find-file-hooks
	  (cons 'vcs-mark-as-read-only find-file-hooks)))

(if (and vcs-show-lock-status
	 (not (memq 'vcs-hack-modeline find-file-hooks)))
    (setq find-file-hooks
	  (cons 'vcs-hack-modeline find-file-hooks)))

(if vcs-use-default-bindings
    (progn
      (global-set-key "u" 'vcs-unlock-buffer)
      (global-set-key "l" 'vcs-lock-buffer)
      (global-set-key "i" 'vcs-info-buffer)
      (global-set-key "p" 'vcs-put-buffer)
      (global-set-key "g" 'vcs-get-buffer)))

;;
;; You will want to add to this list.
;;
(setq vcs-file-patterns
      '(
	(".*" ".")
	("TAGS" "${root_dir}")
	("\\.h$" "${root_dir}/include" "/usr/include" "/usr/local/include/X11")
	("^[^.]*$" "${root_dir}/scripts" "${vi_dir}/scripts"
	 "${root_dir}/make" "${root_dir}/etc")
	("\\.mk$" "${root_dir}/make")
	("\\.mn$" "${root_dir}/src/menus")
	("\\.sh$" "${root_dir}/scripts" "${vi_dir}/scripts")
	("\\.csh$" "${root_dir}/scripts" "${vi_dir}/scripts")
	("\\.b$" "${root_dir}/src/DD/XW")
	("\\.el$" "${HOME}/elisp" "${HOME}/emacs" "/usr/local/emacs/lisp"
	 "/usr/local/emacs/lisp/term" "/usr/local/emacs/lisp/local")
	))
      
