/* usagegraph 1.1. Copyright 1993, 1994, Quest Protein Database Center,
   Cold Spring Harbor Labs. Permission granted to copy and distribute
   this work provided that this notice remains intact. Modified
   versions should be cleared through Quest first; if this is not
   done, any modified version of the program must be clearly labeled
   as such. 

   By Thomas Boutell, 11/93 - 1/94. Please contact boutell@cshl.org
   with any questions regarding this software. */

#include <stdio.h>
#include "configure.h"

#define WEEKS_MAX 5000 

int values[WEEKS_MAX];

void graph(int sizex, int sizey, int base, char *name);

main(int argc, char *argv[]) {
	if (argc < 2) {
		usage();
		exit(-1);
	}
	if (!strcmp(argv[1], "-c")) {
		configfile = argv[2];
	}
	configure();
	graph(320, 240, 16, "usage.graph.gif");
	graph(40, 30, 0, "usage.graph.small.gif");
}

void graph(int sizex, int sizey, int base, char *name) {
	FILE *out;
	FILE *in;
	int weeks = 0;
	int max = - 1;
	int maxx = sizex-1;
	int basex = base;
	int rangex = maxx - basex*2;
	int i;
	int maxy = sizey-1;
	int basey = base;
	int rangey = maxy - basey*2;
	char s[81];
	int lx, ly;
	sprintf(s, "%s/temp.sh", filepath);
	out = fopen(s, "w");
	sprintf(s, "%s/wusage -c %s -t -w", binpath, configfile);
	in = popen(s, "r");
	while (!feof(in)) {
		char s[81];
		int v;
		if (!fgets(s, 80, in)) {
			break;
		}
		v = atoi(s);
		values[weeks++] = v;
		if (v > max) {
			max = v;
		}	
	}
	pclose(in);
	fprintf(out, "#!/bin/sh\n");
	fprintf(out, "%s/ppmmake rgbi:.97/.97/.97 %d %d | \\\n", 
		pbmpluspath, maxx+1, maxy+1);	
	fprintf(out, "%s/ppmfig \\\n", pbmpluspath);
	fprintf(out, "  %d %d %d %d\\\n", basex, basey, 
		maxx-basex, basey);
	fprintf(out, "  %d %d %d %d\\\n", maxx-basex, basey,
		maxx-basex, maxy-basey);
	fprintf(out, "  %d %d %d %d\\\n", maxx-basex, maxy-basey, 
		basex, maxy-basey);
	fprintf(out, "  %d %d %d %d\\\n", basex, maxy-basey, 
		basex, basey);
	if (base) {
		sprintf(s, "%d", weeks);
		fprintf(out, "  -t %d %d 1\\\n", basex, maxy-basey+1);
		fprintf(out, "  -t %d %d %d\\\n", maxx-basex-strlen(s)*8, 
			maxy-basey+1, weeks);	
		fprintf(out, "  -t %d %d Weeks\\\n", sizex/2-20, maxy-16+1);

		fprintf(out, "  -tu %d %d 0\\\n", basex-16, maxy-basey);
		fprintf(out, "  -tu %d %d Accesses\\\n", basex-16,
			sizey/2+32);
		sprintf(s, "%d", max);
		fprintf(out, "  -tu %d %d %d\\\n", basex-16, basey+strlen(s)*8,
		max);
	}
	if (weeks > 1) {
		for (i=0; (i<weeks); i++) {
			int x;
			int y;
			y = rangey-(values[i]*rangey/max)+basey;
			x = i*rangex/(weeks-1)+basex;
			if (i>0) {
				fprintf(out, "  %d %d %d %d\\\n",
					lx, ly, x, y);
			}
			lx = x;
			ly = y;	
		}
	}
	fprintf(out, "  | %s/ppmtogif > %s/%s\n", pbmpluspath, filepath, name);
	fclose(out);
	sprintf(s, "sh %s/temp.sh", filepath);
	system(s);
	sprintf(s, "%s/temp.sh", filepath);
	unlink(s);
}

void usage() {
	fprintf(stderr, "usagegraph -c configuration-file\n");
}
