/* 
   Routines to provide crypto based authentication of gnuserv clients.
      
   Author: David Bremner (bremner@cs.sfu.ca)   

   (c) 1993 David Bremner 

   This file may be distributed under the terms of the GNU General
   Public License or the 'Artistic License' available in the 
   perl 4.0 distribution.
   
*/
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include "cryptoauth.h"

void server_crypto_init()
{
  static   char authname[FILENAMESIZE];
  char *ptr;
    
  get_authname(authname);
  
  if (authname[0]=='>')
    write_authority(authname+1);
  else
    read_authority(authname);
}

static void get_authname(buf)
     char * buf;
{
  char *ptr;
  
  if ((ptr=getenv("GNU_AUTHORITY")) != NULL) 
      strcpy(buf,ptr);
    else {
      buf[0]='>';
      if ((ptr=getenv("HOME")) != NULL) 
	{
	  strcpy(buf+1,ptr);
	  strcat(buf,"/.GnuservAuthority");
	}
      else 
	die();
    }
}
      

/* Create a new authority file */
int write_authority(name)
char *name;
{
  int fd;
  des_cblock client_key,server_key;
  
  (void)des_random_key(client_key);
  (void)des_random_key(server_key);
      
  if ((fd=open(name,O_WRONLY|O_CREAT,0600))<0)
    {
      perror(name);
      exit(1); 
    }
  else
    {
      write(fd,client_key,sizeof(client_key));
      write(fd,server_key,sizeof(server_key));
      close(fd);
    }
  (void)des_set_key(client_key,client_schedule);
  (void)des_set_key(server_key,server_schedule);
}  

/* read existing authority file */
int read_authority(name)
char *name;
{
  int fd;
  des_cblock client_key,server_key;
  
      
  if ((fd=open(name,O_RDONLY))<0)
    {
      perror(name);
      exit(1);
    }
  else
    {
      if (! ( (read(fd,client_key,KEYSIZE) == KEYSIZE) &&
	     (read(fd,server_key,KEYSIZE) == KEYSIZE) ) )
	{
	  perror(progname);
	  fprintf(stderr,"%s: could not read keys\n",progname);
	}
    }
  (void)des_set_key(client_key,client_schedule);
  (void)des_set_key(server_key,server_schedule);
}  

void convince_server(s)
     int s;
{
  char authname[FILENAMESIZE];
  char cookie[COOKIESIZE];
  
  get_authname(authname);
  
  if (authname[0]=='>')
    read_authority(authname+1);
  else
    read_authority(authname);
  
  recv_buffer(s,cookie,COOKIESIZE);
  DECRYPT_BUFFER(cookie,cookie,COOKIESIZE,SERVER_KEY);
  ENCRYPT_BUFFER(cookie,cookie,COOKIESIZE,CLIENT_KEY);
  send_buffer(s,cookie,COOKIESIZE);
  
}


int authenticate(s)
     int s;
{
  char cookie[COOKIESIZE];
  char cipher_cookie[COOKIESIZE];
  int cookie_len,cipher_cookie_len;
  void random_cookie();
    
  random_cookie(cookie,COOKIESIZE);

  ENCRYPT_BUFFER(cookie,cipher_cookie,COOKIESIZE,SERVER_KEY);
  
  send_buffer(s,cipher_cookie,COOKIESIZE);
  if(recv_buffer(s,cipher_cookie,COOKIESIZE) < COOKIESIZE)
    {
      fprintf(stderr,"%s: Protocol mismatch; ditching client.\n",progname);
      return 0;
    }
  
  DECRYPT_BUFFER(cipher_cookie,cipher_cookie,COOKIESIZE,CLIENT_KEY);
  
  return !bcmp(cookie,cipher_cookie,COOKIESIZE);
}  

  
void random_cookie(buf,size)
     char *buf;
     int size;
{
  struct timeval tv;
  int i;
  
  char state[256];
  
  if (gettimeofday(&tv,NULL))
    die();
  (void)initstate( tv.tv_usec ^ tv.tv_sec, state, 256);

  for (i=0; i<size; i+=sizeof(long))
    {
      *(int *)(buf+i)=random();
    }
}

/* These silly little routines are isolated in order to
   permit generalizing to other types of IPC
*/

static void send_buffer(s,buf,len)
{
  int bytes;
  
    if ((bytes=send(s,buf,len,0))<0)
    {
      perror(progname);
      fprintf(stderr,"%s: unable to send\n",progname);
      exit(1);
    }
}

static int recv_buffer(s,buf,len)
     int s;
     char *buf;
     int len;
{
  int bytes,total;
  
  bytes=1;
  total=0;
  
  while (total < len && bytes>0)
    {
      if ( (bytes= recv(s,buf+total,len-total,0)) < 0)
	{
	  perror(progname);
	  fprintf(stderr,"%s: unable to recv\n", 
		  progname);
	  exit(1);
	}	
#ifdef DEBUG_CRYPTOAUTH      
      fprintf(stderr,"%s: got %d bytes\n",progname,bytes);
#endif      
      total+=bytes;
    }
  return total;
}

die()
{
  perror(progname);
  exit(1);
}
