#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * mkdir -- make a dir file for the nameserver
 */

int	IndicateAlways = 0;	/* somebody wants this */

#define BUF_SIZE    4096
#define DIR_MAX	    80
int	DontLog = 1;

main(argc, argv)
	int	argc;
	char	**argv;

{
	char	buffer[BUF_SIZE];
	QDIR	dirp;
	int	count;

	dirp = (char **) malloc(DIR_MAX * sizeof (char *));

	argc--, argv++;

	if (!argc)
	{
		fprintf(stderr, "Usage: mkdir dbname\n");
		exit(1);
	}
	DoSysLog(0);		/* report errors to stderr */

	(void) strcpy(Database, *argv);
	if (!dbd_init(Database))
	{
		fprintf(stderr, "Couldn't init %s.\n", *argv);
		exit(2);
	}
	get_dir_head();

	count = 0;
	while (GetLine(buffer) != 0)
	{
		TurnIntoDir(buffer, dirp);

		if (!new_ent())
		{
			perror("new_ent failed");
			exit(1);
		}
		if (!putdata(dirp))
		{
			perror("Putdata");
			abort();
		}
		set_date(0);
		store_ent();
		if (++count % 500 == 0)
			fprintf(stderr, "%d\r", count, dirp[0]);
	}
	putc('\n', stderr);
	put_dir_head();
	exit(0);
}

/*
 * get a line of input
 */
GetLine(line)
	char *line;
{
	register int count = 0;
	register int c;
	register int backslash = 0;

	for (c = getchar(); c != EOF && c != '\n'; c = getchar())
	{
		if (backslash)
		{
			if (c == 'n')
				*line++ = '\n';
			else if (c == 't')
				*line++ = ' ';	/* cheating, I know... */
			else
				*line++ = c;
			count++;
			backslash = 0;
		} else if (!(backslash = (c == '\\')))
		{
			*line++ = c;
			count++;
		}
	}
	if (count > BUF_SIZE)
	{
		fprintf(stderr, "Oh no--overflow!\n");
		exit(4);
	}
	if (c == '\n')
		count++;
	*line = 0;
	return (count);
}

/*
 * turn an input line into a dir
 */
TurnIntoDir(line, dirp)
	char	*line;
	char   **dirp;
{
	char	*token;
	char   **origDir = dirp;

	for (token = strtok(line, "\t"); token; token = strtok(0, "\t"))
	{
		if (token[strlen(token) - 1] != ':')
			*dirp++ = token;
	}

	*dirp = 0;
	if (dirp - origDir > DIR_MAX)
	{
		fprintf(stderr, "Oh no--Dir overflow!\n");
		exit(5);
	}
}

/*
 * keep ld happy
 */
cleanup()
{
	exit(100);
}
