/* login.c -- routines to log into the nameserver.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 29 10:48:52 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>

#include "replies.h"
#include "global.h"


/* These popup widgets are global because once created, we save them,
 * and map tham again if the user asks for them.
 */
static Widget login_popup=NULL;
static Widget lhelp_popup=NULL;

/* Save the original calling list from the change routine. */
static Widget caller_widget;
static XtPointer caller_client_data;
static void (*caller_routine)();

/* Prototype some functions. */
void ok(), login_help();
extern void change_password();

/* Some global state and their values. */
int logged_in=0;
#define PSW_LEN 20
char login_password[PSW_LEN+1];

/* We need these global for the Ok callback processing. */
static Widget latext, lptext;

#define LOGIN_WIDTH    200

#define CARET TRUE

void do_login(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget	lform, lalabel, lplabel, lok, lcancel, lhelp;
    Position	x, y;
    Dimension	width, height;

    if (read_only) {
       XawAsciiSaveTextPosition(text);
       XawAsciiAppend(text, "Database is read-only.\n\n");
       XawAsciiRestoreTextPosition(text);
       return;
    }

    /* First things first.  Save our calling sequence to pass to the
     * callback that attempts to login to the nameserver, since it
     * may need to call the change callback if the login is successful.
     * The calling routine is sent as call_data.
     */
    caller_widget = widget;
    caller_client_data = client_data;
    caller_routine = (void *) call_data;

    /* If the widget already exists, great; just pop it back up.
     * Otherwise, create it first.
     */
    if (login_popup == NULL) {
       login_popup = XtVaCreatePopupShell("xph_login",
					  transientShellWidgetClass, widget,
					  XtNtitle, "Xph Login",
					  XtNiconPixmap, icon_pixmap, NULL);

       /* Create a form with a text widget and a dismiss button. */
       lform = XtCreateManagedWidget("lform", formWidgetClass, login_popup,
				     NULL, ZERO);
       
       lalabel = XtCreateManagedWidget("lalabel", labelWidgetClass, lform,
				       NULL, ZERO);
       latext = XtVaCreateManagedWidget("latext", asciiTextWidgetClass, lform,
					XtNwidth, LOGIN_WIDTH,
					XtNstring, login_alias, NULL);
       lplabel = XtCreateManagedWidget("lplabel", labelWidgetClass, lform,
				       NULL, ZERO);
       lptext = XtVaCreateManagedWidget("lptext", asciiTextWidgetClass, lform,
					XtNwidth, LOGIN_WIDTH,
					XtNdisplayCaret, CARET, NULL);
       
       lok = XtCreateManagedWidget("lok", commandWidgetClass, lform, NULL,
				   ZERO);
       XtAddCallback(lok, XtNcallback, ok, (XtPointer) lform);
       lcancel = XtCreateManagedWidget("lcancel", commandWidgetClass, lform,
				       NULL, ZERO);
       XtAddCallback(lcancel, XtNcallback, pop_down_widget, (XtPointer) lform);
       lhelp = XtCreateManagedWidget("lhelp", commandWidgetClass, lform, NULL,
				     ZERO);
       XtAddCallback(lhelp, XtNcallback, login_help, (XtPointer) lform);
    }

    /* Position the widget so that the top right hand corner is in the
     * middle of the calling button.  Since the "help" button is off
     * to the right, that'll put this popup in the middle of the main
     * window, where we like it.  ;-)
     */
    XtVaGetValues(widget, XtNwidth, &width, XtNheight, &height, NULL);
    XtTranslateCoords(widget, (Position) (width / 2),
		      (Position) (height / 2), &x, &y);
    XtVaSetValues(login_popup, XtNx, x-LOGIN_WIDTH, XtNy, y, NULL);

    XtPopup(login_popup, XtGrabExclusive);
}


int is_hero(alias)
char *alias;
{
   int hero=0;

   /* Determine if we are a Hero or not. */
   sprintf(buf, "query alias=%s return hero\n", alias);
   write_ns(buf);
   read_ns(line);
   read_ns(line);
   switch (atoi(line)) {
      case -(LR_OK):
	 hero = atoi(word(line, ':', 3));
	 break;
      case -(LR_ABSENT):
	 break;
      default:
         fprintf(stderr, "is_hero: unexpected response from server:\n   %s\n",
		 line);
         break;
   }
   read_ns(line);
   return(hero);
}


static void
ok(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   String alias, password;

   /* Get the alias and password, request a login from the nameserver.
    * Encrypt and respond to the challenge.  Report a failure to the
    * main output window.
    */
   XtVaGetValues(latext, XtNstring, &alias, NULL);
   XtVaGetValues(lptext, XtNstring, &password, NULL);
   
   if ((! strcmp(alias, "")) || (! strcmp(password, ""))) {
      XawAsciiSaveTextPosition(text);
      XawAsciiAppend(text, "Null alias or password.  Login failed.\n\n");
      XawAsciiSaveTextPosition(text);
   }
   else {
      /* Save the alias and password for posterity. */
      strcpy(login_alias, alias);
      if (strlen(password) > PSW_LEN) {
	 strncpy(login_password, password, PSW_LEN);
      }
      else {
	 strcpy(login_password, password);
      }
      XtVaSetValues(lptext, XtNstring, "", NULL);

      sprintf(buf, "login %s\n", alias);
      write_ns(buf);
      read_ns(buf);
      if (atoi(buf) != LR_LOGIN) {
		 XawAsciiSaveTextPosition(text);
	 XawAsciiAppend(text, "Unexpected response from server:\n   ");
	 XawAsciiAppend(text, buf);
	 XawAsciiRestoreTextPosition(text);
      }
      else {
	 crypt_start(login_password);
	 encryptit(response, word(buf, ':', 1));
	 sprintf(reply, "answer %s\n", response);
	 write_ns(reply);
	 read_ns(buf);
	 if (atoi(buf) != LR_OK) {
	    unbusy_cursor();
	    XawAsciiSaveTextPosition(text);
	    XawAsciiAppend(text, "Login failed.\n\n");
	    XawAsciiRestoreTextPosition(text);
	    XtVaSetValues(lptext, XtNstring, "", NULL);
	 }
	 else {
	    logged_in = 1;
	    
#if 0
	    fprintf(stderr, "ok(do_login): Hero = %d\n", is_hero(alias));
#endif
    
	    /* Extract the original calling parameters sent to the change
	     * callback that got us here.  We notify the callee we called
	     * them by sending a secret message as call_data.
	     */
	    (void) (*caller_routine)((Widget) caller_widget,
				     (XtPointer) caller_client_data,
				     "from_login");
	 }
      }
   }
   
   pop_down_widget((Widget) widget, (XtPointer) client_data, (XtPointer) NULL);
}



#define LHELP_WIDTH  310
#define LHELP_HEIGHT 120

static String lhelp_text =
"Login Help\n\n\
Before editing any fields, we must\n\n\
log into the nameserver, thus\n\
authenticating ourselves.\n\n\
No characters will be seen when\n\
entering the password, for\n\
obvious security reasons.\n\n";

static void
login_help(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget	hform, htext, hdismiss;
    Position	x, y;
    Dimension	width, height;

    if (lhelp_popup == NULL) {
       lhelp_popup = XtVaCreatePopupShell("login_help",
					  transientShellWidgetClass, widget,
					  XtNtitle, "Xph Login Help",
					  XtNiconPixmap, icon_pixmap, NULL);

       /* Create a form with a text widget and a dismiss button. */
       hform = XtCreateManagedWidget("hform", formWidgetClass, lhelp_popup,
				     NULL, ZERO);

       htext = XtVaCreateManagedWidget("htext", asciiTextWidgetClass, hform,
				       XtNwidth, LHELP_WIDTH,
				       XtNheight, LHELP_HEIGHT,
				       XtNdisplayCaret, FALSE,
				       XtNstring, lhelp_text, NULL);
       hdismiss = XtCreateManagedWidget("hdismiss", commandWidgetClass, hform,
					NULL, ZERO);
       XtAddCallback(hdismiss, XtNcallback, pop_down_widget,
		     (XtPointer) hform);

#if 0
       /* Add to the help text: query the server for
	* contact for passwords, ignoring the first few lines from "siteinfo".
	* However, we can't guarantee the server will provide this
	* information in the following format.
	*/
       write_ns("siteinfo\n");
       read_ns(buf);
       read_ns(buf);
       read_ns(buf);
       read_ns(buf);
       sprintf(reply, "To secure a password, contact:\n   %s\n",
	       word(buf, ':', 3));
       XawAsciiAppend(htext, reply);
       read_ns(buf);  /* The OK message. */
#endif
    }

    /* Position the login help widget.*/
    XtVaGetValues(widget, XtNwidth, &width, XtNheight, &height, NULL);
    XtTranslateCoords(widget, (Position) (width / 2),
		      (Position) (height / 2), &x, &y);
    XtVaSetValues(lhelp_popup, XtNx, x-LHELP_WIDTH, XtNy, y, NULL);

    XtPopup(lhelp_popup, XtGrabExclusive);
}
