/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */


#ifndef SENDMAIL



#include "mk.h"
int
main(argc, argv)
int argc;
char *argv[];
{
  int i;
  bool usage;
  char *infilename;
  char *outfilename;
  char *defset;
  FILE *infile;
  FILE *outfile;
  FILE *tmpfile;
  char *tmpfilename;
  char line[BUFSIZE];
  char fromline[BUFSIZE];
  char *script;
  script = NULL;
  usage = FALSE;


/* Parse arguments */
  defset = NULL;
  infilename = NULL;
  outfilename = NULL;
  

  argv[argc] = NULL;
  for (i = 1; i < argc; i++)
    {
      char *arg;
      bool flag;
      arg = argv[i];
      if (*arg == '-') 
	{
	  flag = TRUE;
	  arg++;
	}
      else
	flag = FALSE;
      if (flag)
	switch (*arg) {

	case 'i':
	  if (*(++arg) == '\0')
	    {
	      i++;
	      if (argv[i] == NULL)
		{
		  usage = TRUE;
		  break;
		}
	      else
		infilename = (char *)argv[i];
	      
	    }
	  else
	    infilename = (char *)arg;
	  break;
	case 'o':
	  if (*(++arg) == '\0')
	    {
	      i++;
	      if (argv[i] == NULL)
		{
		  usage = TRUE;
		  break;
		}
	      else
		outfilename = (char *)argv[i];
	    }
	  else
	    outfilename = (char *)arg;
	  break;
	case 'c':
	  if (*(++arg) == '\0')
	    {
	      i++;
	      if (argv[i] == NULL)
		{
		  usage = TRUE;
		  break;
		}
	      else
		defset = (char *)argv[i];
	    }
	  else
	    defset = (char *)arg;
	  break;
	default:
	    usage = TRUE;
	  break;
	}
      else
	{
	  if (argc - 1 == i) 
	    script = (char *)argv[i];
	  else
	    usage = TRUE;
	}

    }
  if (script == NULL)
    usage = TRUE;

  if (usage) {
    fprintf(stderr, 
"USAGE: %s [-i infile] [-o outfile] [-c default_charset] tcl_convert_script\n",
	    argv[0]);
    exit(0);
      }


/* Open required files */

  if (infilename != NULL)
    {
      if ((infile = fopen(infilename, "r")) == NULL)
	{
	  fprintf(stderr, "%s: Unable to open file %s\n", argv[0], infilename);
	  exit(0);
	}
    }
  else
    infile = (FILE *)stdin;

  if (outfilename != NULL)
    {
      if ((outfile = fopen(outfilename, "a")) == NULL)
	{
	  fprintf(stderr, "%s: Unable to open file %s\n", argv[0], outfilename);
	  fclose(infile);
	  exit(0);
	}
    }
  else
    outfile = (FILE *)stdout;

  tmpfilename = newstr(tempnam(EMILTMPDIR, "Emil"));
  if ((tmpfile = fopen(tmpfilename, "w")) == NULL)
    {
      fprintf(stderr, "%s: Unable to open file %s\n", argv[0], tmpfilename);
      fclose(infile);
      fclose(outfile);
      exit(0);
    }


  /* Initialize */

  Mk_Tcl(); 
  
  if (defset)
    MkMess_Root->fcharset = (char *)newstr(defset);


  /* Investigate message and put in tmpfile */

  fromline[0] = '\0';
  linecount = 0;
  MkMess_Curr = MkMess_Root;
  while(fgets(line, BUFSIZE, infile) != NULL)
    {
      fputs(line, tmpfile);
      if (!linecount && !strncasecmp(line, "from ", 5))
	{
	  strcpy(fromline, line);
	  linecount++;
	}
      else
	mkcollect(line, sizeof(line), infile);
    }
  linecount = 0;
  fclose(tmpfile);

  /* Evaluate message */

  MkMess_Curr = MkMess_Root;
  MkMess_Curr->investigate = FALSE;
  mkdeleval(script);


  /* Process conversion */

  if ((tmpfile = fopen(tmpfilename, "r")) == NULL)
    {
      fprintf(stderr, "%s: Unable to open file %s\n", argv[0], tmpfilename);
      fclose(infile);
      fclose(outfile);
      exit(0);
    }

  if (MkMess_Root->dotunnel)
    {
      while (fgets(line, BUFSIZE, tmpfile) != NULL)
	fputs(line, outfile);
    }
  else
    {
      linecount = 0;
      if (fromline[0] != '\0')
	fputs(fromline, outfile);
      MkMess_Curr = MkMess_Root;
      do
	{
	  MkMess_Buf = MkMess_Curr->buf;
	  Mk_Put_Headers(outfile, NULL, TRUE);
	  MkMess_Curr->investigate = FALSE;
	  mkputbodypart(tmpfile, outfile, NULL);
	  MkMess_Curr = MkMess_Curr->next;
	} while (MkMess_Curr);
      if (MkMess_Curr != MkMess_Root && MkMess_Root->dosubheaders)
	while (MkMess_Root->bound != NULL) {
	  char buf[BUFSIZE];
	  char *boundbuf;
	  boundbuf = (char *)getendbound();
	  if (boundbuf) {
	    strcpy(buf, boundbuf);
	    boundbuf = buf;
	    putline(boundbuf, outfile, NULL);
	  }
	  rmlastbound();
	}
    }
  fclose(infile);
  fclose(outfile);
  fclose(tmpfile);
  unlink(tmpfilename);
}


bool
isheader(s)
     register char *s;
{

  if (s == NULL)
    return(NULL);
  while (*s > ' ' && *s != ':' && *s != '\0')
    s++;
  if (*s == '\0')
    return(NULL);
  while (isspace(*s))
    s++;
  if (*s == '\0')
    return(NULL);
  return (*s == ':');
}


  
  

int putline(buf, fp, m)
     char *buf;
     FILE *fp;
     MAILER *m;
{
  char *t;
  if (fputs(buf, fp) == EOF)
    return(0);
  if (index(buf, '\n') == NULL)
    putc('\n', fp);
  return(1);
}
  

#endif
