/* chset.c
 *
 * Reads a character set from stdin converts and outputs to stdout.
 */

#ifndef lint
static char *Rcsid = "@(#)$Header$";

#endif

/*
 *
 * $Log: chset.c,v $
 *
 */

/* #include "sendmail.h" /* */

#include <stdio.h>
#include <errno.h>
#include "iso646.h"
#include "charset.h"

#define SLEN	256		/* max length in octets of images */
static CHARSET *chset;
static CHARSET *ref;
extern struct chdbhdr hdr;

FILE *dfopen();
char *xalloc();

char s ARRAY(80);
char *
mnem(i)
int i;
begin
	*(s+0)= *(ref->cs->out + hdr.basechrs + i%hdr.basechrs);
	*(s+1)= *(ref->cs->out + hdr.basechrs + i/hdr.basechrs);
	*(s+2)= 0;
	if (i > hdr.outsize) sprintf(s,"%d",i);
	return s;
end

void
main (argc, argv)
	int	 argc;
	char   **argv;
begin
	CHAR8U	 s ARRAY(SLEN), r ARRAY(SLEN);
	char us ARRAY(3);
	CHARTAB *t;
	unsigned int i,j,oc;

	(void) strcpy(us, "US");
	ref = getchset (us,DEFAULT_ESCAPE);

	switch (argc) begin

	    case 2:
		chset = getchset (*(argv+1), DEFAULT_ESCAPE);
		break;

	    default:
		printf ("\n\nUsage: %s charset-in   \n\n", *argv);
		exit (1);
	end

	if (chset == NULL ) begin
		printf ("\n\n*** Error: Unknown Charset/s\n\n");
		exit (1);
	end

	t= chset->cs;
	printf("name: %s ",t->name);
	printf("bits=%d  g0= %x  comb=%d\n\n",t->bits,t->g0esc,t->combtabs);
	printf("input:\n");
	for (i = 0; i< 16*(t->combtabs+1); i++) begin
		for (j=0; j<16; j++) begin
			oc= *(t->in + i*16+j);
			printf("%2s ",mnem(oc));
		end
		printf("\n");
	end

	printf("output:\n");
	for (i=0; i < hdr.outsize; i++) begin
		if (t->outbytes== 2) oc= *((INT16S *) t->out + i);
		else oc= *(t->out + i);
		if (oc) printf("%2.2s %.4x\n",mnem(i),oc bitand 0177777);
	end

	exit (0);
end
