'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/option.n,v 1.5 93/04/01 09:52:48 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS option tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
option \- Add/retrieve window options to/from the option database
.SH SYNOPSIS
\fBoption add \fIpattern value \fR?\fIpriority\fR?
.sp
\fBoption clear\fR
.sp
\fBoption get \fIwindow name class\fR
.sp
\fBoption readfile \fIfileName \fR?\fIpriority\fR?
.BE

.SH DESCRIPTION
.PP
The \fBoption\fR command allows you to add entries to the Tk option
database or to retrieve options from the database.  The \fBadd\fR
form of the command adds a new option to the database.
\fIPattern\fR contains
the option being specified, and consists of names and/or classes
separated by asterisks or dots, in the usual X format.  \fIValue\fR
contains a text string to associate with \fIpattern\fR;  this is the
value that will be returned in calls to \fBTk_GetOption\fR or by
invocations of the \fBoption get\fR command.  If \fIpriority\fR
is specified, it indicates the priority level for this option (see
below for legal values);  it defaults to \fBinteractive\fR.
This command always returns an empty string.
.PP
The \fBoption clear\fR command clears the option database.  Default
options (from the
\fBRESOURCE_MANAGER\fR property or the \fB.Xdefaults\fR
file) will be reloaded automatically the next time an
option is added to the database or removed from it.  This command
always returns an empty string.
.PP
The \fBoption get\fR command returns the value of the option
specified for \fIwindow\fR
under \fIname\fR and \fIclass\fR.  If several entries in the option
database match \fIwindow\fR, \fIname\fR, and \fIclass\fR, then
the command returns whichever was created with highest
\fIpriority\fR level.  If there are several matching
entries at the same priority level, then it returns whichever entry
was most recently entered into the option database.  If there are
no matching entries, then the empty string is returned.
.PP
The \fBreadfile\fR form of the command reads \fIfileName\fR,
which should have the standard format for an
X resource database such as \fB.Xdefaults\fR, and adds all the
options specified in that file to the option database.  If \fIpriority\fR
is specified, it indicates the priority level at which to enter the
options;  \fIpriority\fR defaults to \fBinteractive\fR.
.PP
The \fIpriority\fR arguments to the \fBoption\fR command are
normally specified symbolically using one of the following values:
.TP
\fBwidgetDefault\fR
Level 20.  Used for default values hard-coded into widgets.
.TP
\fBstartupFile\fR
Level 40.  Used for options specified in application-specific
startup files.
.TP
\fBuserDefault\fR
Level 60.  Used for options specified in user-specific defaults
files, such as \fB.Xdefaults\fR, resource databases loaded into
the X server, or user-specific startup files.
.TP
\fBinteractive\fR
Level 80.  Used for options specified interactively after the application
starts running.  If \fIpriority\fR isn't specified, it defaults to
this level.
.LP
Any of the above keywords may be abbreviated.  In addition, priorities
may be specified numerically using integers between 0 and 100,
inclusive.  The numeric form is probably a bad idea except for new priority
levels other than the ones given above.

.SH KEYWORDS
database, option, priority, retrieve
