'\"
'\" Copyright (c) 1990-1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/update.n,v 1.5 93/04/01 09:53:02 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS update tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
.VS
update \- Process pending events and/or when-idle handlers
.SH SYNOPSIS
\fBupdate\fR ?\fBidletasks\fR?
.VE
.BE

.SH DESCRIPTION
.PP
This command is used to bring the entire application world
``up to date.''
It flushes all pending output to the display,  waits for the
server to process that output and return errors or events,
handles all pending events of any sort (including when-idle handlers),
and repeats this set of operations until there are no pending
events, no pending when-idle handlers, no pending output to the server,
and no operations still outstanding at the server.  
.PP
If the \fBidletasks\fR keyword is specified as an argument to the
.VS
command, then no new events or errors are processed;  only when-idle
idlers are invoked.
This causes operations that are normally deferred, such as display
updates and window layout calculations, to be performed immediately.
.PP
The \fBupdate idletasks\fR command is useful in scripts where
changes have been made to the application's state and you want those
changes to appear on the display immediately, rather than waiting
for the script to complete.
The \fBupdate\fR command with no options is useful in scripts where
you are performing a long-running computation but you still want
the application to respond to user interactions;  if you occasionally
call \fBupdate\fR then user input will be processed during the
next call to \fBupdate\fR.
.VE

.SH KEYWORDS
event, flush, handler, idle, update
