/*
 * pkg.h --
 *
 *	This file defines the header info for all of the Vu widgets.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: pkg.h,v 1.12 2003/07/09 01:48:36 hobbs Exp $
 */

#ifndef _VU_H_
#define _VU_H_

#include <tk.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

/*
 * Vu widget default characteristics
 */
#include "pkgDefault.h"

/*
 * Tcl/Tk 8.4 introduced better CONST-ness in the APIs, but we use CONST84 in
 * some cases for compatibility with earlier Tcl headers to prevent warnings.
 */
#ifndef CONST84
#  define CONST84
#endif

#ifdef MAC_TCL
#   include <Xatom.h>
#else
#   include <X11/Xatom.h>
#endif /* MAC_TCL */

#ifdef BUILD_vu
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#ifdef _WIN32
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN
/* VC++ has an entry point called DllMain instead of DllEntryPoint */
#   if defined(_MSC_VER)
#	define DllEntryPoint DllMain
#   endif
#endif

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif

#ifndef M_PI
#define M_PI	3.14159265358979323846
#endif /* M_PI */

#ifndef M_PI_2
#define M_PI_2	1.57079632679489661923
#endif

#undef MIN
#define MIN(a, b)	(((a)<(b))?(a):(b))
#undef MAX
#define MAX(a, b)	(((a)>(b))?(a):(b))
#undef ABS
#define ABS(x)		(((x)<0)?(-(x)):(x))
#undef FABS
#define FABS(x) 	(((x)<0.0)?(-(x)):(x))
#undef ROUND
#define ROUND(x)	((int)((x)+(((x)<0.0)?-0.5:0.5)))
#undef EXP10
#define EXP10(x)	(pow(10.0,(x)))

/* Prototypes for each of the widgets. */
EXTERN int	Tk_DialObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
EXTERN int	Tk_PieObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
EXTERN int	Vu_SpinboxObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
EXTERN int	Tk_BargraphObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
#ifdef HAVE_MEGAWIDGET
EXTERN int	Tk_MegawidgetObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
#endif
#ifdef HAVE_COMBOBOX
EXTERN int	Tk_ComboboxObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
#endif

/* in tkCanvUtil.c for canvas items */
extern void	TkiMarkRectangle _ANSI_ARGS_((Display *display,
	Drawable drawable, GC gc, int x1, int y1, int x2, int y2));

/*
 * Prototypes for each of the canvas items.
 */
#if !defined(__WIN32__) && !defined(MAC_TCL) && !defined(MAC_OSX_TK)
#define HAVE_STICKER_ITEM 1
#endif

EXTERN Tk_ItemType TkCanvStripchartType;
EXTERN Tk_ItemType TkCanvBarchartType;
#ifdef HAVE_STICKER_ITEM
EXTERN Tk_ItemType TkCanvStickerType;
#endif
#ifdef HAVE_LABEL_ITEM
EXTERN Tk_ItemType TkCanvLabelType;
#endif

EXTERN Tk_CustomOption customTagsOption;

EXTERN int	Vu_Init _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int	Vu_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));

/*
 * end of header
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _VU_H_ */
