'\"
'\" Copyright (c) Somebody.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: @(#) $Id: charts.man,v 1.1 2001/12/07 21:35:13 hobbs Exp $
'\"
.so man.macros
.TH vu-items n 8.x Tk "Tk Add-On Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
charts \- Create and manipulate canvas Add-On Items
.SH SYNOPSIS
\fBcanvas\fR \fIpathName \fR?\fIoptions\fR? ... see canvas.n

\fBcanvas-pathname \fR create \fIItem \fR?\fIoptions\fR?
.PP
The "vu-items" includes:
.PP
o A "sticker"    canvas item type (tkSticker-1.2.tar.gz)
                 Heribert Dahms
.PP
o A "stripchart" canvas item type (scotty,tkined)
                 Juergen Schoenwaelder
.PP
o A "barchart"   canvas item type (scotty,tkined)
                 Juergen Schoenwaelder

.SO
See canvas.n
.SE

.SH "OVERVIEW OF ITEM TYPES"
.PP
The sections below describe the various types of items supported by canvas
widgets.  Each item type is characterized by two things: first, the form of
the \fBcreate\fR command used to create instances of the type; and second,
a set of configuration options for items of that type, which may be used in
the \fBcreate\fR and \fBitemconfigure\fR widget commands.  Most items don't
support indexing or selection or the commands related to them, such as
\fBindex\fR and \fBinsert\fR.  Where items do support these facilities, it
is noted explicitly in the descriptions below.

.SH "COMMON ITEM OPTIONS"
.PP

.SH "STICKER ITEMS"
.PP
A \fIsticker\fR is a rectangle with text inside but which truncates
if it's too long e.g. after the canvas is scaled. The text can be
drawn vertically and/or repeated. You can also draw a (filled) bar;
we use it showing percentage of a job's completeness. You may use
mouse enter/leave bindings to put the complete text in a status line.

The\fISticker Item\fR has full support for Tk canvas Postscript generation.
.PP
.PP
\fBUSAGE\fR

Creation, given \fBcanvas .c\fR


.CS
\fIpathName \fBcreate sticker \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fF?
.CE
.PP
x1 y1 x2 y2 - just like the canvas rectangle coordinates
.PP
Options (21) with their defaults
.PP
\-anchor    center
        Position as accepted by Tk_GetAnchor for the text.
        Subject to rotation via -orient vertical.
.PP
\-bar       black
        Color as accepted by Tk_GetColor for drawing a bar
        or empty string to suppress drawing.
.PP
\-color     black
        Color as accepted by Tk_GetColor for drawing the
        text or empty string to suppress drawing.
.PP
\-fill      {}
        Color as accepted by Tk_GetColor for filling the
        rectangle x1 y1 x2 y1 or empty string for trans-
        parency.
.PP
\-font      "Helvetica -12"
        Font as accepted by Tk_GetFontStruct for drawing
        text.
.PP
\-lefttrunc 0
        Flag as accepted by Tk_GetBoolean. If true,
        forces that the rightmost part of too long text
        is drawn.
.PP
\-outline   black
        Color as accepted by Tk_GetColor for drawing the
        outline or empty string to suppress drawing.
.PP
.TP
\-relheight 0
.ns
.TP
\-relwidth  0
.ns
.TP
\-relx      0
.ns
.TP
\-rely      0
.ns
.PP
        The above four floating-point numbers define a
        rectangular bar (similar to the Tk placer geome-
        try manager)  relative to the remaining area
        inside of a possibly fat outline.
        Negative numbers or values greater than 1 are
        valid. Only the part of the bar inside the
        "sticker" is drawn, if any. The bar is not drawn
        if either -relwidth or -relheight or both are
        negative. -relx 0 -rely 0 is upper left.
.PP
\-space  0
        Distance as accepted by Tk_GetPixel between
        repeatedly drawn text or 0 if text is to be drawn
        only once.
.PP
\-stipple {}
        Bitmap as accepted by Tk_GetBitmap for filling
        the rectangle with a stipple pattern or empty
        string for solid background. Without -fill
        there's no effect.
.PP
\-tags    {}
        List of tag names. May be empty.
.PP
\-text    {}
        String of characters to be displayed as text.
        May be empty. Text is always drawn solid
        regardless  of -stipple.
.PP
\-width   0
        Width as accepted by Tk_GetPixel for drawing the
        outline.
.PP
\-orient  horizontal
        Specify text orientation as either "horizontal"
        or "vertical". May be abbreviated.
.PP
.TP
\-maxheight 32767
.ns
.TP
\-maxwidth  0
.ns
.TP
\-minheight 32767
.ns
.TP
\-minwidth  0
.ns
.PP
        The above four values as accepted by Tk_GetPixel
        suppress the drawing of the whole sticker if it is
        too small or too large.

\fBNOTES:\fR

Text characters are always entirely drawn or omitted; there are no clipped
partially drawn characters. This works both for fixed and proportional fonts.


Note that the bar specified with -relx, -rely, -relwidth, -relheight does
*not* automatically rotate via -orient vertical unlike the text. If you
need this, you may compute the transformation in a Tcl procedure.

Hint: The -anchor option supersedes -justify of a canvas text item.

Not implemented: Splitting up long text into multiple lines. In case of a
newline either the first or last line will be drawn depending on -lefttrunc.

The following canvas widget commands (for text items) are not supported:
- dchars, focus, icursor, index, insert, select.

.SH "STRIPCHART ITEMS"
.PP

\fIStripchart\fR items  are used to display measured data. They show
values in a X-Y diagram which is scaled automatically. Scale lines indicate
the current scale value. A stripchart object is represented by a Tcl
list containing four elements:


.CS
\fIcanvas-pathName \fBcreate stripchart \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fF?
.CE
.PP
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of the rectangle
(the rectangle will include its upper and left edges but not
its lower or right edges).
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.

The \fIStripchart Item\fR has full support for Tk canvas Postscript generation.
.PP
.PP

\fBUSAGE\fR
.PP
-background    {}
        If empty the item is transparent otherwise opaque
        with the choosen color.
.PP
-fill          black
        The color of each strip can be changed with this
        option. Choosing no color {} makes the strip
        transparent and a line will be drawn in the
        "-stripline" color.
.PP
-jumpscroll    5
        After have been filled by the first time the
        stripchart is moved by the "jumpscroll value"
        left. New values are allways insert to the right
        side.
.PP
-outline        black
        With "outline" the color of the surrounding item
        frame is choosen. No value {} means no frame.
.PP
-scaleline      black
        If one of the shown strips is greater than the
        "scalevalue" the scalevalue is automatically
        increased and a scaleline is drawn. An empty
        value disables the scalline.
.PP
-scalelinestyle 4
        The scalline can be dashed: 4 means: 4 dots
        shown, 4 dots empty. (0 == undashed)
.PP
-scalevalue     100.0
        This floating point value relates to the max Y
        value, before a scaleline is drawn.
.PP
-stripline      {}
        The color of the envelop is choosen with this
        option. An empty value disables the scalline.
.PP
-tags           {}
         List of tag names. May be empty.
.PP
-values         {}
         A list of floating point values is aoutomatically
         allocated. The listlenght equals the following
         formula when one times filled :
          "X dimension -jumpscrol value - 2"
         New values are inserted at the end.
.PP
-selected       0
         Special option for usage within the TkIned
         package.
.PP

.SH "BARCHART ITEMS"
.PP
\fIBarchart\fR items are used to display measured data. They show a set of
values in a barchart diagram. Scale lines indicate the current scale
value. A barchart object is represented by a Tcl list containing four
elements:

.CS
\fIcanvas-pathName \fBcreate barchart \fIx1 y1 x2 y2 \fR?\fIoption value option value ...\fF?
.CE
.PP
The arguments \fIx1\fR, \fIy1\fR, \fIx2\fR, and \fIy2\fR give
the coordinates of two diagonally opposite corners of the rectangle
(the rectangle will include its upper and left edges but not
its lower or right edges).
After the coordinates there may be any number of \fIoption\fR\-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration.

The \fIBarpchart Item\fR has full support for Tk canvas Postscript generation.
.PP
.PP

\fBUSAGE\fR
.PP
\-autocolor      0
         This boolean value "autocolors" the barchart
         item. A scheme of 6 colors is compiled in.
.PP
\-background     {}
         If empty the item is transparent otherwise opaque
         with the choosen color.
.PP
\-barline        black
         If the "value" is greater than the "scalevalue",
         the scalevalue is automatically increased and a
         scaleline is drawn. An empty value disables the
         scalline.
.PP
\-fill           {}
         The color of each strip can be changed with this
         option. Choosing no color {} makes the bar
         transparent and a line will be drawn in the
         "-scaleline" color.
.PP
\-outline        black
         With "outline" the color of the surrounding item
         frame is choosen. No value {} means no frame.
.PP
\-scaleline      black
         If the bar value is greater than the "scalevalue"
         the scalevalue is automatically increased and a
         scaleline is drawn. An empty  value disables the
         scalline.
.PP
\-scalelinestyle 4
         The scalline can be dashed: 4 means: 4 dots
         shown, 4 dots empty. (0 == undashed)
.PP
\-scalevalue     100.0
         This floating point value relates to the max Y
         value, before a scaleline is drawn.
.PP
\-tags           {}
         List of tag names. May be empty.
.PP

\-values         {}
        A list of one floating point value is aoutomati-
        cally  allocated.
.PP
\-selected       0
         Special option for usage within the TkIned
         package.

.SH BINDINGS
.PP
In the current implementation, new canvases are not given any
default behavior:  you'll have to execute explicit Tcl commands
to give the canvas its behavior.

.SH CREDITS
.PP
Tk's canvas widget is a blatant ripoff of ideas from Joel Bartlett's
\fIezd\fR program.  \fIEzd\fR provides structured graphics in a Scheme
environment and preceded canvases by a year or two.  Its simple
mechanisms for placing and animating graphical objects inspired the
functions of canvases.

.SH KEYWORDS
canvas, widget
