# load.tcl
#
# Ensures that the vu library extension is loaded

if {$tcl_platform(platform) == "windows"} {
    set vu(library) vu22[info sharedlibextension]
} else {
    set vu(library) libvu2.2.0[info sharedlibextension]
}
catch {source [file join [file dirname [info script]] .. library dial.tcl]}
if {
    [string match {} [info commands dial]]
    && [catch {package require vu} err]
    && [catch {load {} Vu} err]
    && [catch {load [file join [pwd] $vu(library)]} err]
    && [catch {load [file join [pwd] .. $vu(library)]} err]
} {
    error $err
} else {
    puts "vu v[package provide vu] loaded"
}

catch {
    namespace import -force ::vu::*
}
