'\"
'\" Upgrades to Tk8
'\" Copyright (c) 1998 Jeffrey Hobbs (jeff.hobbs@acm.org)
'\"
'\" This man page was derived from the tk_stripchart.3 man page.
'\" by Francis Gardner.
'\"
'\" 14/10/92
'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\"
'\" Significant modifications and improvements to the original
'\" Victoria University code have been made by Will Deich at
'\" UCO/Lick Observatory (University of California) in Jan 1998.
'\" The bargraph widget source code now differs considerably from
'\" the rest of the VU widget sources.
'/"
'\" Note:  do not modify the .SH NAME line immediately below!
.TH BARGRAPH 1 local
.SH NAME
::vu::bargraph \- Create and manipulate bargraph widgets
.SH SYNOPSIS
\fB::vu::bargraph\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBborderWidth\fR	\fBfont\fR	\fBrelief\fR	\fBcursor\fR
\fBorient\fR	\fBbackground\fR
.fi
.LP
See the \(lqoptions\(rq manual entry for details on the standard options.
.SH WIDGET-SPECIFIC OPTIONS
Since there are quite a few options, they are arranged below in
five sections: general widget configuration options, 
bar configuration options, tick configuration options,
text labelling options, and alternative color options.
.PP
.B "General Widget Configuration"
.HP
.BI \-min\  minval
.br
Specifies the value to be displayed at the bottom (or
the left of a horizontal bargraph) of a bargraph.
If
.I minval
is greater than
.IR maxval
(see \fI\-maxval\fP option),
then the bargraph will grow \(lqbackwards\(rq.
Default is\ 0.0.
.HP
.BI \-max\  maxval
.br
Specifies the value to be displayed at the top (or the
right of a horizontal bargraph) of a bargraph.
If
.I minval
is greater than
.IR maxval ,
then the bargraph will grow \(lqbackwards\(rq.
Default is\ 100.0.
.HP
.BI \-base\  baseval
.br
Specifies where the origin of the bar is. It
should be a value between
.I minval
and
.IR maxval .
By default
.I baseval
is 0.  NOTE: ticks are drawn as offsets from the
.IR baseval .
Therefore, using something like
.ti +0.5i
\-base 33.33 -tickinterval 10
.br
will give tick marks at 33.33, 43.33, 53.33,\ ...
.HP
.BI \-precision\  n
.br
Specifies the maximum number of digits after the decimal point when
displaying floating-point values.  Trailing zeros will be removed.
Default\ 6.
.HP
.BI \-interval\  n
.br
Specifies the time between sucessive callbacks, in
milliseconds.
.HP
.BI \-hpadding\  n
.br
The text elements of the widget are held together by
\(lqglue\(rq that controls their relative positions with regard
to one another and to the central bar area. The hpadding
option can be used to \(lqloosen\(rq the glue (larger values)
and make the elements \(lqexplode\(rq away from each other 
horizontally.  Default 2 pixels.
.HP
.BI \-vpadding\  n
.br
Like hpadding, but controls the vertical \(lqglue\(rq holding
the text elements together.  Default 2 pixels.
.HP
.BI \-data\  sss
.br
A string that can be associated with each
widget. Think of it as a generic attribute.
.HP
.BI \-userbits\  n
.br
An integer that can be associated with each
widget.
.PP
.B "Bar Configuration"
.HP
.BI \-mode\  modename
.br
The bargraph can work in one of two modes: if the
.I modename
is
\(lqbargraph\(rq, the bar grows from the
.I baseval
to the current value.
In mode \(lqslider\(rq, a slider of fixed width travels
along the bar area with its center point indicating the
current value.
.HP
.BI \-width\  n
.br
Specifies the width of a bar in pixels. Default 20 pixels.
.HP
.BI \-height\  n
.br
Specifies the height in pixels a bar should be when
displaying the maximum value (\fIi.e.\fP the maximum height
of a bar). Default 100 pixels.
.HP
.BI \-length\  n
.br
Alias for
.IR \-height .
.HP
\fB\-barbackground\fP\ \fIcolor\fP
.br
Specifies the background color for the bar region.
rendered. On a color display this defaults to gray77 and
on a monochrome display the default is white.
.HP
\fB\-barcolor\fP\ \fIcolor\fP\ or\ \fB\-fg\fP\ \fIcolor\fP\ or\ \fB\-barcolour\fP\ \fIcolor\fP
.br
Specifies the color in which the bargraph bars should be
rendered. On a color display this defaults to red and
on a monochrome display the default is black.
.HP
.BI \-barborderwidth\  n
.br
Specifies the width of a bar border. Default 2 pixels.
.HP
.BI \-barrelief\  relief
.br
Specifies the relief of the bars. Can be one of
\(lqraised\(rq, \(lqgroove\(rq, \(lqsunken\(rq or \(lqflat\(rq. By default the relief is
\(lqgroove\(rq.
.HP
.BI \-sliderlength\  n
.br
If the bargraph is in slider mode (see \fI\-mode\fP), the length of
the slider (in pixels) is set by this option.  Default 10 pixels.
.PP
.B "Tick Configuration"
.HP
\fB\-tickcolor\fP\ \fIcolor\fP\ or\ \fB\-tickcolour\fP\ \fIcolor\fP
.br
Specifies the color in which bargraph ticks should be rendered.
On a color display this defaults to blue2 and
on a monochrome display the default is black.
.HP
.BI \-tickinterval\  n
.br
Specifies the interval between successive ticks.  Default 20.0.
The default doesn't depend on the range of data, and if there are too
many pixels, the widget will generate an error and you will have to
increase the
.IR \-tickinterval .
Use a
.I \-tickinterval
of 0 to indicate no ticks at all.
Note: this doesn't affect the ticks drawn with the
.I \-alabels
or
.I \-blabels
options.
.HP
.BI \-ticklength\  n
.br
Specifies the length of all tick marks.  Default 4 pixels.
.PP
.B "Text Label Configuration"
.HP
\fB\-textcolor\fP\ \fIcolor\fP\ or\ \fB\-textcolour\fP\ \fIcolor\fP
.br
Specifies the color in which bargraph text should be rendered.
On both color and monochrome displays this defaults to black.
.HP
.BI \-title\  txt
.br
This string is placed at the top of the widget as the
widget's title.  By default there is no title.
Specifying a blank title (\fB\-title\ {}\fP) will remove the title.
.HP
.B \-showminmax\  bool
.br
By default, the
.I minval
and
.I maxval
values are labelled at the appropriate ends of the bar area.
Setting
.I "\-showminmax 0"
will suppress these labels.
.HP
.BI \-showvalue\  bool
.br
By default, the current value to which the bargraph is set
will be labelled near the
left or bottom end of the bargraph area.
Setting
.I "\-showvalue 0"
will suppress this label.
.HP
.BI \-alabels\  LabelList
.br
In addition to the regularly-spaced ticks that can be controlled
with the
.I \-tickinterval
option, arbitrarily-positioned labels and/or ticks can be placed
along the length of the bar.
The
.I LabelList
specifies positions, labels, and ticks along the top [left] side of the bar
for horizontal [vertical] bars.
(See also the
.I \-blabels
option for the right or bottom side of the bar.)
.I LabelList
is a Tcl compound list:
.ti +0.2i
\-alabels { {\fIposn\fP \fItxt\fP ?usetick?} ...}
.br
where
.I posn
is a value between the
.I minval
and
.I maxval
of the widget,
.I txt
is a text string to be drawn beside that position, and
.I usetick
is a boolean flag which if set indicates that a tick mark
should be placed at
.IR posn .
.br
Note: this option does not affect the regularly-spaced ticks
that are controlled with the
.I \-tickinterval
option.
.br
Example:
.ti +0.5i
\-alabels {{20 start 1} {40 "halfway"} {60 end 1}}
.br
This will cause labels to be written beside positions 20, 50, and 60.
Ticks will additionally be drawn at positions 20 and 60.
.HP
.BI \-blabels\  LabelList
.br
Like
.IR \-alabels ,
except it is for the right [bottom] side of the bar when the orientation
is vertical [horizontal].
.HP
.BI \-alabfont\  font
.br
The font used for the
.I \-alabels
text.
.HP
.BI \-blabfont\  font
.br
The font used for the
.I \-blabels
text.
.PP
.SH DESCRIPTION
.PP
The \fB::vu::bargraph\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a bargraph widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the bargraph
such as its colors, font, text, and initial relief.  The
\fB::vu::bargraph\fR command returns its \fIpathName\fR argument.  At the
time this command is invoked, there must not exist a window named
\fIpathName\fR, but \fIpathName\fR's parent must exist.
.PP
A bargraph is a widget that displays a value as a bargraph.
.SH "WIDGET COMMAND"
.PP
The \fB::vu::bargraph\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for bargraph widgets:
.TP
\fIpathName \fBset\fR ?\fIvalue\fR?
Display a bar whose height represents the specified value.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given by
.IR option .
.I Option
may have any of the values accepted by the
.I ::vu::bargraph
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.  If
no \fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fB::vu::bargraph\fR command.
.TP
\fIpathName \fBget\fR
Returns the current value of the bargraph.
.PP
.SH KEYWORDS
bargraph, widget
