'\" $Id: paned.n,v 1.2 2005/12/07 23:53:23 jenglish Exp $
'\" Copyright (c) 2005 Joe English
.so man.macros
.TH paned n 0.7 tile "Tile Widget Set"
.BS
.SH "NAME"
ttk::paned \- Multi-pane container window
.SH SYNOPSIS
.nf
\fBttk::paned\fR \fIpathName \fR?\fIoptions\fR?
.br
\fIpathName \fBadd \fIpathName\fR.\fIsubwindow\fR ?\fIoptions...\fR?
\fIpathName \fBinsert \fIindex \fIpathName\fR.\fIsubwindow\fR ?\fIoptions...\fR?
.fi
.BE
.SH "DESCRIPTION"
A paned widget displays a number of subwindows,
stacked either vertically or horizontally.  
The user may adjust the relative sizes of the subwindows
by dragging the sash between panes.
.SO
\-class	\-cursor	\-takefocus	\-style
.SE
.SH "WIDGET OPTIONS"
.OP \-orient orient Orient
Specifies the orientation of the window.
If \fBvertical\fP, subpanes are stacked top-to-bottom;
if \fBhorizontal\fP, subpanes are stacked left-to-right.
.SH "PANE OPTIONS"
The following options may be specified for each pane:
.OP \-weight weight Weight
An integer specifying the relative stretchability of the pane.
When the paned window is resized, the extra space is added
or subracted to each pane proportionally to its \fB-weight\fP.
.SH "WIDGET COMMAND"
Supports the standard \fBconfigure\fR, \fBcget\fR, \fBstate\fP, 
and \fBinstate\fR commands; see \fIwidget(n)\fR for details.
Additional commands:
.TP
\fIpathname\fR \fBadd\fR \fIsubwindow\fR \fIoptions...\fR
Adds a new pane to the window.
\fIsubwindow\fR must be a direct child of the paned window \fIpathname\fR.
See \fBPANE OPTIONS\fR for the list of available options.
.TP
\fIpathname \fBforget \fIpane\fR
Removes the specified subpane from the widget.
\fIpane\fR is either an integer index or the name of a managed subwindow.
.TP
\fIpathname \fBinsert\fR \fIpos\fR \fIsubwindow\fR \fIoptions...\fR
Inserts a pane at the specified position.
\fIpos\fR is either the string \fBend\fR, an integer index, 
or the name of a managed subwindow.
If \fIsubwindow\fR is already managed by the paned window, 
moves it to the specified position.
See \fBPANE OPTIONS\fR for the list of available options.
.TP
\fIpathname \fBpane \fIpane -option \fR?\fIvalue \fR?\fI-option value...\fR
Query or modify the options of the specified \fIpane\fR,
where \fIpane\fR is either an integer index or the name of a managed subwindow.
If no \fI-option\fR is specified, returns a dictionary of the pane 
option values.
If one \fI-option\fP is specified, returns the value of that \fIoption\fR.
Otherwise, sets the \fI-option\fRs to the corresponding \fIvalue\fRs.
.SH "INTERNAL ROUTINES"
The following routines are used internally by the \fBpaned\fR widget
binding code.
.TP
\fIpathname\fR \fBsashpos\fR \fIindex\fR ?\fInewpos\fR?
If \fInewpos\fR is specified, sets the sash position 
(subject to constraints).
Returns the position of sash number \fIindex\fR.
.TP
\fIpathname\fR \fBidentify\fR \fIx y\fR
Returns a list consisting of the sash index at point \fIx,y\fR
and the name of the sash subelement at that point.
Returns the empty list if \fIx,y\fR is not over a sash.
.SH "SEE ALSO"
\fIwidget(n)\fR, \fInotebook(n)\fR.
