##############################################################################
#
#   File: Fibb_001.tcl
#   Fibonacci sequence benchmark.
#
##############################################################################
#
#   Copyright (c) 2000 David Cuthbert / Kanga International Group.
#   All rights reserved.
#
#   Permission to use, copy, modify, distribute and sell this software
#   and its documentation for any purpose is hereby granted without fee,
#   provided that the above copyright notice appear in all copies and
#   that both that copyright notice and this permission notice appear
#   in supporting documentation.  The author(s) make no representations
#   about the suitability of this software for any purpose.  It is 
#   provided "as is" without express or implied warranty.
#
##############################################################################

package require kt2c

set base   Fibb_001

proc Fibb {nterms} {
    set last   0
    set result 1

    for {set i 0} {$i < $nterms} {incr i} {
	set next_last $result
	set result [expr {$result + $last}]
	set last $next_last
    }

    return $result
}

puts "Starting"
puts "Normal test: [kt2c::CpuTime {Fibb 10} 10000]"

set ccode [kt2c::Translate Fibb]

set fd [open ${base}.c w]
puts $fd [kt2c::FileHeader]
puts $fd [lindex $ccode 1]
puts $fd ""
puts $fd [kt2c::LibraryInitialiser $base [lindex $ccode 0]]
close $fd

set libname [kt2c::Compile ${base}.c]
load ${libname} ${base}

puts "Compiled test: [kt2c::CpuTime {Fibb 10} 10000]"
