/*****************************************************************************
 *
 *  File: vm.h
 *  Tcl virtual machine state handler
 *
 *****************************************************************************
 *
 *  Copyright (c) 2000 David Cuthbert / Kanga International Group.
 *  All rights reserved.
 *
 *  Permission to use, copy, modify, distribute and sell this software
 *  and its documentation for any purpose is hereby granted without fee,
 *  provided that the above copyright notice appear in all copies and
 *  that both that copyright notice and this permission notice appear
 *  in supporting documentation.  The author(s) make no representations
 *  about the suitability of this software for any purpose.  It is 
 *  provided "as is" without express or implied warranty.
 *
 *****************************************************************************/

#ifndef VM_H
#define VM_H

#include "tclInt.h"
#include "tclCompile.h"

typedef enum { vsUnused = 0, vsInt = 1, vsDouble = 2, vsNumeric = 3, 
	       vsUnknown = -1 } 
Kanga_VarState;

typedef struct Kanga_VmState    Kanga_VmState;
typedef struct Kanga_InstrState Kanga_InstrState;

struct Kanga_VmState {
    Kanga_VmState  *prev;
    Kanga_VmState  *nextState[2];
    Kanga_VmState  *nextSibling;
    Kanga_InstrState *instr;
    int             valid;
    int             stackSize;
    Kanga_VarState *stackState;
    Kanga_VarState *scalarState;
};

/* Methods */
Kanga_VmState *
Kanga_VmState_Create(Kanga_InstrState *instr);

Kanga_VmState *
Kanga_VmState_CreateFrom(Kanga_VmState const *original);

void
Kanga_VmState_CopyStack(Kanga_VmState *dest, Kanga_VmState const *src);

void
Kanga_VmState_CopyScalar(Kanga_VmState *dest, Kanga_VmState const *src);

void
Kanga_VmState_Delete(Kanga_VmState *);

int
Kanga_VmState_Equal(Kanga_VmState const *v1, Kanga_VmState const *v2);


struct Kanga_InstrState {
    struct Kanga_CodeAccum  *ca;
    Kanga_InstrState *nextInstr[2];
    Kanga_VmState    *firstVmState;
    int  offset;
    int  instruction;
    int  op[MAX_INSTRUCTION_OPERANDS];
};


Kanga_InstrState *
Kanga_InstrState_Create(struct Kanga_CodeAccum *ca);

Kanga_InstrState *
Kanga_InstrState_CreateArray(struct Kanga_CodeAccum *ca, int nelements);

void
Kanga_InstrState_Delete(Kanga_InstrState *);

Kanga_VmState *
Kanga_InstrState_VmStateExists(Kanga_InstrState *this, 
			       Kanga_VmState const *compare);

void
Kanga_InstrState_Imbue(Kanga_InstrState *this,
		       Kanga_VmState *vms);

#endif

