#include "kt2c.h"
#include "vm.h"
#include "tcl.h"

static Kanga_VmState *
DoVmStateExists(Kanga_VmState const *compare,
		Kanga_VmState *current);

Kanga_VmState *
Kanga_VmState_Create(struct Kanga_InstrState *instr)
{
    Kanga_VmState *this = (Kanga_VmState *)ckalloc(sizeof(Kanga_VmState));
    int i;
    Kanga_CodeAccum *ca = instr->ca;

    this->prev = 0;
    this->nextState[0] = 0;
    this->nextState[1] = 0;
    this->nextSibling = 0;
    this->instr = instr;
    this->valid = 0;
    this->stackSize = -1;
    this->stackState = (Kanga_VarState *)
	ckalloc(sizeof(Kanga_VarState) * (ca->bc->maxStackDepth + 1));
    this->scalarState = (Kanga_VarState *)
	ckalloc(sizeof(Kanga_VarState) * ca->procPtr->numCompiledLocals);

    for(i = 0; i <= ca->bc->maxStackDepth; i++)
	this->stackState[i] = vsUnknown;

    for(i = 0; i < ca->procPtr->numCompiledLocals; i++)
	this->scalarState[i] = vsUnknown;

    return this;
}


Kanga_VmState *
Kanga_VmState_CreateFrom(Kanga_VmState const *original)
{
    Kanga_VmState *this = (Kanga_VmState *)ckalloc(sizeof(Kanga_VmState));
    int i;
    Kanga_CodeAccum *ca = original->instr->ca;

    this->prev = 0;
    this->nextState[0] = original->nextState[0];
    this->nextState[1] = original->nextState[1];
    this->nextSibling = original->nextSibling;
    this->instr = original->instr;
    this->valid = original->valid;
    this->stackSize = original->stackSize;
    this->stackState = (Kanga_VarState *)
	ckalloc(sizeof(Kanga_VarState) * (ca->bc->maxStackDepth + 1));
    this->scalarState = (Kanga_VarState *)
	ckalloc(sizeof(Kanga_VarState) * ca->procPtr->numCompiledLocals);

    for(i = 0; i <= ca->bc->maxStackDepth; i++)
	this->stackState[i] = original->stackState[i];

    for(i = 0; i < ca->procPtr->numCompiledLocals; i++)
	this->scalarState[i] = original->scalarState[i];

    return this;
}


void
Kanga_VmState_CopyStack(Kanga_VmState *dest, Kanga_VmState const *src)
{
    int i;
    
    for(i = 0; i <= src->instr->ca->bc->maxStackDepth; i++)
	dest->stackState[i] = src->stackState[i];

    return;
}


void
Kanga_VmState_CopyScalar(Kanga_VmState *dest, Kanga_VmState const *src)
{
    int i;
    
    for(i = 0; i < src->instr->ca->procPtr->numCompiledLocals; i++)
	dest->scalarState[i] = src->scalarState[i];

    return;
}



void
Kanga_VmState_Delete(Kanga_VmState *this)
{
    if(this) {
	ckfree((char *)this->stackState);
	ckfree((char *)this->scalarState);
	ckfree((char *)this);
    }

    return;
}


int Kanga_VmState_Equal(Kanga_VmState const *v1, Kanga_VmState const *v2)
{
    if(v1->instr == v2->instr &&
       v1->valid == v2->valid &&
       v1->stackSize == v2->stackSize)
    {
	int i;
	for(i = 0; i <= v1->instr->ca->bc->maxStackDepth; i++)
	    if(v1->stackState[i] != v2->stackState[i]) return 0;
	
	for(i = 0; i < v1->instr->ca->procPtr->numCompiledLocals; i++)
	    if(v1->scalarState[i] != v2->scalarState[i]) return 0;

	if((v1->nextState[0] == 0 || v2->nextState[0] == 0 ||
	    v1->nextState[0] == v2->nextState[0]) &&
	   (v1->nextState[1] == 0 || v2->nextState[1] == 0 ||
	    v1->nextState[1] == v2->nextState[1]))
	   return 1;
    }

    return 0;
}


Kanga_InstrState *
Kanga_InstrState_Create(Kanga_CodeAccum *ca)
{
    Kanga_InstrState *this = (Kanga_InstrState *)
	ckalloc(sizeof(Kanga_InstrState));

    this->ca = ca;
    this->nextInstr[0] = 0;
    this->nextInstr[1] = 0;
    this->firstVmState = 0;
    this->offset = 0;
    this->instruction = -1;

    return this;
}


Kanga_InstrState *
Kanga_InstrState_CreateArray(Kanga_CodeAccum *ca, int nelements)
{
    Kanga_InstrState *array = (Kanga_InstrState *)
	ckalloc(sizeof(Kanga_InstrState) * nelements);
    int i;

    for(i = 0; i < nelements; ++i) {
	Kanga_InstrState *this = array + i;
	this->ca = ca;
	this->nextInstr[0] = 0;
	this->nextInstr[1] = 0;
	this->firstVmState = 0;
	this->offset = 0;
	this->instruction = -1;
    }

    return array;
}


void
Kanga_InstrState_Delete(Kanga_InstrState *this)
{
    if(this) ckfree((char *)this);
    return;
}


Kanga_VmState *
Kanga_InstrState_VmStateExists(Kanga_InstrState *this, 
			       Kanga_VmState const *compare)
{
    Kanga_VmState *vms = this->firstVmState;
    if(vms == 0) return 0;
    else         return DoVmStateExists(compare, vms);
}


void
Kanga_InstrState_Imbue(Kanga_InstrState *this,
		       Kanga_VmState *vms)
{
    if(this->firstVmState == 0) this->firstVmState = vms;
    else {
	Kanga_VmState *current = this->firstVmState;
	Kanga_VmState *next = current->nextSibling;
	
	while(next != 0) {
	    current = next;
	    next = next->nextSibling;
	}

	current->nextSibling = vms;
    }

    return;
}


static Kanga_VmState *
DoVmStateExists(Kanga_VmState const *compare,
		Kanga_VmState *current)
{
    if(Kanga_VmState_Equal(compare, current)) return current;
    if(current->nextState[0] != 0) {
	if(DoVmStateExists(compare, current->nextState[0]) != 0)
	    return current->nextState[0];
    }
    if(current->nextState[1] != 0) {
	if(DoVmStateExists(compare, current->nextState[1]) != 0)
	    return current->nextState[1];
    }

    return NULL;
}
