tcltest::test 8.1.1.1-1 { declare an abstract class } {
    compile [saveas AbstractClass.java "public abstract class AbstractClass {}"]
} PASS

tcltest::test 8.1.1.1-2 { Compile time error on attempt to
        create an instance of an abstract class } {
    saveas AbstractClass_CreateInstanceError.java \
{
public class AbstractClass_CreateInstanceError {
    Object o = new AbstractClass();
}
}

    compile AbstractClass.java AbstractClass_CreateInstanceError.java
} FAIL

# These next two could also be covered in 8.4.3.1 (abstract methods)

tcltest::test 8.1.1.1-3 { declare an abstract class with an abstract method } {
    compile [saveas AbstractMethodAbstractClass.java \
{
public abstract class AbstractMethodAbstractClass {
    abstract void foo();
}
}]
} PASS

tcltest::test 8.1.1.1-4 { a non-abstract class can not have an abstract method } {
    compile [saveas AbstractMethodNonAbstractClass.java \
{
public class AbstractMethodNonAbstractClass {
    abstract void foo();
}
}]
} FAIL

tcltest::test 8.1.1.1-5 { An attempt to inherit from an abstract superclass containing
        an abstract method without implementing the abstract method or declaring
        the subclass abstract should generate a compile time error } {
    saveas InheritAbstractClassError.java \
{
abstract class InheritAbstractClassError_Superclass {
    abstract void foo();
}

public class InheritAbstractClassError extends InheritAbstractClassError_Superclass {}
}

    compile InheritAbstractClassError.java
} FAIL

tcltest::test 8.1.1.1-6 { An attempt to inherit from an abstract superclass that
        extends another class that has an abstract method without implementing the abstract
        method or declaring the subclass abstract should generate a compile time error } {
    saveas DoubleInheritAbstractClassError.java \
{
abstract class DoubleInheritAbstractClassError_Superclass1 {
    abstract void foo();
}

abstract class DoubleInheritAbstractClassError_Superclass2 extends
    DoubleInheritAbstractClassError_Superclass1 {}

public class DoubleInheritAbstractClassError extends DoubleInheritAbstractClassError_Superclass2 {}
}

    compile DoubleInheritAbstractClassError.java
} FAIL

tcltest::test 8.1.1.1-7 { inherit from an abstract class with an
        abstract method, the subclass must be marked as abstract } {
    saveas InheritAbstractClass.java \
{
abstract class InheritAbstractClass_Superclass {
    abstract void foo();
}

public abstract class InheritAbstractClass extends InheritAbstractClass_Superclass {}
}

    compile InheritAbstractClass.java
} PASS

tcltest::test 8.1.1.1-8 { Compile time error on attempt to create an instance
        of an abstract class that inherits from and abstract class } {
    saveas InheritAbstractClass_CreateInstanceError.java \
{
public class InheritAbstractClass_CreateInstanceError {
    Object o = new InheritAbstractClass();
}
}

    compile InheritAbstractClass.java InheritAbstractClass_CreateInstanceError.java
} FAIL

tcltest::test 8.1.1.1-9 { It should be possible to inherit from an abstract class
        that defines no abstract methods, the subclass does not need to be abstract } {
    compile [saveas InheritEmptyAbstractClass.java \
{
abstract class InheritEmptyAbstractClass_Superclass {}

public class InheritEmptyAbstractClass extends InheritEmptyAbstractClass_Superclass {}
}]
} PASS

tcltest::test 8.1.1.1-10 { Inherit from an abstract class with no methods that also
        inherits from an abstract class with no methods, subclass does not need to be abstract } {
    saveas DoubleInheritEmptyAbstractClass.java \
{
abstract class DoubleInheritEmptyAbstractClass_Superclass1 {}
abstract class DoubleInheritEmptyAbstractClass_Superclass2 extends
    DoubleInheritEmptyAbstractClass_Superclass1 {}

public class DoubleInheritEmptyAbstractClass extends DoubleInheritEmptyAbstractClass_Superclass2 {}
}

    compile DoubleInheritEmptyAbstractClass.java
} PASS

tcltest::test 8.1.1.1-11 { Implement an abstract method inherited from an abstract superclass } {
  saveas ImplementInheritedAbstractMethod.java \
{
abstract class ImplementInheritedAbstractMethod_Superclass1 {
    abstract void foo();
}

abstract class ImplementInheritedAbstractMethod_Superclass2 extends
    ImplementInheritedAbstractMethod_Superclass1 {}

public class ImplementInheritedAbstractMethod
    extends ImplementInheritedAbstractMethod_Superclass2 {
    void foo() {}
}
}

  compile ImplementInheritedAbstractMethod.java
} PASS

# This next one is mentioned in 8.1.1.1 but is is actually a generic return type conflict.

tcltest::test 8.1.1.1-12 { A compile time error should be generated in the case that
        an abstract class has two methods with the same signature but different return
        types, this would create an abstract class that could not be sub-classed } {
    saveas InterfaceSignatureConflict.java \
{
interface InterfaceSignatureConflict_Inter {
    void foo();
}

public abstract class InterfaceSignatureConflict implements InterfaceSignatureConflict_Inter {
    public abstract int foo();
}
}

    compile InterfaceSignatureConflict.java
} FAIL
