/*
 * t4cinit.c --
 *
 *	Implementation of the T4Graph initialization procedures.
 *	This must be in "C" so that Tcl can find the exported functions
 *	reliably.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "t4graph_c.h"

/*
 * Tgraph_Init --
 *
 *	This procedure initializes the T4Graph package in an interpreter.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	Creates a "t4graph" namespace and several commands within the
 *	namespace in the given interpreter.
 */

extern DLLEXPORT int
Tgraph_Init(Tcl_Interp *interp)
{
    return Tgraph_RealInit(interp);
}

extern DLLEXPORT int
Tgraphd_Init(Tcl_Interp *interp)
{
    return Tgraph_RealInit(interp);
}

/*
 * Tgraph_SafeInit --
 *
 *	This procedure initializes the T4Graph package in a
 *	safe interpreter.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	Creates a "t4graph" namespace and several commands within the
 *	namespace in the given safe interpreter.
 */

extern DLLEXPORT int
Tgraph_SafeInit(Tcl_Interp *interp)
{
    return Tgraph_Init(interp);
}

extern DLLEXPORT int
Tgraphd_SafeInit(Tcl_Interp *interp)
{
    return Tgraph_Init(interp);
}
