/*
 * j4graph.h --
 *
 *	This file is the main include file for the J4Graph package.
 *
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__J4GRAPH_H__
#define __J4GRAPH_H__

/*
 * Include the header files for all the classes of the J4Graph package:
 */

#include "com_e4graph_IncorrectVertexTypeException.h"
#include "com_e4graph_InvalidPositionException.h"
#include "com_e4graph_NoSuchNodeException.h"
#include "com_e4graph_NoSuchVertexException.h"
#include "com_e4graph_Node.h"
#include "com_e4graph_ParentIterator.h"
#include "com_e4graph_Storage.h"
#include "com_e4graph_StorageCreationException.h"
#include "com_e4graph_StorageIsNotOpenException.h"
#include "com_e4graph_StorageIterator.h"
#include "com_e4graph_Value.h"
#include "com_e4graph_Vertex.h"
#include "com_e4graph_VertexIterator.h"

/*
 * Extern declarations for all package-wide classes, field IDs, and method IDs.
 */

extern jclass	clsStorageCreationException;
extern jclass	clsStorageIsNotOpenException;
extern jclass	clsIncorrectVertexTypeException;
extern jclass	clsInvalidPositionException;
extern jclass	clsNoSuchNodeException;
extern jclass	clsNoSuchVertexException;

extern jclass	clsStorage;
extern jclass	clsNode;
extern jclass	clsValue;
extern jclass	clsVertex;

extern jmethodID storageCreationExceptionCMID;
extern jmethodID storageIsNotOpenExceptionCMID;
extern jmethodID incorrectVertexTypeExceptionCMID;
extern jmethodID invalidPositionExceptionCMID;
extern jmethodID noSuchNodeExceptionCMID;
extern jmethodID noSuchVertexExceptionCMID;

extern jmethodID storageCMID;
extern jmethodID nodeCMID;
extern jmethodID valueCMID;
extern jmethodID vertexCMID;

extern jfieldID	sIndexID;
extern jfieldID nIndexID;
extern jfieldID nsIndexID;
extern jfieldID vIndexID;
extern jfieldID vsIndexID;

extern jfieldID typeID;
extern jfieldID integerValueID;
extern jfieldID doubleValueID;
extern jfieldID stringValueID;
extern jfieldID bytesValueID;
extern jfieldID nodeValueID;

/*
 * APIs to get cached entities:
 */

extern bool	GetValidStorage(JNIEnv *envp, int i, int g, e4_Storage &ss);
extern void	SetValidStorage(JNIEnv *envp, int i, int g, e4_Storage s);
extern bool	GetValidNode(JNIEnv *envp, int s, int g, int n, 
			     e4_Node &nn);
extern bool	GetValidVertex(JNIEnv *envp, int s, int g, int n,
			       e4_Vertex &vv);

#endif	/* __J4GRAPH_H__ */
