#/bin/csh -f
#
# This shell script builds a distribution of e4Graph. It is mainly intended
# for use by the package maintainers (that's me! :)
#
# Run this with 'csh build_dist.csh'.
#
# Copyright (c) 2000-2003, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
# JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.

# ROOTDIR:
#
# The root dir, below which everything else is on-disk:

# Comment this out if not on cf.sourceforge.net:
# set ROOTDIR=/home/users/j/jy/jyljyljyl/compile

# Comment this out if not on mod3.net:
# set ROOTDIR=/home/jyl/devel
set ROOTDIR=`pwd`/../..

# Comment this out if not on munchkins:
# set ROOTDIR=/Users/jyl/devel

# E4GVERSION:
#
# The version of e4Graph we're distributing.

set E4GVERSION=e4graph-1.0a11

# SHLIB_EXT:
#
# The extension of shared libraries on this system.

# Use this on Unix:
set SHLIB_EXT=.so

# Use this on MacOS X:
# set SHLIB_EXT=.dylib

###########################################################################
#
# DO NOT CHANGE ANYTHING BELOW THIS LINE:
#
###########################################################################

# SRCTREE:
#
# The place on-disk where the materials are that will go in to the
# distribution:

set SRCTREE=$ROOTDIR/install

# INSTALLDIST:
#
# The directory where we will build the e4Graph distribution.

set INSTALLDIST=$ROOTDIR/dist

# Where are the locally installed materials:

set LOCALINSTALL=$ROOTDIR/install

# BELOW THIS LINE you will probably not want to change things:

set INCLUDES=$LOCALINSTALL/include
set LIBS=$LOCALINSTALL/lib

set E4GSRC=$ROOTDIR/$E4GVERSION
set E4GDIST=$INSTALLDIST/$E4GVERSION

# Ensure directory structure is set up:

/bin/rm -rf $E4GDIST
mkdir -p $E4GDIST/include $E4GDIST/lib $E4GDIST/docs

# Copy various things into the distribution:

cp $E4GSRC/changes $E4GSRC/INSTALL $E4GSRC/readme \
   $E4GSRC/readme.html $E4GDIST
cp -r $E4GSRC/docs/* $E4GDIST/docs
cp $INCLUDES/e4graph.h $INCLUDES/t4graph.h $INCLUDES/t4graph_c.h \
   $INCLUDES/e4xml.h $INCLUDES/t4xml_c.h $INCLUDES/e4py.h $E4GDIST/include
cd $E4GDIST/lib
cp $LIBS/libtxml${SHLIB_EXT}.0.0.0 \
   $LIBS/libtgraph${SHLIB_EXT}.0.0.0 \
   $E4GSRC/all/pkgIndex.tcl \
   $LIBS/libe4xml${SHLIB_EXT}.0.0.0 \
   $LIBS/libe4graph${SHLIB_EXT}.0.0.0 \
   $LIBS/libe4py${SHLIB_EXT}.0.0.0 \
   $LIBS/e4java.jar \
   $LIBS/libe4java${SHLIB_EXT}.0.0.0 .
ln -s libtxml${SHLIB_EXT}.0.0.0 libtxml${SHLIB_EXT}
ln -s libtxml${SHLIB_EXT}.0.0.0 libtxml${SHLIB_EXT}.0
ln -s libtgraph${SHLIB_EXT}.0.0.0 libtgraph${SHLIB_EXT}
ln -s libtgraph${SHLIB_EXT}.0.0.0 libtgraph${SHLIB_EXT}.0
ln -s libe4xml${SHLIB_EXT}.0.0.0 libe4xml${SHLIB_EXT}
ln -s libe4xml${SHLIB_EXT}.0.0.0 libe4xml${SHLIB_EXT}.0
ln -s libe4graph${SHLIB_EXT}.0.0.0 libe4graph${SHLIB_EXT}
ln -s libe4graph${SHLIB_EXT}.0.0.0 libe4graph${SHLIB_EXT}.0
ln -s libe4java${SHLIB_EXT}.0.0.0 libe4java${SHLIB_EXT}
ln -s libe4java${SHLIB_EXT}.0.0.0 libe4java${SHLIB_EXT}.0
ln -s libe4py${SHLIB_EXT}.0.0.0 libe4py${SHLIB_EXT}
ln -s libe4py${SHLIB_EXT}.0.0.0 libe4py${SHLIB_EXT}.0
