/*
 * Decompiled with CFR 0.152.
 */
package com.e4graph;

import com.e4graph.NoSuchVertexException;
import com.e4graph.Node;
import com.e4graph.Vertex;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class VertexIterator
implements Iterator {
    private int vertexType = -1;
    private String vertexName = null;
    private Vertex current = null;
    private Vertex next = null;
    private Node node = null;

    public VertexIterator(Node node) {
        this.node = node;
        try {
            this.computeCurrent();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.current = null;
        }
    }

    public VertexIterator(Node node, int n) {
        this.node = node;
        this.vertexType = n;
        try {
            this.computeCurrent();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.current = null;
        }
    }

    public VertexIterator(Node node, String string) {
        this.node = node;
        this.vertexName = string;
        try {
            this.computeCurrent();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.current = null;
        }
    }

    public VertexIterator(Node node, String string, int n) {
        this.node = node;
        this.vertexName = string;
        this.vertexType = n;
        try {
            this.computeCurrent();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.current = null;
        }
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("remove() not supported");
    }

    public boolean hasNext() {
        if (this.current == null) {
            return false;
        }
        try {
            this.computeNext();
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public Object next() throws NoSuchElementException {
        this.computeNext();
        this.current = this.next;
        this.next = null;
        return this.current;
    }

    private void computeCurrent() throws NoSuchElementException {
        try {
            this.current = this.node.getVertexByRank(1);
        }
        catch (NoSuchVertexException noSuchVertexException) {
            throw new NoSuchElementException("node contains no vertices");
        }
        if (this.vertexType != -1 && this.vertexType != this.current.type() || this.vertexName != null && !this.vertexName.equals(this.current.name())) {
            this.computeNext();
            this.current = this.next;
            this.next = null;
        }
    }

    private void computeNext() throws NoSuchElementException {
        if (this.next != null) {
            return;
        }
        try {
            Vertex vertex = this.current.next(1);
            while (true) {
                if (!(this.vertexType != -1 && this.vertexType != vertex.type() || this.vertexName != null && !this.vertexName.equals(vertex.name()))) {
                    this.next = vertex;
                    break;
                }
                vertex = vertex.next(1);
            }
        }
        catch (NoSuchVertexException noSuchVertexException) {
            throw new NoSuchElementException("no matching next vertex");
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException("node contains no vertices");
        }
    }
}

