
/*
 * bltPsInt.h --
 *
 *	Copyright 1993-2004 George A Howlett.
 *
 *	Permission is hereby granted, free of charge, to any person
 *	obtaining a copy of this software and associated documentation
 *	files (the "Software"), to deal in the Software without
 *	restriction, including without limitation the rights to use,
 *	copy, modify, merge, publish, distribute, sublicense, and/or
 *	sell copies of the Software, and to permit persons to whom the
 *	Software is furnished to do so, subject to the following
 *	conditions:
 *
 *	The above copyright notice and this permission notice shall be
 *	included in all copies or substantial portions of the
 *	Software.
 *
 *	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 *	KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 *	PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
 *	OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *	OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 *	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 *	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _BLT_PS_INT_H
#define _BLT_PS_INT_H

struct Blt_PostScriptStruct {
    Tcl_Interp *interp;		/* Interpreter to report errors to. */

    Tk_Window tkwin;		/* Tk_Window used to get font and color
				 * information */

    Tcl_DString dString;	/* Dynamic string used to contain the
				 * PostScript generated. */

    char *xfontVarName;		/* Name of a Tcl array variable to convert
				 * X font names to PostScript fonts. */

    char *xcolorVarName;	/* Name of a Tcl array variable to convert
				 * X color names to PostScript. */

    int xcolorMode;		/* Mode: color or greyscale */

#define POSTSCRIPT_BUFSIZ	((BUFSIZ*2)-1)
    /*
     * Utility space for building strings.  Currently used to create
     * PostScript output for the "postscript" command.
     */
    char scratchArr[POSTSCRIPT_BUFSIZ+1];
};

typedef struct Blt_PostScriptStruct PostScript;

#endif /* BLT_PS_H */
