proc sj_mui {root args} {

    # This treats '.' as a special case.
    if {$root == "."} {set base ""} else {set base $root}

    set toproot [winfo toplevel $root]
    if {$toproot == "."} {set topbase ""} else {set topbase $toproot}

    proc menued_menu_accel {key args} {
	global tcl_platform
	set shift [regexp {[sS]hift} $args]
	set control [regexp {[cC]ontrol} $args]
	set meta [regexp {[mM]eta} $args]
	set alt [regexp {[aA]lt} $args]
	switch $tcl_platform(platform) {
	    unix {
		array set mods {prefix "<" suffix ">"  shift0 "" shift1 "Shift-"  control0 "" control1 "^-"  meta0 "" meta1 "Meta-"  alt0 "" alt1 "Alt-"}
	    }
	    macintosh {
		set key [string toupper $key]
		array set mods {prefix "" suffix ""  shift0 "" shift1 "Shift"  control0 "" control1 "Command-"  meta0 "" meta1 "\240"  alt0 "" alt1 "Option"}
	    }
	    windows {
		array set mods {prefix "" suffix ""  shift0 "" shift1 "Shft+"  control0 "" control1 "Ctrl+"  meta0 "" meta1 "Meta+"  alt0 "" alt1 "Alt+"}
	    }
	    default {
		return "$key"
	    }
	}
	return "$mods(prefix)$mods(shift$shift)$mods(control$control)$mods(meta$meta)$mods(alt$alt)$key$mods(suffix)"
    }
    if {[catch {$toproot config -menu ${topbase}.menubar} msg]} {
        array set menupaths "menubutton#1 ${base}.menubutton#1 menubutton#2 ${base}.menubutton#2 menubutton#7 ${base}.menubutton#7 menubutton#3 ${base}.menubutton#3 menubutton#14 ${base}.menubutton#14 menubutton#4 ${base}.menubutton#4 menubutton#5 ${base}.menubutton#5 "
        menubutton ${base}.menubutton#1
        $menupaths(menubutton#1) config -background #c0c0c0 -menu $menupaths(menubutton#1).1m -text File -underline 0 
        pack $menupaths(menubutton#1) -side left
        menubutton ${base}.menubutton#2
        $menupaths(menubutton#2) config -background #c0c0c0 -cursor arrow -menu $menupaths(menubutton#2).2m -text Edit -underline 0 
        pack $menupaths(menubutton#2) -side left
        menubutton ${base}.menubutton#7
        $menupaths(menubutton#7) config -background #c0c0c0 -cursor arrow -menu $menupaths(menubutton#7).7m -text Project 
        pack $menupaths(menubutton#7) -side left
        menubutton ${base}.menubutton#3
        $menupaths(menubutton#3) config -background #c0c0c0 -cursor arrow -menu $menupaths(menubutton#3).3m -text Commands -underline 0 
        pack $menupaths(menubutton#3) -side left
        menubutton ${base}.menubutton#14
        $menupaths(menubutton#14) config -background #c0c0c0 -menu $menupaths(menubutton#14).1m -text Windows 
        pack $menupaths(menubutton#14) -side left
        menubutton ${base}.menubutton#4
        $menupaths(menubutton#4) config -background #c0c0c0 -cursor arrow -menu $menupaths(menubutton#4).4m -text Preferences -underline 0 
        pack $menupaths(menubutton#4) -side left
        menubutton ${base}.menubutton#5
        $menupaths(menubutton#5) config -background #c0c0c0 -menu $menupaths(menubutton#5).5m -text Help -underline 0 
        pack $menupaths(menubutton#5) -side right
    } else {
        if {[winfo toplevel $root] == "."} {set base ""} else {set base [winfo toplevel $root]}
        array set menupaths "menubutton#1 ${base}.menubar menubutton#2 ${base}.menubar menubutton#7 ${base}.menubar menubutton#3 ${base}.menubar menubutton#14 ${base}.menubar menubutton#4 ${base}.menubar menubutton#5 ${base}.menubar "
        menu ${topbase}.menubar
        ${topbase}.menubar add cascade -background #c0c0c0 -menu $menupaths(menubutton#1).1m -label File -underline 0 
        ${topbase}.menubar add cascade -background #c0c0c0 -menu $menupaths(menubutton#2).2m -label Edit -underline 0 
        ${topbase}.menubar add cascade -background #c0c0c0 -menu $menupaths(menubutton#7).7m -label Project 
        ${topbase}.menubar add cascade -background #c0c0c0 -menu $menupaths(menubutton#3).3m -label Commands -underline 0 
        ${topbase}.menubar add cascade -background #c0c0c0 -menu $menupaths(menubutton#14).1m -label Windows 
        ${topbase}.menubar add cascade -background #c0c0c0 -menu $menupaths(menubutton#4).4m -label Preferences -underline 0 
        ${topbase}.menubar add cascade -background #c0c0c0 -menu $menupaths(menubutton#5).5m -label Help -underline 0 
    }
    menu $menupaths(menubutton#1).1m -tearoff 0 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel n  Control] -background #c0c0c0 -command clear_all -label New 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel o  Control] -background #c0c0c0 -command mainmenu_open -label Open... 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel s  Control] -background #c0c0c0 -command mainmenu_save -label Save 

    $menupaths(menubutton#1).1m add command -background #c0c0c0 -command mainmenu_save_as -label {Save As...} 

    $menupaths(menubutton#1).1m add separator -background #c0c0c0 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel q  Control] -background #c0c0c0 -command quit -label Quit 

    menu $menupaths(menubutton#2).2m -tearoff 0 

    $menupaths(menubutton#2).2m add command -background #c0c0c0 -command mainmenu_edit_code -label {Edit code} 

    $menupaths(menubutton#2).2m add command -accelerator [menued_menu_accel w  Control] -background #c0c0c0 -command mainmenu_widget_options -label {Widget options...} 

    $menupaths(menubutton#2).2m add command -accelerator [menued_menu_accel g  Control] -background #c0c0c0 -command mainmenu_generic_options -label {Generic options...} 

    $menupaths(menubutton#2).2m add separator -background #c0c0c0 

    $menupaths(menubutton#2).2m add command -accelerator [menued_menu_accel Delete ] -background #c0c0c0 -command mainmenu_delete -label Delete 

    $menupaths(menubutton#2).2m add command -accelerator [menued_menu_accel Insert ] -background #c0c0c0 -command mainmenu_insert -label Insert 

    $menupaths(menubutton#2).2m add command -accelerator [menued_menu_accel x  Control] -background #c0c0c0 -command mainmenu_cut -label Cut 

    $menupaths(menubutton#2).2m add command -accelerator [menued_menu_accel c  Control] -background #c0c0c0 -command mainmenu_copy -label Copy 

    $menupaths(menubutton#2).2m add command -accelerator [menued_menu_accel v  Control] -background #c0c0c0 -command mainmenu_paste -label Paste 

    menu $menupaths(menubutton#7).7m -tearoff 0 

    $menupaths(menubutton#7).7m add command -background #c0c0c0 -label {New Project...} 

    $menupaths(menubutton#7).7m add command -background #c0c0c0 -command mainmenu_load_project -label {Load Project...} 

    $menupaths(menubutton#7).7m add command -background #c0c0c0 -command mainmenu_load_project_into_frame -label {Load Project into frame...} 

    $menupaths(menubutton#7).7m add command -background #c0c0c0 -command mainmenu_save_project -label {Save Project} 

    $menupaths(menubutton#7).7m add command -background #c0c0c0 -command mainmenu_save_project_as -label {Save Project as...} 

    $menupaths(menubutton#7).7m add separator -background #c0c0c0 

    $menupaths(menubutton#7).7m add command -background #c0c0c0 -command mainmenu_add_file -label {Add File...} 

    $menupaths(menubutton#7).7m add command -background #c0c0c0 -command mainmenu_remove_file -label {Remove File} 

    $menupaths(menubutton#7).7m add command -accelerator [menued_menu_accel t  Control] -background #c0c0c0 -command mainmenu_build_test -label {Build & Test} 

    $menupaths(menubutton#7).7m add command -accelerator [menued_menu_accel k  Control] -background #c0c0c0 -command mainmenu_kill_test -label {Kill Test} 

    menu $menupaths(menubutton#3).3m -tearoff 0 

    $menupaths(menubutton#3).3m add command -accelerator [menued_menu_accel t  Control] -background #c0c0c0 -command mainmenu_build_test -label {Build Test} 

    $menupaths(menubutton#3).3m add command -accelerator [menued_menu_accel k  Control] -background #c0c0c0 -command mainmenu_kill_test -label {Kill test} 

    $menupaths(menubutton#3).3m add command -background #c0c0c0 -command mainmenu_load_project_into_frame -label {Load Project into frame...} 

    $menupaths(menubutton#3).3m add command -background #c0c0c0 -command mainmenu_attach_scrollbars -label {Attach scrollbars} 

    $menupaths(menubutton#3).3m add command -accelerator [menued_menu_accel r  Control] -background #c0c0c0 -command mainmenu_reapply_toolbar -label {Re-apply the toolbar} 

    $menupaths(menubutton#3).3m add cascade -background #c0c0c0 -command mainmenu_navigate -label Navigate -menu $menupaths(menubutton#3).3m.6m 

    $menupaths(menubutton#3).3m add command -background #c0c0c0 -command mainmenu_showconsole -label {Show Console} 

    $menupaths(menubutton#3).3m add command -background #c0c0c0 -command mainmenu_hideconsole -label {Hide Console} 

    menu $menupaths(menubutton#3).3m.6m -tearoff 0 

    $menupaths(menubutton#3).3m.6m add command -accelerator [menued_menu_accel Right  Shift] -background #c0c0c0 -command mainmenu_next_widget -label {Next Widget} 

    $menupaths(menubutton#3).3m.6m add command -accelerator [menued_menu_accel Left  Shift] -background #c0c0c0 -command mainmenu_previous_widget -label {Previous Widget} 

    $menupaths(menubutton#3).3m.6m add command -accelerator [menued_menu_accel Down ] -background #c0c0c0 -command mainmenu_enter_subgrid -label {Enter Subgrid} 

    $menupaths(menubutton#3).3m.6m add command -accelerator [menued_menu_accel Up ] -background #c0c0c0 -command mainmenu_leave_subgrid -label {Leave Subgrid} 

    menu $menupaths(menubutton#14).14m -tearoff 0 

    $menupaths(menubutton#14).14m add command -accelerator [menued_menu_accel 1  Control] -background #c0c0c0 -command mainmenu_project -label Project 

    $menupaths(menubutton#14).14m add command -accelerator [menued_menu_accel 2  Control] -background #c0c0c0 -label Properties 

    $menupaths(menubutton#14).14m add separator 

    menu $menupaths(menubutton#4).4m -tearoff 0 

    $menupaths(menubutton#4).4m add command -background #c0c0c0 -command mainmenu_options -label Options... 

    $menupaths(menubutton#4).4m add separator -background #c0c0c0 

    $menupaths(menubutton#4).4m add command -background #c0c0c0 -command mainmenu_save_options -label {Save options} 

    menu $menupaths(menubutton#5).5m -tearoff 0 

    $menupaths(menubutton#5).5m add command -background #c0c0c0 -command mainmenu_about -label About 

    $menupaths(menubutton#5).5m add separator -background #c0c0c0 

    $menupaths(menubutton#5).5m add command -accelerator [menued_menu_accel Help ] -background #c0c0c0 -command mainmenu_getting_started -label {Getting Started} 

    $menupaths(menubutton#5).5m add command -background #c0c0c0 -command mainmenu_help -label Help 

    rename menued_menu_accel {}
}


