'\"
'\" Generated from ../tcllib/modules/doctools/dtformatter.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "formatter" n 1.0 doctools "Documentation tools"
.BS
.SH NAME
formatter \- Interface specification for formatter code
.BE
.SH "DESCRIPTION"
.PP
This manpage specifies the interface between the
manpage processor \fBmpexpand\fR and the tcl code
implementing the  conversion into a particular
output format.
.PP
The tcl code has to provide
.IP [1]
Implementations of all commands specified in
\fBformat(n)\fR, using the defined names
.IP [2]
and additionally implementations for
.RS
.TP
\fBNumPasses\fR
This command is called after the formatter is setup
and has to return the number of passes required by
this formatter to process a manpage. This information
has to be an integer number greater or equal to one.
.TP
\fBPassSetup\fR
This command is called at the beginning of each
pass over the input. It can assume that the current
number of the pass is already set to the correct value
and is responsible for setting up the internal state
of the formatter for this pass.
.TP
\fBPostProcess\fR \fItext\fR
This command is called after last pass, with the
expansion result of that pass, and can do any
last-ditch modifications of the generated result.
Its result is the final text written to the output.
.sp
Most formats will use \fIidentity\fR here.
.TP
\fBHandleText\fR \fItext\fR
This command is called for any plain text encountered
by the processor in the input and can do any special
processing required for plain text. Its result is the
string written into the expansion.
.sp
Most formats will use \fIidentity\fR here.
.RE
.PP
The tcl code implementing all of the above can make
the following assumptions:
.IP [1]
It has full access to its own non-safe interpreter.
In other words, the formatter cannot damage the other
parts of the processor, but it can do damage to the
filesystem. It is trusted in that way.
.IP [2]
The surrounding system provides the formatter code
with the following commands:
.RS
.TP
\fBmp_pass\fR
This command returns the number of the current pass.
.TP
\fBmp_file\fR
This command returns the full name of the file
currently processed, or \fBstdin\fR, if the
input is read from there.
.TP
\fBmp_module\fR
This command returns the name of the module we are in.
.TP
\fBcappend\fR
.TP
\fBcget\fR
.TP
\fBcis\fR
.TP
\fBcname\fR
.TP
\fBcpop\fR
.TP
\fBcpush\fR
.TP
\fBcset\fR
.TP
\fBlb\fR
.TP
\fBrb\fR
All of the above commands are methods of the expander
object handling the input. Their arguments and
results are described in \fBexpander(n)\fR.
.RE
.SH "SEE ALSO"
expander(n), format(n), mpexpand(n)
.SH "KEYWORDS"
manpage, interface, TMML, HTML, nroff, conversion, markup
