'\"
'\" Generated from ../tcllib/modules/dns/dns.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "dns" n 1.0.1 dns "dns"
.BS
.SH NAME
dns \- Tcl Domain Name Service Client
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBdns ?1.0.1?\fR
.sp
\fB::dns::resolve\fR \fIquery\fR ?\fIoptions\fR?\fR
.sp
\fB::dns::configure\fR ?\fIoptions\fR?\fR
.sp
\fB::dns::name\fR \fItoken\fR\fR
.sp
\fB::dns::address\fR \fItoken\fR\fR
.sp
\fB::dns::cname\fR \fItoken\fR\fR
.sp
\fB::dns::status\fR \fItoken\fR\fR
.sp
\fB::dns::error\fR \fItoken\fR\fR
.sp
\fB::dns::reset\fR \fItoken\fR\fR
.sp
\fB::dns::wait\fR \fItoken\fR\fR
.sp
\fB::dns::cleanup\fR \fItoken\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The dns package provides a Tcl only Domain Name Service client. You should
refer to RFC 1034 and RFC 1035 for information about the DNS protocol or
read resolver(3) to find out how the C library resolves domain names.
The intention of this package is to insulate Tcl scripts
from problems with using the system library resolver for slow name servers.
It may or may not be of practical use.
The package also extends the package \fBuri\fR to support DNS URIs
or the form \fIdns:what.host.com\fR or
\fIdns://my.nameserver/what.host.com\fR. The \fBdns::resolve\fR
command can handle DNS URIs or simple domain names as a query.
.PP
\fBNote:\fR This package uses TCP to query DNS servers as the tcl
core does not implement UDP networking. This means that this module
will not work if DNS over TCP is blocked by a firewall, or not
accepted by the chosen nameserver.
.SH "COMMANDS"
.TP
\fB::dns::resolve\fR \fIquery\fR ?\fIoptions\fR?\fR
Resolve a domain name using the \fBDNS\fR protocol. \fIquery\fR is
the domain name to be lookup up. This should be either a fully
qualified domain name or a DNS URI.
.RS
.TP
\fB-nameserver\fR \fIhostname\fR or \fB-server\fR \fIhostname\fR
Specify an alternative name server for this request.
.TP
\fB-protocol\fR \fItcp|udp\fR
Specify the network protocol to use for this request. Can be one of
\fItcp\fR or \fIudp\fR. However only tcp is currently implemented in the
package.
.TP
\fB-port\fR \fIportnum\fR
Specify an alternative port.
.TP
\fB-search\fR \fIdomainlist\fR
.TP
\fB-timeout\fR \fImilliseconds\fR
Override the default timeout.
.TP
\fB-type\fR \fITYPE\fR
Specify the type of DNS record you are interested in. Valid values are A, NS, MD
MF, CNAME, SOA, MB, MG, MR, NULL, WKS, PTR, HINFO, MINFO, MX, TXT, AXFR, MAILB,
MAILA and *. See RFC1035 for details about the return values.
.TP
\fB-class\fR \fICLASS\fR
Specify the class of domain name. This is usually IN but may be one of IN for
internet domain names, CS, CH, HS or * for any class.
.TP
\fB-recurse\fR \fIboolean\fR
Set to \fIfalse\fR if you do not want the name server to recursively act upon
your request. Normally set to \fItrue\fR.
.TP
\fB-command\fR \fIprocname\fR
Set a procedure to be called upon request completion. The procedure will be
passed the token as its only argument.
.RE
.sp
.TP
\fB::dns::configure\fR ?\fIoptions\fR?\fR
The ::dns::configure command is used to setup the dns package. The server to
query, the protocol and domain search path are all set via this command. If
no arguments are provided then a list of all the current settings is returned.
If only one argument then it must the the name of an option and the value for
that option is returned.
.RS
.TP
\fB-nameserver\fR \fIhostname\fR
Set the default name server to be used by all queries. The default is
localhost.
.TP
\fB-protocol\fR \fItcp|udp\fR
Set the default network protocol to be used. Defaults to tcp.
.TP
\fB-port\fR \fIportnum\fR
Set the default port to use on the name server. The default is 53.
.TP
\fB-search\fR \fIdomainlist\fR
Set the domain search list. This is currently not used.
.TP
\fB-timeout\fR \fImilliseconds\fR
Set the default timeout value for DNS lookups. Defaults to 30 seconds.
.RE
.sp
.TP
\fB::dns::name\fR \fItoken\fR\fR
Returns a list of all domain names returned as an answer to your query.
.sp
.TP
\fB::dns::address\fR \fItoken\fR\fR
Returns a list of the address records that match your query.
.sp
.TP
\fB::dns::cname\fR \fItoken\fR\fR
Returns a list of canonical names (usually just one) matching your query.
.sp
.TP
\fB::dns::status\fR \fItoken\fR\fR
Returns the status flag. For a successfully completed query this will be
\fIok\fR. May be \fIerror\fR or \fItimeout\fR or \fIeof\fR.
See also \fB::dns::error\fR
.sp
.TP
\fB::dns::error\fR \fItoken\fR\fR
Returns the error message provided for requests whose status is \fIerror\fR.
If there is no error message then an empty string is returned.
.sp
.TP
\fB::dns::reset\fR \fItoken\fR\fR
Reset or cancel a DNS query.
.sp
.TP
\fB::dns::wait\fR \fItoken\fR\fR
Wait for a DNS query to complete and return the status upon completion.
.sp
.TP
\fB::dns::cleanup\fR \fItoken\fR\fR
Remove all state variables associated with the request.
.SH "EXAMPLES"
.PP
.nf
% set tok [dns::resolve www.tcl.tk]
::dns::1
% dns::status $tok
ok
% dns::address $tok
199.175.6.239
% dns::name $tok
www.tcl.tk
.fi
.PP
Using DNS URIs as queries:
.nf
% set tok [dns::resolve "dns:tcl.tk;type=MX"]
% set tok [dns::resolve "dns://l.root-servers.net/www.tcl.tk"]
.fi
.SH "SEE ALSO"
resolver(5)
.SH "AUTHORS"
Pat Thoyts
.SH "KEYWORDS"
DNS, resolver, domain name service
