/* 
 * tx.c --
 *
 *	This file contains the main program for the Sprite version of
 *	"tx", a typescript tool that runs on top of the X11 window system
 *	and uses the Sx library package.  Much of the functionality of
 *	Tx is shared with Mx, the mouse-based editor.
 *
 * Copyright (C) 1987, 1989 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /sprite/src/cmds/tx/RCS/tx.c,v 1.32 90/03/29 11:16:02 ouster Exp $ SPRITE (Berkeley)";
#endif not lint

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#define Time SpriteTime
#include <fs.h>
#include <stdio.h>
#include <tcl.h>
#include <mx.h>
#include "mxInt.h"

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	The main program for tx.  Initialize, load file, create window,
 *	and loop processing events.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Almost anything can happen.  Depends on commands that user types.
 *
 *----------------------------------------------------------------------
 */

main(argc, argv)
    int argc;			/* Count of command-line arguments. */
    char **argv;		/* Array of strings containing args. */
{
    Tx_WindowInfo info;
    int		i, put, detach;
    Display	*display;
    Tcl_Interp	*interp;

    /*
     * If running under Sprite, tell the memory allocator to be paranoid
     * about freeing the same block twice.
     */

#ifdef sprite
    extern int memAllowFreeingFree;
    memAllowFreeingFree = 0;
#endif

    /*
     *--------------------------------------------------------------
     * Parse some command line arguments here, but leave many others
     * to be handled by Tx_OpenCmd.
     *--------------------------------------------------------------
     */

    detach = 1;
    for (i = 1, put = 1; i < argc; i++) {
	if (strcmp(argv[i], "-e") == 0) {
	    for ( ; i < argc; put++, i++) {
		argv[put] = argv[i];
	    }
	    break;
	} else if (strcmp(argv[i], "-D") == 0) {
	    detach = 0;
	} else {
	    argv[put] = argv[i];
	    put++;
	}
    }
    argc = put;
    if (detach) {
	setpgrp(0, getpid());
	Proc_Detach(0);
    }

    Sx_SetErrorHandler();

    /*
     *--------------------------------------------------------------
     * Create the first typescript window and spawn the application.
     *--------------------------------------------------------------
     */

    interp = Tcl_CreateInterp();
    if (Tx_OpenCmd(NULL, interp, argc, argv) != TCL_OK) {
	fprintf(stderr, "Tx quitting: %s.\n", interp->result);
	exit(1);
    }

    display = tx_Display;
    /* XSynchronize(display, True); */

    /*
     *--------------------------------------------
     * Enter a loop reading and processing events.
     *--------------------------------------------
     */

    Fs_EventHandlerCreate(ConnectionNumber(display), FS_READABLE,
	    Tx_WindowEventProc, (ClientData) display);
    while (1) {
	while (QLength(display) > 0) {
	    XEvent event;
	    XNextEvent(display, &event);
	    Sx_HandleEvent(&event);
	}
	Tx_Update();
	Mx_Update();
	if ((tx_TypescriptCount == 0) && (mx_FileCount == 0)) {
	    break;
	}
	if (QLength(display) > 0) {
	    continue;
	}
	XFlush(display);
	Fs_Dispatch();
    }

    exit(0);
}
