#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

## pie.tcl
##
## Modified from original demo
##
## jeff.hobbs@acm.org

source [file join [file dirname [info script]] load.tcl]

eval destroy [winfo children .]
set p [pie .pie -label "My Revolving Budget"]
$p itemconfigure Welfare -value 3.004
$p itemconfigure Military -value 7.006
$p itemconfigure Transport -value 1.6 -explode 15
$p itemconfigure Parks -value 0.9
$p itemconfigure Schools -value 2
$p itemconfigure Debt -value 4 -explode 10

$p configure -angle 10 -origin 90 -shadow 10

frame .buttons
button .fast -text "Spin Faster" -command spin
button .slow -text "Spin Slower" -command stop
button .quit -text "Exit" -command exit

grid $p -sticky news
grid .buttons -sticky news
pack .fast .slow .quit \
	-in .buttons -side left -fill both -expand 1 -padx 6 -pady 4
grid columnconfig . 0 -weight 1
grid rowconfigure . 0 -weight 1

proc spin {{w .pie} {delay 60}} {
    global SPIN
    $w config -origin [expr {[$w cget -origin]+1}] 
    set SPIN [after $delay [info level 0]]
}

proc stop {} {
    global SPIN
    after cancel $SPIN
}

bind $p <ButtonPress-1> {
    array set tkPriv "x %x y %y pieIn [expr {[winfo width %W]/1.8 > %x}]\
	    pieAngle [%W cget -angle] pieOrigin [%W cget -origin]"
}

bind $p <B1-Motion> {
    if {$tkPriv(pieIn)} {
	%W config -angle [expr {$tkPriv(pieAngle)+($tkPriv(y)-%y)/3}] \
		-origin [expr {($tkPriv(pieOrigin)+(([winfo height %W]/2.2 > %y)?-1:1)*($tkPriv(x)-%x)/3)%%360}] \
    }
}
