proc untitled_mui {root args} {

    # This treats '.' as a special case.
    if {$root == "."} {set base ""} else {set base $root}

    set toproot [winfo toplevel $root]
    if {$toproot == "."} {set topbase ""} else {set topbase $toproot}

    proc menued_menu_accel {key args} {
	global tcl_platform
	set shift [regexp {[sS]hift} $args]
	set control [regexp {[cC]ontrol} $args]
	set meta [regexp {[mM]eta} $args]
	set alt [regexp {[aA]lt} $args]
	switch $tcl_platform(platform) {
	    unix {
		array set mods {prefix "<" suffix ">"  shift0 "" shift1 "Shift-"  control0 "" control1 "^-"  meta0 "" meta1 "Meta-"  alt0 "" alt1 "Alt-"}
	    }
	    macintosh {
		set key [string toupper $key]
		array set mods {prefix "" suffix ""  shift0 "" shift1 "Shift"  control0 "" control1 "Command-"  meta0 "" meta1 "\240"  alt0 "" alt1 "Option"}
	    }
	    windows {
		array set mods {prefix "" suffix ""  shift0 "" shift1 "Shft+"  control0 "" control1 "Ctrl+"  meta0 "" meta1 "Meta+"  alt0 "" alt1 "Alt+"}
	    }
	    default {
		return "$key"
	    }
	}
	return "$mods(prefix)$mods(shift$shift)$mods(control$control)$mods(meta$meta)$mods(alt$alt)$key$mods(suffix)"
    }
    if {[catch {$toproot config -menu ${topbase}.menubar} msg]} {
        array set menupaths "menubutton#1 ${base}.menubutton#1 "
        menubutton ${base}.menubutton#1
        $menupaths(menubutton#1) config -menu $menupaths(menubutton#1).1m -text a 
        pack $menupaths(menubutton#1) -side left
    } else {
        if {[winfo toplevel $root] == "."} {set base ""} else {set base [winfo toplevel $root]}
        array set menupaths "menubutton#1 ${base}.menubar "
        menu ${topbase}.menubar
        ${topbase}.menubar add cascade -menu $menupaths(menubutton#1).1m -label a 
    }
    menu $menupaths(menubutton#1).1m -tearoff 0 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel a ] -label b 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel A  Shift] -label c 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel a  Control] -label d 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel a  Meta] -label e 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel a  Alt] -label f 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel A  CapsLock] -label g 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel A  Control Shift] -label h 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel A  Control Shift Meta] -label i 

    $menupaths(menubutton#1).1m add command -accelerator [menued_menu_accel A  Control Shift Meta Alt] -label j 

    $menupaths(menubutton#1).1m add command -label k 

    $menupaths(menubutton#1).1m add command -label l 

    rename menued_menu_accel {}
}


