[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools::cvs n 0.1]
[copyright {2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Handle text in 'cvs log' format}]
[require Tcl 8.2]
[require textutil]
[require doctools::cvs [opt 0.1]]
[description]

This package provides tcl commands which are able to process and
reformat text in the format as generated by the [syscmd {cvs log}]
command.

[para]


The commands [cmd scanLog] and [cmd toChangeLog] are derived from code
found on the Tcl'ers Wiki ([uri http://wiki.tcl.tk]). See the
references at the end of the page.


[section COMMANDS]


[list_begin definitions]

[call [cmd ::doctools::cvs::scanLog] [arg {text evar cvar fvar}]]

The command takes the [arg text] and fills the variables whose names
were specified through [arg evar], [arg cvar], and [arg fvar] with
information from the CVS log.

[nl]

Existing information is preserved, allowing the caller to merge data
from multiple logs into one database.

[list_begin definitions]
[lst_item [arg evar]]

Expected to refer to a scalar variable. After the call it contains a
list of all the entries found in the log file. An entry is identified
through the combination of date and author, and can be split over
multiple physical entries, one per touched file.

[nl]

Note that the entries are listed in the same order as they were found
in the [arg text]. This is not necessarily sorted by date or author.

[nl]

Each item in the list is a list containing two elements, the date of
the entry, and its author, in this order. The date is of the form
year/month/day

[lst_item [arg cvar]]

Expected to refer to an array variable. Keys into the array are the
date and author of log entries, in this order, separated by a
comma.

[nl]

The value per key is a list of comments made for the entry.



[lst_item [arg fvar]]

Expected to refer to an array variable. Keys into the array are the
date, author of a log entry, and a comment for that entry, in this
order, separated by commas.

[nl]

The value per key is a list of files the entry is touching.

[list_end]
[nl]

[call [cmd ::doctools::cvs::toChangeLog] [arg {evar cvar fvar}]]

The three arguments are the same as the last three arguments of

[cmd ::doctools::cvs::scanLog]. This command however expects them to
be filled with information about one or more logs. It takes this
information and constructs a text in the format of a ChangeLog as
accepted by [syscmd emacs]. The constructed text is returned as the
result of the command.

[list_end]

[see_also [uri http://wiki.tcl.tk/log2changelog]]
[keywords changelog cvs log {cvs log}]
[manpage_end]
