'\"
'\" Generated from ../tcllib/modules/control/control.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "control" n 0.1 control "Tcl Control Flow Commands"
.BS
.SH NAME
control \- Procedures for control flow structures.
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBcontrol ?0.1?\fR
.sp
\fBcontrol::control\fR \fIcommand\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fBcontrol::assert\fR \fIexpr\fR ?\fIarg arg ...\fR?\fR
.sp
\fBcontrol::do\fR \fIbody\fR ?\fIoption test\fR?\fR
.sp
\fBcontrol::no-op\fR ?\fIarg arg ...\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBcontrol\fR package provides a variety of commands that provide
additional flow of control structures beyond the built-in ones
provided by Tcl.  These are commands that in many programming
languages might be considered \fIkeywords\fR, or a part of the
language itself.  In Tcl, control flow structures are just commands
like everything else.
.SH "COMMANDS"
.TP
\fBcontrol::control\fR \fIcommand\fR \fIoption\fR ?\fIarg arg ...\fR?\fR
The \fBcontrol\fR command is used as a configuration command for
customizing the other public commands of the control package.  The
\fIcommand\fR argument names the command to be customized.  The set of
valid \fIoption\fR and subsequent arguments are determined by the
command being customized, and are documented with the command.
.TP
\fBcontrol::assert\fR \fIexpr\fR ?\fIarg arg ...\fR?\fR
When disabled, the \fBassert\fR command behaves exactly like the
\fBno-op\fR command.
.sp
When enabled, the \fBassert\fR command evaluates \fIexpr\fR as an
expression (in the same way that \fBexpr\fR evaluates its argument).
If evaluation reveals that \fIexpr\fR is not a valid boolean
expression (according to [\fBstring is boolean -strict\fR]),
an error is raised.  If \fIexpr\fR evaluates to a true boolean value
(as recognized by \fBif\fR), then \fBassert\fR returns an empty
string.  Otherwise, the remaining arguments to \fBassert\fR are used
to construct a message string.  If there are no arguments, the message
string is "assertion failed: $expr".  If there are arguments, they are
joined by \fBjoin\fR to form the message string.  The message string
is then appended as an argument to a callback command, and the
completed callback command is evaluated in the global namespace.
.sp
The \fBassert\fR command can be customized by the \fBcontrol\fR
command in two ways:
.sp
[\fBcontrol::control assert enabled\fR ?\fIboolean\fR?]
queries or sets whether \fBcontrol::assert\fR is enabled.  When called
without a \fIboolean\fR argument, a boolean value is returned
indicating whether the \fBcontrol::assert\fR command is enabled.  When
called with a valid boolean value as the \fIboolean\fR argument, the
\fBcontrol::assert\fR command is enabled or disabled to match the
argument, and an empty string is returned.
.sp
[\fBcontrol::control assert callback\fR ?\fIcommand\fR?]
queries or sets the callback command that will be called by an enabled
\fBassert\fR on assertion failure.  When called without a
\fIcommand\fR argument, the current callback command is returned.
When called with a \fIcommand\fR argument, that argument becomes the
new assertion failure callback command.  Note that an assertion
failure callback command is always defined, even when \fBassert\fR
is disabled.  The default callback command is
[\fBreturn -code error\fR].
.sp
Note that \fBcontrol::assert\fR has been written so that in
combination with [\fBnamespace import\fR], it is possible to
use enabled \fBassert\fR commands in some namespaces and disabled
\fBassert\fR commands in other namespaces at the same time.  This
capability is useful so that debugging efforts can be independently
controlled module by module.
.sp
.nf
% package require control
% control::control assert enabled 1
% namespace eval one namespace import ::control::assert
% control::control assert enabled 0
% namespace eval two namespace import ::control::assert
% one::assert {1 == 0}
assertion failed: 1 == 0
% two::assert {1 == 0}
.fi
.TP
\fBcontrol::do\fR \fIbody\fR ?\fIoption test\fR?\fR
The \fBdo\fR command evaluates the script \fIbody\fR repeatedly
\fBuntil\fR the expression \fItest\fR becomes true or as long as
(\fBwhile\fR) \fItest\fR is true, depending on the value of
\fIoption\fR being \fBuntil\fR or \fBwhile\fR. If
\fIoption\fR and \fItest\fR are omitted the body is evaluated exactly
once. After normal completion, \fBdo\fR returns an empty string.
Exceptional return codes (\fBbreak\fR, \fBcontinue\fR, \fBerror\fR,
etc.) during the evaluation of \fIbody\fR are handled in the same way
the \fBwhile\fR command handles them, except as noted in
\fBLIMITATIONS\fR, below.
.TP
\fBcontrol::no-op\fR ?\fIarg arg ...\fR?\fR
The \fBno-op\fR command takes any number of arguments and does
nothing.  It returns an empty string.
.SH "LIMITATIONS"
Several of the commands provided by the \fBcontrol\fR package accept
arguments that are scripts to be evaluated.  Due to fundamental
limitations of Tcl's \fBcatch\fR and \fBreturn\fR commands, it is not
possible for these commands to properly evaluate the command
[\fBreturn -code $code\fR] within one of those script
arguments for any value of \fI$code\fR other than \fIok\fR.  In this
way, the commands of the \fBcontrol\fR package are limited as compared
to Tcl's built-in control flow commands (such as \fBif\fR,
\fBwhile\fR, etc.) and those control flow commands that can be
provided by packages coded in C.  An example of this difference:
.PP
.nf
% package require control
% proc a {} {while 1 {return -code error a}}
% proc b {} {control::do {return -code error b} while 1}
% catch a
1
% catch b
0
.fi
.SH "SEE ALSO"
expr, if, join, namespace, return, string, while, break, continue
.SH "KEYWORDS"
control, flow, structure, no-op, assert, do