#!/usr/local/bin/wish -f
#
# This macro checks for tkedit macros which may need to be updated
#
global env

set SRC1 "tkedit_storage"
set TO "$env(HOME)/tkedit_macros"
set FILES "MultiLevel_Undo.startup ISO_Font_Type_In.startup \
      ProcList_TCL_perl.startup ProcList_C.startup ProcList_FORTRAN.startup \
      HighLight_TCL.startup HighLight_C.startup HighLight_FORTRAN.startup \
      TextFormat.startup AutoMatch.startup CTAGS_support.startup \
      MAKE_support.startup Fold_Expand.startup Ispell_Support.startup"

set OBSOLET "FunctionExtract.startup"

#
# look for source directory
#

regsub -all "\:" $env(PATH) " " s
set l [llength $s]
set SRC $SRC1
for {set i 0} {$i < $l} {incr i} {
   set f "[lindex $s $i]/$SRC1"
   if {[file isdirectory $f]} {
      set SRC $f
      break
   }
}


#
#  check if a destination directory exists
#

if {[file isdirectory "$TO"] == 0} {
   set erg [tk_dialog .err "update message:" \
"You are running this program for the first time!\n \
Should the directory $TO be created now ?" \
      warning -1 SKIP CREATE]
   if {$erg} {
      exec mkdir "$TO"
   } else {
      return
   }
}

#
# set Version flag
#

exec touch "$TO/$Version"

#
# check for obsolet files
#

foreach i $OBSOLET {
   if {[file exists "$TO/$i"]} {
      set erg [tk_dialog .err "update message:" \
"The Macro $i has become obsolet in this Version\n \
shall I remove this macro from your $TO ?" \
      warning -1 NO REMOVE]
      if {$erg} {
         exec rm "$TO/$i"
      }
   }
}


#
# check if the essential macros are installed
#

set flag 1
foreach i $FILES {
   if {[file exists "$TO/$i"] == 0} {
      if {$flag} {
         set erg [tk_dialog .err "update message:" \
"You do not have yet installed the Macro $i\n \
shall I copy this macro to your $TO ?" \
         warning -1 NO COPY ALL]
      }
      if {$erg} {
         exec cp "$SRC/$i" "$TO"
      }
      if {$erg == 2} {set flag 0}
   }
}

#
# check if any of the existing macros has been updated
#
set flag 1
set Here [pwd]
cd $TO
set allfiles ""
if {[catch {set allfiles [glob *]}]} {return}
cd $Here

foreach i $allfiles {
   if {[file exists "$SRC/$i"] != 0} {
      set len1 [file size "$SRC/$i"]
      set len2 [file size "$TO/$i"]
      if {$len1 != $len2} {
         if {$flag} {
            set erg [tk_dialog .err "update message:" \
"Macro $i has been changed\n \
shall I overwrite this macro in your $TO ?" \
            warning -1 NO COPY ALL]
         }
         if {$erg} {
            exec cp "$SRC/$i" "$TO"
         }
         if {$erg == 2} {set flag 0}
      }
   }
}

#
# check for "send" command and xauth
#

catch {eval "exec wish -f $SRC/CheckSend.tcl &"}

return

