'\"
'\" 
'\" $Header: /project/tcl/src/mxedit/RCS/mxedit.l,v 2.2 1993/07/22 18:45:51 welch Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS MXEDIT cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
mxedit \- A TCL-based, mouse-oriented editor for X.
.SH SYNOPSIS
\fBmxedit\fR ?\fIoptions\fR?\fR ?\fIfile1 file2 ...\fR?\fR
.SH OPTIONS
.IP "\fB\-display \fIdisplay\fR" 15
Display (and screen) on which to display window.
.IP "\fB\-font \fIfontName\fR" 15
Which font to use across all widgets in the application..
.IP "\fB\-geometry \fIgeometry\fR" 15
Initial geometry to use for the window.
.IP "\fB\-noFork\fR" 15
Do not detach into the background. This is needed for use with
mail tools and cron so that these programs know when the
editing session completes.  You can set your VISUAL environment
variable to "mxedit -noFork".
.IP "\fB\-D\fR" 15
A synonym for \fB\-noFork\fR.
.IP "\fB\-debug\fR" 15
Like \fB\-noFork\fR, plus it puts the X protocol into synchronous
mode so that protocol errors are trapped more easily.
.IP "\fB\-tcldebug\fR" 15
Invoke the tcl debugger. See Don Libes' paper in
doc/tcl-debug.ps for details.
.IP "\fB\-libDir\fR \fIpathname\fR" 15
Specifies the directory where the TCL scripts that make up the
bulk of the mxedit application are located.  This is used to
test new versions before installing them into the default library
directory.
.IP "\fB\-initCmd\fR \fIcommand\fR" 15
Specifies an initial command for the per-window TCL intepreter.
This command is invoked after the standard TCL startup code.
.IP "\fB\-globalCmd\fR \fIcommand\fR" 15
Specifies an initial command for the per-process TCL intepreter.
.IP "\fB\-nowin\fR" 15
Suppress display of the per-process information window.
.IP "\fB\-script\fR \fIfilename\fR" 15.
Specifies the initial TCL script to run.  This defaults to
"mxedit.tk" in the library directory.
.IP "\fB\-name\fR \fIname\fR" 15.
Specifies the TK application name for the edit session.  Ordinarily
the name "mxedit \fIfilename\fP" is used.  The TK name is used when
sending TCL commands between applications.
.IP "\fB\-help\fR" 15
Print a summary of the command-line options and exit.
.BE

.SH DESCRIPTION
.PP
\fBMxedit\fR is a TCL-based, mouse-oriented editor for X. It features
pull-down menus with associated keyboard equivalents,
an indefinite undo/redo log that is also used for crash recovery,
"shift-drag" scrolling so you can avoid using the scrollbar,
multiple windows on the same or different files,
and customization via the TCL scripting language.
.PP
If \fBmxedit\fR is invoked
with no arguments, it opens a tutorial file so you can learn how
to use the editor on-line.  This is the best way to learn the editor.
This manual page is more of a reference document that describes
the inner workings of the editor so you can customize it to your
preferences.  There is also a bit about customization at the
end of the tutorial file.
.PP
\fBMxedit\fR is built upon the TCL scripting language and the TK
widget set.  See the "Tcl" man page for basic information about
writing TCL scripts.  \fBMxedit\fR extends the Tcl built-in commands
with additional commands for file editing;  the \fBmxedit\fR commands are
described in the COMMANDS section below.
.PP
Commands may be invoked in
any of three ways:  the command subwindow, pull-down menus, and keystroke
bindings.  The command subwindow is a small entry window that is
displayed at the bottom of the \fBmxedit\fR window.  When it is displayed,
commands may be entered there. Typical commands entered here are
to open a window on a new file (\fBedit\fP \fIfilename\fP)
or change the file being edited (\fBsw\fP \fIfilename\fP).
However, you can try out any
TCL expression in this subwindow.
.PP
Pull-down menus appear in a bar at the
top of the \fBmxedit\fR window, and may be invoked by pressing the
left mouse button
over the menu name and releasing it over an entry in the menu.
A single left click on the menu button leaves the menu posted
until you click again, on an item to select it, or off the menu
to dismiss it.
A middle press-and-drag on a menu button "tears off" the menu.
It will remain posted until you click with the left button
on the menu button.
Each menu
entry has a command associated with it;  when the entry is invoked, the
command is executed (see the \fBmxMenu\fP command for information on
how to create and modify menus).
.PP
The third command invocation
mechanism is through
keystroke bindings:  certain keystrokes, or combinations of keystrokes,
have commands associated with them.  When the keystroke sequence is typed,
the associated command is executed (see the \fBmxBind\fP command for
details).  For example, the ``a'' key
is normally bound to the command \fBmxInsert a\fR, which causes
character ``a'' to be inserted at the caret location.
.LP
Many commands may be invoked either through a menu entry or a keystroke
binding;  for these commands, the keystroke sequence bound to the command
appears at the right side of the menu entry.  If you change or
add new bindings for menu command, be sure to use the \fBmxMenuBind\fP
command so the display of the keyboard accelerator is kept consistent.

.SH CARET AND SELECTION
.PP
The mouse may be used to position the caret (the insertion point)
and to select ranges of text.  The same actions apply both to the file
or to the search and command subwindows.
Left-clicking on a character positions the caret just before
that character.  Right-clicking will select all of the characters
from the caret up to and including the character under the pointer.
If the left button is clicked twice in quick succession without
moving the mouse, it invokes word selection:  the word containing
the character under the pointer is selected, the caret is positioned
at the left side of the word, and future right clicks will select
only full words.  If the left button is triple-clicked, line selection
will be invoked.  If the control key is held down while left- and
right-clicking, the selection will be set without changing the caret
or input focus.  Note, an unmodified right-click always defines a
selection anchored to the caret, even if the previous left-click
was modified.
.PP
The actions associated with mouse clicks are configurable
via the regular TK binding mechanism that associates mouse
actions with commands.  Alternate sets of mouse bindings are
available under the Help menu.  Openwin and Motif style
binding sets are available.  For details, select the
"Quick Intro" Help menu entry.
.PP
There is also a keyboard binding, <Control-space>, that will
begin a selection.  This puts the editor into a mode in which
commands that move the caret will also extend the selection.
While you are extending the selection, you can jump the caret to the
other end of the selection with the <Mod1-space> binding.
This enables you to adjust the other end of the selection with
keyboard commands that move the cursor.

.SH KILL BUFFERS
.PP
In addition to the primary X selection and cutbuffer,
mxedit maintains a stack of kill buffers.
(The idea is modeled after the kill ring in emacs.)
The Cut and Copy operations under the Edit menu
put things into a stack of kill buffers,
as well as the X cutbuffer.
(Note that the "Delete SEL" operation does not
save the selection in either the X cutbuffer or the kill buffers.
Use this to delete stuff you don't want later.)
The state of the kill buffers is stored in a process-global
TCL interpreter context, so it is shared among windows
implemented by the same mxedit process.
You can view the contents of the kill buffers via
the Extras menu entry "Show kill buffers".
.PP
There is a notion of a current (top) kill buffer,
and sequential cut commands append to the same
buffer.  However, if you do a cut,
then do some other operations,
the next cut will push a new buffer onto
the kill stack.
The Yank operation inserts the current (top)
kill buffer at the caret.  The top kill buffer remains
current until a Yank-pop command is done.
Yank-pop has to be done right after a Yank.
It pops the top of the kill stack,
replaces the value just inserted with the last Yank,
and then inserts the new, top kill buffer.

.SH FILE OPERATION SUMMARY
.PP
\fBMxedit\fR supports multiple windows open on the same or different file.
Many of the file operations are available under the File menu.
To open a new window on the same file, select "Open a new window",
or use the <Control-o> keyboard command.  To open a
particular file, select its name (i.e., make it the X primary selection)
and invoke "Open file SEL". There is also a directory browser under
the file menu that lets you list directories and open files.
Most commonly, however, you will probably type a command to open
another file as described in the next section.
.PP
A number of File operations are available through the TCL command
interface by typing into the Command subwindow.
The "mxOpen" TCL command opens a new window on a named file.
The arguments to mxOpen are the same as the command line options to
the \fBmxedit\fR program.  To create a new file, simply use mxOpen to
open it by name, and the file will be created when you invoke Save.
The "mxRead \fIfilename\fP" TCL command inserts the contents of a file at the caret.
The "mxSave \fIfilename\fP" TCL command writes out the editor buffer
to the named file.
The "mxSwitch" TCL command changes which file is being editted.  The
last file and position within it are remembered so you can switch
back using the "mxSwitchBack" command.
.PP
Short aliases for these and other commands have also been defined,
however the primary command names are distinquished with the "mx"
prefix to avoid conflict with other TCL packages.  The aliases are defined in the file
$mxLibrary/mxedit.aliases.  Some of these include:
.PP
    SHORT	LONG
    mx	mxOpen
    edit	mxOpen
    readf	mxRead
    sw	mxSwitch
    save	mxSave
    reset	mxReset
    quit	mxQuit

.SH "COMMAND SUBWINDOW"
The command subwindow allows commands to be typed in directly,
instead of invoking them through keystroke bindings or menus.
When active, it appears at the bottom of the \fBmxedit\fR window.  It can
be activated with the \fBmxCommandFocus\fR command,
or by selecting "Open command window" in the \fBWindow\fP menu.
Commands may be entered and
edited in the command subwindow, and are invoked by typing
carriage-return in the window.  When a command
is invoked, it is not deleted from the command subwindow, in order
to permit it to be re-invoked easily.  The
command window is de-activated by typing \fB^Q\fR in it,
or by selecting "Hide command window" in the \fBWindow\fP menu.
.PP
In practice, the command window is most often used to
open windows on other files (\fBmxOpen\fP or \fBmx\fP)
or switch to anotherfile (\fBmxSwitch\fP or \fBsw\fP).
Note that the command window evaluates its commands in the
context of the per-window TCL interpreter, so you can type
in any TCL command.

.SH "SEARCH SUBWINDOW"
The search subwindow is used to enter search and replacement strings.
When active, it appears at the top of the \fBmxedit\fR window, just underneath
the menu bar.  If it isn't active and a search or replacement command
is invoked that requires one of its entries, then the window is
activated.  It may also be activated using the \fBmxSearchFocus\fR
command.  The left entry in the window is used to enter a search
pattern and the right entry is used to enter a replacement string.
The values of these two entries are always available in the \fBmxSearchString\fR
and \fBmxReplaceString\fR global variables, respectively.
If carriage-return or <Control-f> is typed in the ``Search:'' entry,
then the \fBmxFindInner\fR Tcl procedure is used to do the search.
If carriage-return is typed in the ``Replace:'' entry, then the
\fBmxFindInner\fR Tcl procedure is used to perform the replace.
The search subwindow can be deactivated by typing \fB^Q\fR in it.

.SH KEYBOARD COMMANDS
.PP
Many of the more common commands have associated keyboard
equivalents.  These appear in the menu along with the command so
you can learn them as you go along.  The commands typically involve
either the Control, Mod1, or Escape key.  On Sun4 keyboards, the
Mod1 key (also known as "Meta")
is the one next to the space bar labeled with a diamond.
The keyboard sequences appear in the menus in the same format that you specify
them in TCL:
.TP 15
<Control-x>
Hold the Control and 'x' keys down at the same time.
.TP
<Mod1-x>
Hold the Meta and 'x' keys down at the same time.
.TP
<Escape>x
Press Escape, then press 'x'.

.PP
The complete list of current keybindings is available under the
Help menu.  For your reference, a few of the more common ones are
listed below.
.TP 15
<Control-h>
Destructive backspace.
.TP
<Mod1-h>
Move the insert point one character left.
.TP
<Control-l>
Delete the character to the right of the insert point.
.TP
<Mod1-l>
Move the insert point one character right.
.TP
<Control-j>
Open a new line below the current one.
.TP
<Mod1-j>
Move the insert point down one line.
.TP
<Control-k>
Open a new line above the current one.
.TP
<Mod1-k>
Move the insert point up one line.
.TP
<Control-w>
Delete previous word.
.TP
<Mod1-w>
Move insert point back one word.
.TP
<Control-n>
Delete next word.
.TP
<Mod1-n>
Move insert point forward one word.
.TP
<Control-u>
Undo the previous operation.
.TP
<Control-a>
Repeat the sequence of commands since the last mouse click.
.TP
<Control-s>
Save.
.TP
<Control-q>
Quit.
.TP
<Escape>s	
Switch to previous file.
.TP
<Control-f>
Search for the current pattern.
.TP
<Mod1-f>
Search for the current selection.
.TP
<Escape>f	
Clear the current search pattern and focus on the search window.
.TP
<Control-b>
Search back for the current pattern.
.TP
<Mod1-b>
Search back for the current selection.
.TP
<Control-r>
Replace the selection with the current replacement pattern.
.TP
<Escape>r	
Clear the replacment pattern and focus on the replace window.
.TP
<Mod1-r>
Search and replace within the current selection.
.DE

.SH "MARKS"
.PP
A mark is a string that identifies a position in the file.  It
has the format
.DS
\fIline\fB.\fIchar\fR
.DE
where \fIline\fR is a line number in the file and \fIchar\fR is
a position within that line.  For historical reasons, lines
number from 1 and characters number from 0.
.PP
Most commands that deal with positions in the file, such as
\fBmxSee\fP and \fBmxDelete\fP, take marks as arguments.  Typically,
marks are stored as the values of variables, although they may also be
typed in directly.  The \fBmxMark\fP command provides for simple mark
arithmetic.  The position indicated in a mark
need not actually exist in the file;  at the time the mark is used it
is rounded off to the closest actual position in the file.  For example,
if the line number doesn't exist in the file then it is changed to
the last line;  if the character position would like off the end of
the line, then it is rounded to the position of the last character
in the line.
.LP
When a command specifies that one of its arguments must be a mark,
the mark may either be specified in the \fIline.char\fR form
(either directly or through command or variable substitution),
or it may be specified symbolically using one of the following names, which
refer to special locations:
.RSquit
.TP
\fBbottom\fP
This special mark refers to
the character that appears in the bottom left corner of the window.
.TP
\fBcaret\fP
The special mark \fBcaret\fP corresponds to the character just to
the right of the caret position.
.TP
\fBcenter\fP
The leftmost character on the center line of the window.
.TP
\fBeof\fP
The last character in the file (which is always a newline character).
.TP
\fBsel.left\fP
The leftmost selected character.  This form of mark may only be used
if the selection is in the file that's in this window.
.TP
\fBsel.right\fP
The rightmost selected character.  This form of mark may only be used
if the selection is in the file that's in this window.
.TP
\fBtop\fP
The character that appears in the top left corner of the window.

.SH "HISTORY"
Under normal circumstances,
\fBMxedit\fR continuously records all the top-level commands being executed,
including those coming from keystrokes, menu entries, and the command,
search, and replace subwindows.
On each button click, undo, or search operation, all of the recorded
commands are saved in the variable \fBmxHistory\fR and the record is
cleared.  Thus the \fBmxHistory\fR variable describes all the commands
executed between the last two events in the above group.  It may
then be invoked as a command to repeat recent actions.
.PP
Under normal circumstances, \fBmxedit\fR does not record information about
mouse clicks,  searching, undoing, or \fBmxHistory\fR commands.
In addition, changes of focus to the command, search, 
or replace subwindows are not normally recorded.  Having these commands
included in the \fBmxHistory\fR variable turns out to cause more trouble
than good.  However, much of this behavior is enforced by using
the \fBmxHistory\fR command in the key
bindings and menus established by the \fBmxedit\fR startup file, so you can
change it if you wish.  Only the mouse click behavior and \fBmxedit\fR's refusal
to record \fBhistory\fR commands are hard-wired.  See the \fBmxHistory\fR
command for information on how to control command recording.

.SH CUSTOMIZATION
.PP
The users ~/.mxedit file is consulted each time a new window is
created.  This is a TCL script that typcially defines some
variables and a few hook procedures.  The hooks are called
at appropriate times during the initialization of the window.
This area of mxedit is still underdeveloped, with the main
support being for changing the keyboard bindings, although this
will gradually change.
.PP
The standard format for your .mxedit file is:
.DS
#
# Joe's .mxedit file
#

# Set up some controlling variables.
# Here are their defaults
# set mxDbSystemEnabled 1
# set mxDbUserEnabled 1
# set mxFeedback top
# set mxIndent 4
# set mxKeyBindingProc mxKeyBindings
# set mxLogFeedback 0
# set mxNoRegExps 0
# set mxScroll left
# set mxScrollBindingProc mxScrollBindings
# set mxSelectBindingProc mxSelectionBindings
# set mxTagFiles tags

# Here is how you'd change some of them.
set mxScroll right
set mxSelectBindingProc mxMotifSelectionBindings

# Define a procedure that is called after each window is created
proc mxUserOpenHook { filename } {
    # Adjust some key bindings
    mxMenuBind <Control-x> Edit "Cut SEL"
    mxBind <Control-n> mxDown1Line
    mxBind <Control-p> mxUp1Line
    # Init my exmh package
    MhInit
}

# Define some other TCL procedures that you find handy

# mxIncrSel - replace a pattern with an incrementing number

proc mxIncrSel { pattern } {
    global myIncrN
    global mxReplaceString mxedit
    if ![info exists myIncrN] {
	set myIncrN 1
    }
    search forw $pattern
    set mxReplaceString $myN
    incr myN
    $mxedit replace selection $mxReplaceString
}
.DE

.SH "VARIABLES"
.LP
There are several Tcl global variables that are set or used by \fBmxedit\fR
in some situations:
.RS
.TP
\fBmxDbSystemEnabled\fP
This boolean variable controls whether or not the editor maintains an entry
in a system-wide database that records edit sessions.  This database
is used to record the usage of the editor.  A zero or non-integer
value to this variable disables the updating of this database.
You can see the contents of this database by running the "dbmDump"
program with no argument.
.TP
\fBmxDbSystemEntry\fP
This is a copy of the system-wide session database entry.
.TP
\fBmxDbSystemKey\fP
This is the key to the system-wide session database entry.
.TP
\fBmxDbUserEnabled\fP
This boolean variable controls whether or not the editor maintains an entry
in a per-user database that records edit sessions.  This database
is used to detect conflicting editor sessions.  A zero or non-integer
value to this variable disables the updating of this database.
You can display this database by selecting the "Show session database"
under the Help menu.
.TP
\fBmxDbUserEntry\fP
This is a copy of the per-user session database entry.
.TP
\fBmxDbUserKey\fP
This is the key to the per-user session database entry.
.TP
\fBmxedit\fP
This variable holds the TK pathname of the mxedit widget.
.TP
\fBmxFeedback\fP
This variable controls placement of the feedback entry widget.
By default the feedback entry is at the "top" of the window,
but you can change that by setting \fBmxFeedback\fP
to "bottom" in your ~/.mxedit file.
.TP
\fBmxFile\fP
Set by \fBmxedit\fR to the name of the file loaded in the window.
.TP
\fBmxFont\fP
The name of the current font.  All widgets are displayed in this font.
Change this by using the \fBmxFont\fP command.  It won't work
to just change the value of this variable.
.TP
\fBmxGeometry\fP
The current window geometry.
Change this by using the \fBmxGeometry\fP command.  It won't work
to just change the value of this variable.
.TP
\fBmxHeight\fP
Set by \fBmxedit\fR to indicate
the height of the window, in lines of text.  If the last line
appearing in the window is only partially visible, it doesn't count.
.TP
\fBmxHistory\fP
\fBMxedit\fR automatically changes this variable on each mouse click to hold
information about all the recently-executed commands.  Several of
the default key bindings and menu entries also set this variable.
See the HISTORY section and the \fBhistory\fR command for more
information.
.TP
\fBmxIndent\fP
The number of spaces to indent or outdent when using
the mxIndentLine, mxIndentSel, mxOutdentLine, or mxOutdentSel
command procedures.
.TP
\fBmxInterpName\fP
This is the TK application name that is used when sending TCL commands
to the editor.  Normally this is "mxedit $mxFile".
.TP
\fBmxKeyBindingProc\fP
Set this variable to the name of a TCL procedure to run in order to
set up the keyboard bindings for the mxedit widget.  The default
proc is \fBmxKeyBindings\fP, and a common alternate is
\fBemacsKeyBindings\fP.  The procedure name \fBuserKeyBindings\fP
is suggested (and understood by the Help menu) if you want
to define your own, complete set of key bindings.
.TP
\fBmxLibrary\fP
\fBMxedit\fR presets this variable to the location of the directory containing
the TCL scripts that make up the application.  The tutorial file is
also kept in this directory.
.TP
\fBmxLogFeedback\fP
This boolean controls the logging of error messages to stderr. By
default this variable is set to zero to suppress logging.
.TP
\fBmxNoGlobalWindow\fR
If this variable is set to ``1'', then the display of the global window
is suppressed.  This window maintains a list of files being editted.
.TP
\fBmxNoRegExps\fR
If this variable is set to ``1'', searches and replaces will use plain
strings.  By default, pattern matching takes place with vi-style regular
expressions.
.TP
\fBmxScroll\fP
This variable controls the placement of the scrollbar.  It can take on
the values "left", "right", or "none".
.TP
\fBmxScrollBindingProc\fP
Set this variable to the name of a TCL procedure to run in order to
set up the srolling-related bindings for the mxedit widget.  The default
proc is \fBmxScrollBindings\fP that uses the middle mouse
button for drag scrolling.  The old bindings to shift-left
can be obtained by using the \fBmxOldScrollBindings\fP proc.
The procedure name \fBuserScrollBindings\fP
is suggested (and understood by the Help menu) if you want
to define your own set of scroll-related bindings.
.TP
\fBmxSelectionMode\fP
This variable is used to effect the granularity of selections.
Sensible values for this variable are "char", "word", or "line".
.TP
\fBmxSelectBindingProc\fP
Set this variable to the name of a TCL procedure to run in order to
set up the selection-related bindings for the mxedit widget.  The default
proc is \fBmxSelectionBindings\fP that uses the left mouse
button to start a selection, and the right button to extend it.
An alternate binding set that uses just the left button to
start and drag out a selection
can be obtained by using the \fBmxMotifSelectionBindings\fP proc.
The procedure name \fBuserSelectionBindings\fP
is suggested (and understood by the Help menu) if you want
to define your own set of selection-related bindings.
.TP
\fBmxTagFiles\fP
List of tags files to check in \fBtag\fP command, separated by
white space.  See the \fBtag\fP command for details.  This variable
is read by \fBmxedit\fR but not written.
.TP
\fBmxVersion\fR
Set by \fBmxedit\fR to hold a version number in the form \fIx.y\fR, where
changes in \fIx\fR correspond to major revisions with probable
incompatibilities, and changes in \fIy\fR represent small bug fixes
and upgrades that should not cause substantial compatibility problems.
.TP
\fBmxWidth\fP
The width of the window, in characters.  If the last character position
is only partially-visible, then it doesn't count.  If a variable-width
font is being used, the size of the letter 'n' is used in computing
the window's width.
.RE

.SH HOOKS
.PP
The mxedit scripts call out to user-defined hook procedures at
a few places during execution.  The syntax for
defining a TCL proc is:
.DS
proc name { arg1 arg2 ... } {
    body
}
.DE
The argument list can be empty, {}.  The body is a set of TCL commands
separated by newlines or semicolons.
.TP
\fBmxLocalBindings {}\fP
This proc is called as the last part of creating a new window.
This procedure is normally defined in the "mxedit.local" script
in order to provide site-wide customization.  This is invoked
just prior to \fBmxUserOpenHook\fP.
.TP
\fBmxUserOpenHook { filename }\fP
This proc is called as the last part of creating a new window.
This is the place to put your customized keystroke bindings.
(There is a class-oriented key-binding mechanism that would allow
you to setup bindings before the editor widget is defined,
but the mxBind and mxMenuBind procedures described below
don't take advantage of this, yet.)
.TP
\fBmxStateChangeCallback {}\fP
This is called when a file changes between the clean and dirty state.
The \fBwritten\fP widget command can be used to find out the current state.
The default implementation of this hook updates the title bar and icon
name so there is a "!" next to the file name when it is dirty.
.TP
\fBmxSizeChangeCallback {}\fP
This is called when the window changes size.
The \fBmxGeometry\fP command can be used to find out the current geometry.
The default implementation of this hook adjusts the entries under
the Left and Right window placement menus.

.SH "COMMANDS"
.PP
There are two groups of commands presented below.  The first is the
widget commands that are primitives implemented in C.
The second group is a set of TCL procedures that compose the
primitives into more useful editing operations.
In addition to these
commands, any of the Tcl built-in commands may also be used.
Whenever a top-level command is invoked (i.e. typed into the command
subwindow, or in response to a keystroke or
menu selection, as opposed to the execution of a command procedure), if it
returns a non-empty result then the result is displayed in the message
window.  If the command returns an error then the error message is
displayed in the message window.

.SH "WIDGET COMMANDS"
.PP
Each editting window contains an instance of the mxedit widget.
If there are multiple windows open, the editor creates a new
TCL interpreter context for each one.  Therefore, it turns out
there is a single instance of the mxedit widget per TCL interpreter.
This allows the TCL scripts to keep the identity of the
mxedit instance in a global variable, and provide convenience
procedures that are a bit simpler to use.  For example,
the widget provides a command to insert bytes at a mark.
Without any wrapper procs, one would invoke this operation in
typical TK object-style as follows, where ".mx.edit" is
the TK pathname of the mxedit widget instance.
.PP
    .mx.edit insert "Hello World"
.PP
Unfortunately, this exposes the TK pathname, which might change
if you reorganized the user interface.  (The .mx is a frame that
holds the scrollbar and the mxedit widget.)  Because there is only
one mxedit widget per main window, a global variable is used
instead to record the TK pathname.
.PP
    global mxedit
    $mxedit insert "Hello World"
.PP
This usage leads us to the final solution, which is to provide
a set of small wrapper TCL procs that hide the use of the global variable.
The use of the "args" keyword in the parameter list means that
a variable number of arguments can be passed to the TCL proc.
(In our example, the insert command can take an optional
mark-valued argument that specifies where to do the insert.)
Follow this style of using eval in conjuction with $args so that
the arguments get evaluated properly.
.DS
proc mxInsert { args } {
    global mxedit
    eval {$mxedit insert} $args
}
.DE
In the following description, the core widget commands
are presented in their TCL proc wrapper form.  Note also
that some of the heavier-weight operations like quit,
reset, switch, save, and write are also more complicated
internally because they guard against error conditions
and display dialog boxes if needed to resolve problems.
.TP
\fBmxCaret \fImark\fR
.TP
\fBmxCaret display \fItype\fR
In the single-argument form of this command, the caret is moved to
just before the character at the position given by \fImark\fP.
The two-argument form is used to change the way the caret position
is displayed.  If \fItype\fR is \fBcaret\fR, the caret position will
always be marked by displaying a caret just before the caret
character.  If \fItype\fR is \fBblock\fR, the
caret position will be marked by displaying the caret character in
reverse video.  If \fItype\fR is \fBoff\fR, then the caret position
will not be marked with any sort of special display.  Finally, a \fItype\fR
of \fBviblock\fR marks the caret position with a block when in vi mode
and with a caret otherwise (this mode is only relevant for \fBtx\fR).
The \fBcaret\fR command returns an empty string.
.TP
\fBmxClean\fR
Pretend that the contents of this window were just written to disk (but
don't actually write anything).  Until the next time the file is
modified, \fBmxedit\fR will assume that the window is ``clean'':  if you invoke
commands like \fBmxQuit\fR, \fBmxReset\fP or \fBmxSwitch\fR
then \fBmxedit\fR will happily discard the
contents of the window without warning you or giving you a chance to
abort the command.
.TP
\fBmxColumn \fImark\fR
Return the column corresponding to the left edge of the character
at the position indicated by \fImark\fR.  \fIMark\fR must be a valid
mark.  Columns are computed by treating normal characters as one
column wide, control characters as two columns wide, and tabs as
wide enough to extend up to the next 8-column boundary.  Character 0
of a line is at column 0.
.TP
\fBmxControl \fIoption string\fP
This command performs control-character processing on \fIstring\fR,
depending on the value of \fBoption\fR (abbreviations are OK):
.RS
.TP
\fBmxControl backslash \fIstring\fR
Returns a string that is identical to \fIstring\fR except that
non-printing characters are replaced with backslash sequences.
The newline control character is replaced with \fB\en\fR, tab is
replaced with \fB\et\fR, backspace is replaced with \fB\eb\fR, and
any other non-printing character is replaced with \fB\e\fIddd\fR
where \fIddd\fR gives the octal value of the character.
.TP
\fBmxControl binding \fIstring\fR
This command is used primarily to produce a printable description of
a keystroke sequence that is bound to a command.  It returns a string
consisting of space-separated fields corresponding to the characters
of \fIstring\fR.  If a \fIstring\fR character is space, its
corresponding field is ``SPACE'';  if the \fIstring\fR character
is a normal printing character then the field is just that
character;  if the \fIstring\fR character is
rubout (177\d\s-18\s+1\u) the corresponding field is ``DEL'';
if the \fIstring\fR character is a control character, the
corresponding field is of the form ``C-a''; if the \fIstring\fR
character has its high-order bit set (200\d\s-1\8\s+1\u), then the
field is the same as if the high-order bit were not set, except that
``M-'' is prepended (301\d\s-1\8\s+1\u translates to ``M-A'').
.PP
THIS IS OUTDATED AND NEEDS TO BE FIXED TO GENERATE VALID
TK BINDING SEQUENCES LIKE <Control-x>, <Mod1-x>, or <Escape>x.
.TP
\fBmxControl make \fIstring\fR
Returns a string of the same length as \fIstring\fR.  Each character in
the result is the control equivalent
of the \fIstring\fR character (e.g., ``a'' and ``A''
convert to control-A).  The character ``?'' converts to
rubout (177\d\s-1\8\s+1\u).
You may not use this command to generate a null character (0).
.RE
.TP
\fBmxDelete\fR \fImark1 \fR[\fImark2\fR [\fBnoviewchange\fR]]
Delete all of the characters between \fImark1\fP and \fImark2\fP,
inclusive.  If \fImark2\fR isn't specified, then delete the single
character at \fImark1\fR.  Normally, this command changes the
view in the window if necessary to ensure that the point of the
deletion is visible;  if \fBnoviewchange\fR is specified then
the view in the window will not be changed.  Returns an empty string.
.TP
\fBmxExtract\fR \fImark1 \fR[\fImark2\fR]
Return as result all of the characters in the file between the two
marks \fImark1\fR and \fImark2\fR.  If \fImark2\fR is omitted, then
return the single character at \fImark1\fR.
.TP
\fBmxHistory\fR \fIoption\fR [\fIarg\fR]
Control the history recording process.  Note that this replaces
the built-in TCL history command.  The exact function
depends on \fIoption\fR (which may be abbreviated uniquely):
.RS
.TP
\fBmxHistory add \fIinfo\fR
Append \fIinfo\fR to the current history record as if it had been
invoked as a command.  Returns an empty string.
.TP
\fBmxHistory clear\fR
Discard all of the information in the current history record.
Returns an empty string.
.TP
\fBmxHistory ignore \fIcommand\fR
Execute \fIcommand\fR but don't record it in the history record.
Note that no \fBhistory\fR commands are ever recorded, even if they don't
appear as the \fIcommand\fR argument to \fBhistory ignore\fR.
Returns an empty string.
.TP
\fBmxHistory info\fR
Returns the current history record, with commands separated by
newlines.
.TP
\fBmxHistory next \fIvarName\fR [\fIcommand\fR]
Store the current history record in the variable \fIvarName\fR,
then clear the history record.  After clearing the history
record, if \fIcommand\fR is specified then execute it but don't
record it.  Returns an empty string.  In practice, the
\fIvarName\fR used is "mxHistory".
.TP
\fBmxHistory off\fR
Disable history recording.  Invocations of \fBmxHistory off\fR
nest:  recording will not resume until an equal number of
\fBmxHistory on\fR commands have been invoked.  Returns an empty string.
.TP
\fBmxHistory on\fR
Re-enable history recording if the cumulative number of \fBmxHistory on\fR
commands is greater than or equal to the number of \fBmxHistory off\fR
commands.  This command is ignored if history recording is already
enabled.  Returns an empty string.
.RE
.TP
\fBmxIndent\fR \fImark1 mark2\fR [\fB+\fR|\fB\-\fR] \fIamount\fR
Change the indentation of all the lines between \fImark1\fP
and \fImark2\fP, inclusive.  If no sign is given, then \fIamount\fP
specifies an absolute indentation:  for each of the lines,
the indentation will be set to \fIamount\fP.  If \fIamount\fP is
preceded by a minus (plus) argument, then the indentation of each line will be
reduced (increased) by \fIamount\fP units.
To set the indentation for a line to \fIi\fP, \fBmxedit\fR deletes all the
leading blanks and tabs in the line, then inserts \fIi\fP/8 tabs followed
by (\fIi\fP mod 8) spaces.  Returns an empty string.
.TP
\fBmxInsert\fR \fIbytes\fR [\fImark\fR]
If \fImark\fR is specified, it contains a mark;  \fBmxInsert\fR
will insert the contents of the \fIbytes\fR
argument just before the character at position \fImark\fR.  Otherwise
the command will insert \fIbytes\fR at the position of the caret.
Returns an empty string.
.TP
\fBmxMark\fI src op args\fR
Return a position in the file in the form \fIline.char\fR, where
\fIline\fR is a line in the file and \fIchar\fR is a character in
the line (lines number from 1, characters from 0).
\fISrc\fR must be a valid mark;
the return value is computed
by performing some operation on the position given by \fIsrc\fP,
depending on \fIop\fR and \fIargs\fR:
.RS
.TP
\fBmxMark \fIsrc\fR
Return the value of mark \fIsrc\fR.  This form is used to retrieve
the value of a built-in mark such as \fBsel.left\fR.
.TP
\fBmxMark \fIsrc direction amount units\fP
Return the position of
the character \fIamount units\fP away from \fIsrc\fP.  \fISrc\fP
must be a valid mark.  \fIDirection\fP
must be \fBforward\fP or \fBbackward\fP; it indicates which direction
to move from \fIsrc\fP.  \fIAmount\fP is a decimal number indicating
how far to move, and \fIunits\fP indicates the units for motion:
\fBchars\fP, \fBwords\fP, or \fBlines\fP.  For example,
\fBmark $b forward 1 word\fP will set variable \fBa\fP to
point to the beginning of the word just after the one containing
the position indicated by variable \fBb\fP.
.TP
\fBmxMark \fIsrc \fBchar \fIindex\fR
Return the position of the \fIindex\fP'th character in the line
given by \fIsrc\fP.  If \fIindex\fR is -1, then \fIdst\fP will
refer to the last character on \fIsrc\fR's line.
.TP
\fBmxMark \fIsrc \fBcolumn \fIindex\fR
Return the position of the character that covers column \fIindex\fR
on the line containing \fIsrc\fR.  Columns are computed by treating
normal characters as one space wide, control characters as two
spaces wide, tabs as wide enough to extend up to the next 8-column
boundary, and the newline at the end of the line as infinitely wide.
Columns number from 0.
.TP
\fBmxMark \fIsrc \fBline \fIindex\fR
Return the position whose line number is \fIindex\fP but whose
character position is the same as \fIsrc\fP's.
.TP
\fBmxMark \fIsrc \fBparenthesis\fR [\fIvarName\fR]
Return the position of the first character of the
parenthesis that matches the one pointed
to by \fIsrc\fP.  If \fIsrc\fP doesn't point to a parenthesis, then
return \fIsrc\fP.  If \fIvarName\fP
is specified, then it names a variable that is set to refer to the
last character of the matching parenthesis (this feature is only useful
for parentheses that are more than one character long).
.TP
\fBmxMark \fIsrc \fBsearch \fIdirection pattern\fR [\fIvarName\fR]
Search for \fIpattern\fP and return the position of the first character
of the matching range.  If \fIvarName\fP is given, it names a
variable that is set to the
last character of the matching range.  The search starts at the
position given by \fIsrc\fP and continues in \fIdirection\fP,
which must be either \fBforward\fP or \fBbackward\fP.  The search
is circular:  if a forward search reaches the end of the file then
it continues at the beginning;  if a backward search reaches the
beginning of the file then it continues at the end.  If no match
is found, then \fIsrc\fR is returned (and stored in the variable
named by \fIvarName\fP, if specified).
.RE
.TP
\fBmxSelection \fIoption \fR[\fIarg ...\fR]
This command complements the built-in TK \fBselection\fP command.
It is used to set, clear and query the existence of the selection
as described below.
Note1: the command \fBselection get\fR
is different from the command \fIextract sel.left sel.right\fR:
\fBselection get\fR will return the contents of the selection even if
the selection is in another window, but
\fBextract sel.left sel.right\fR can only return
information from this window.
.RS
.TP
\fBmxSelection clear\fR
If there is something selected in this window, the selection is cleared,
so nothing will be selected.  If there is nothing selected in this window,
there is no effect.  Returns an empty string.
.TP
\fBmxSelection here\fR
Returns \fB1\fR if there is something selected in the file in this window.
Returns \fB0\fR if there is no selection or if the selection is not in
this window's file.
.TP
\fBmxSelection set \fImark1 \fR[\fImark2\fR]
Change the selection to consist of the characters between \fImark1\fP
and \fImark2\fP, inclusive.  If \fImark2\fR isn't specified,
then select the single character at \fImark1\fR.  Returns an empty string.
.TP
\fBmxSelection anchor \fImark\fP
Anchor a selection around the mark depending on the value of
the \fBmxSelectionMode\fP variable.  This variable takes on
the values \fBchar\fP, \fBword\fP, or \fBline\fP.  Typically mark
is given in the @x,y format in response to a mouse click, and
this command begins a selection in the appropriate mode.  The selection
can be extended by the \fBadjust\fP or \fBf_adjust\fP option.
.TP
\fBmxSelection adjust \fImark\fP
Extend the selection from the caret to the specified mark,
taking into account the selection mode specified by
the \fBmxSelectionMode\fP variable.
.TP
\fBmxSelection f_adjust \fImark\fP
Extend the selection from the point of the last anchor mark to
the specified mark, taking into account the selection mode specified by
the \fBmxSelectionMode\fP variable.
This is used to adjust "floating" selections
that are not anchored on the caret.
.RE
.TP
\fBmxNewline\fP
Insert a newline character at the position of the caret, and
adjust indentation.  If the caret's initial line
consists of nothing but space, then all the space on the line is
deleted.  If the caret's initial line contains leading space, it
is reorganized to consist of zero or more tabs followed by zero or
more space characters, such that the total width of white space is
the same after the change as before (a tab counts for eight characters).
Tabs and spaces are inserted on the caret's new line to match the
indentation of the caret's initial line.
.TP
\fBmxQuit\fP
Prepare to destroy the window. The top-level \fBmxQuit\fP procedure
does more than call the quit widget primitive.
If this is the last remaining window on its file
and if the file has been modified since the last time it was written,
then the user is notified and given a chance to save the file or
abort the command.  This command always returns an error, in order to
abort any partially-executed commands that are in progress (execution
of further commands on the window could cause a core dump).
.TP
\fBmxQuote\fP
Quote the next input character.  The mapping for the next character will
be ignored and the character will be inserted.  The return value is always
an empty string.
.TP
\fBmxRead \fIfile\fR
Read \fIfile\fP and insert its contents just before the caret.
.TP
\fBmxReplace \fR[\fIoption args\fR]
Replace the selection, as determined by \fIoption\fR and \fIargs\fR:
.RS
.TP
\fBmxReplace\fP
If no \fIoption\fP is given, then replace the selection by the value
of the \fBmxReplaceString\fP global variable.  Application note: the
\fBmxReplaceString\fP is set by the application
(i.e., by \fBmxFindInner\fP command), not by the mxedit widget implementation.
.TP
\fBmxReplace range\fR \fIstart stop\fR [\fIpattern string\fR]
Search the range of text between the marks \fIstart\fR and \fIstop\fR,
inclusive for occurrences of \fIpattern\fP.
Replace each occurrence with
\fIstring\fP.  If \fIpattern\fP and \fIstring\fP aren't specified, then
they are taken from the \fBmxSearchString\fP and \fBmxReplaceString\fR
global variables.  If the search subwindow isn't visible, don't
do any replacement but open the search subwindow and focus input
on the replacement string entry.
By default, vi-style regular expressions are used for the pattern and
replacement strings.
If the variable ``mxNoRegExps'' is set to ``1'', only simple matching is done:
there are no wild cards.
Matches must be within a single line of the file.
.TP
\fBmxReplace selection \fIstring\fP
Delete the selection and insert \fIstring\fP in its place.
.RE
The \fBmxReplace\fR command always returns an empty string.
.TP
\fBmxReset\fR
.VS
Discard the version of the file that is currently loaded in memory and
re-load the file from its disk version.  Any changes that have been
made since the last time the file was saved will be lost.  This
command will affect all of the windows open on the file.  The
top-level \fBmxReset\fP procedure checks against modified files
and pops up a dialog box in that case.
.VE
.TP
\fBmxSave \fR[\fIfileName\fR]
Write the file to disk.  If \fIfileName\fR is given then the
file is written there;  otherwise it is written to the place from
which it was read (i.e. the name displayed in the window's title
bar).  Returns a message containing the file's name and number of
lines.
.TP
\fBmxSearch \fR[\fIdirection \fR[\fIpattern\fR]]
Search for a pattern.  The search starts from the beginning of
the selection (if there is a selection in the window's file),
or from the caret if there's no selection.  \fIDirection\fR indicates which
direction to search, and must be either \fBforward\fR or
\fBbackward\fR.  If omitted, it defaults to \fBforward\fR.
\fIPattern\fP gives a text string to search for;  if not
given, it defaults to the global variable \fBmxSearchString\fP.  If the
search subwindow isn't visible, don't do any searching but open the
search subwindow and focus input on the search string entry.
By default, vi-style regular expressions are used for the pattern and
replacement strings.
If the variable ``mxNoRegExps'' is set to ``1'', only simple matching is done:
there are no wild cards.
Matches must be within a single line of the file.
If a match is found, the matching range is selected and the caret
is set to the beginning of the range.  Returns an empty string.
.TP
\fBmxSee \fImark\fP [\fBtop\fR|\fBcenter\fR|\fBbottom\fR]
Adjust the view in the window so that the character at \fImark\fP
is visible in the window.  If a \fBtop\fR or \fBcenter\fR or \fBbottom\fR
option is given, then the mark will appear at the given position in
the window.  If no position is given, then \fBmxedit\fR will check to see if
\fImark\fR is already visible.  If so, it does nothing.  If not, it
will center \fImark\fR in the window.  Returns an empty string.
.TP
\fBmxSwitch \fIfileName\fR
Change the window to display \fIfileName\fR instead of what's there
currently.  The \fBmxSwitch\fP command procedure first checks against
switching away from the last window on a modified file and
displays a dialog box before invoking the \fBswitch\fP primitive.
.TP
\fBmxTaginfo \fIname\fR
Look up \fIname\fP in the tags file(s).  If
it is found, then return a Tcl list whose first element is the file
containing \fIname\fR and whose second element is a search pattern
identifying the tag's location in the file.
If the global variable \fBmxTagFiles\fR is defined, it must contain a list of
tags files to check.  Those files will be
checked for \fIname\fP in order.  If no \fBmxTagFiles\fP variable exists,
then the file \fBtags\fP in the current directory is searched.
.TP
\fBmxUndo \fR[\fBmore\fR]
.TP
\fBmxUndo recover \fIfileName\fR
Undo recent edits.  If \fBmxUndo\fR is invoked without any arguments,
the most recent modification to the file is undone;  multiple
invocations will toggle the change.  If the
\fBmore\fR argument is given, successive undo's work back through
history;  successive \fBundo more\fP commands will undo every change
back to the beginning of the edit session.  Modifications are undone
in groups delimited by marks in an undo log;  normally,
a mark is placed in the log before and after each user-invoked action
(button click, menu selection, or keystroke) that modifies the file.
Exceptions to this rule occur for keystrokes whose bindings have the
``!'' prefix:  no marks are placed in the log for these actions.
Returns an empty string.  If the \fBrecover\fR option is given, 
then \fIfileName\fR must be the address of a \fBmxedit\fR log.  This command
will read \fIfileName\fR, which describes changes made in a previous
edit session, and apply those changes to the current file.
.TP
\fBmxWritten \fR[\fBallWindows\fR]
Check if the file is written out to disk or not.  This raises
an error if the file is not written out, otherwise it returns
an empty string.  This primitive is used by \fBmxQuit\fP, \fBmxReset\fP,
and \fBmxSwitch\fP command procedures before they call the corresponding
widget primitive.

.SH "EDITOR COMMANDS"
.PP
There are a few more TCL primitives provided by the editor that
apply to the editor application in general, not to the
mxedit TK widget.
.TP
\fBcutbuffer \fIoption\fR
Manipulate the X cutbuffer.  Option should be "get" or "set".
.TP
\fBmxGeometry \fIspec\fR
Set the size and/or location of the window according to the information
in \fIspec\fR.  \fISpec\fR should be in the standard format for X geometry
specifications (\fB80x24\fR, for example).  Returns an empty string.
.TP
\fBmxFileActive \fIfile\fR
Check to see if there is an active edit session on the file.
Returns 1 if there is, 0 otherwise.
.TP
\fBmxFileIdent \fIfile\fR
Returns a unique string that corresponds to the named file.
.TP
\fBmxOpen \fR[\fIoptions\fR] \fIfile\fR \fIfile\fR ...
Create the mxedit widget and compose
it with other widgets into a complete editor window.
\fIOptions\fR and
\fIfile\fR arguments are treated just the same as they are treated
on the command line.
If \fIfile\fR is not specified, a new window is opened on the same
file as the current window.  If no geometry specification is given in
\fIoptions\fR, then \fBmxedit\fR uses the geometry specified
on the command line.  Other options, such
as foreground color and font, default to the values from the invoking
window, rather than looking for X defaults.
\fBmxOpen\fR returns the TK application name of the newly-created window.
This may be used in conjunction with the
TCL \fBsend\fR command to issue commands
to the new window.


.SH "COMMAND PROCEDURES"
In addition to the built-in commands described above, a number of Tcl
command procedures are created by the default \fBmxedit\fR startup file.  They
may be invoked just like built-in commands, and are described below.
.PP
THIS IS STILL INCOMPLETE.  Consult the appendix
to see a more complete set, or use the "Show procedures" entry
under the Help menu.
.TP
\fBmxCaretInfo\fR
Returns a string containing information about the file's length and
the position of the caret.
.TP
\fBmxFont fontname\fP
Set the font for all the widgets to that named by \fBfontname\fP.
If successful, this procedure updates the \fBmxFont\fP global variable
and reconfigures all widgets with text to use the new font.
.TP
\fBmxLine \fIi\fR
Selects line number \fIi\fR and adjusts the view in the window so that
the line number is visible.  Returns an empty string.
.TP
\fBmxMove\fR
This command moves the contents of the selection to the caret position.
Returns an empty string.
.TP
\fBmxBind \fR[\fIsequence\fR [\fIcommand\fR]]
(This is a thin layer over the TK \fBbind\fR command that hardwires
in the identity of the mxedit widget.)
If the \fIsequence\fR and \fIcommand\fR arguments are given,
this command associates
the keystroke sequence \fIsequence\fR with \fIcommand\fR and
returns an empty string.
From now on, whenever \fIsequence\fP is typed in the window,
the Tcl interpreter will be invoked to execute \fIcommand\fP.
If \fIsequence\fP is already bound to a command, then
\fIcommand\fP replaces the previous binding.  If there are two bound
sequences of which one is a prefix of the other, then the shorter
sequence will always match in preference to the longer one.
If \fIcommand\fR is an empty string, then the binding for \fIsequence\fR
(if any) is deleted, leaving \fIsequence\fP unbound.
.RS
.PP
If the first character of \fIcommand\fP is ``!'', it signifies that
no undo marks are to be generated around this command;  the ``!'' is
stripped from the command before executing it.  If several key bindings
in a row are invoked and each had the ``!'' prefix, then all of the
invocations will be undone together as a single unit.
.PP
If \fIcommand\fR isn't specified, then the \fImxBind\fR command returns
the current binding for \fIsequence\fR, or the empty string if there
is no binding for \fIsequence\fR.  If neither \fIsequence\fR or \fIcommand\fR
is given, then \fBmxBind\fR returns a Tcl list whose elements are the
\fIsequence\fRs associated with all known keystroke bindings.
.RE
.TP
\fBmxFeedback msg\fP
This displays a message in the feedback entry.
.TP
\fBmxMenu menu [where]\fP
This procedure creates a menu and adds a menubutton for it.  The
label on the menubutton is \fBmenu\fP, and the button position
is given by \fBwhere\fP, which should be "left" or "right".
This procedure and the related procedures described below use
the text label \fBmenu\fP as its name, as opposed to
using an internal TK widget name.
.TP
\fBmxMenuAdd menu label command\fP
This procedure adds an entry to the menu named \fBmenu\fP
as specified to the \fBmxMenu\fP command.
The menu entry has the label \fBlabel\fP, and is associated
with \fBcommand\fP.  The \fBlabel\fP is used as a key to the
menu entry in the commands below that operate on individual menu entries.
.TP
\fBmxMenuInsert menu index label command\fP
Like \fBmxMenuAdd\fP, except that this puts the entry at a particular
position in the menu as specified by \fBindex\fP.
The \fBindex\fP values count from zero.
.TP
\fBmxMenuAddRadio menu label var value command\fP
This procedure adds a radio-button type entry to the menu named \fBmenu\fP
as specified to the \fBmxMenu\fP command.
The menu entry has the label \fBlabel\fP, and is associated
with \fBcommand\fP.  The \fBlabel\fP is used as a key to the
menu entry in the commands below that operate on individual menu entries.
The \fBvar\fP and \fBvalue\fP arguments specify the TCL variable
associated with a set of radio-button menu entries,
and the value that the variable will be set to when then
entry is invoked.
.TP
\fBmxMenuAddSeparator menu\fP
Add a separator line to \fBmenu\fP.
.TP
\fBmxMenuBind sequence menu label\fR
This procedure is similar to the TK bind command, except that it
associates a keystroke \fBsequence\fP with an entry in \fBmenu\fP
that has a given \fBlabel\fP.  The use of this procedure ensures
that the display of the menu accelerator 
in the menu entry is kept consistent.  Note that \fBlabel\fP
does not include the \fBsequence\fP that is also displayed in the menu entry.
.TP
\fBmxMenuEntryConfigure menu label args\fR
This procedure is a thin layer over the \fBentryconfigure\fP
option to TK menu entries.
.TP
\fBmxMenuUnBind menu label\fR
This removes the current keystroke binding from a menu entry.
It takes care of updating the menu display so it no longer
shows the keystroke sequence.
.TP
\fBshowBindings \fIbinding binding ...\fR
Open a scratch window and display information about keystroke
bindings in it.  If
no \fIbinding\fR argument is given, then display information about all
of the keystroke bindings that are currently defined.
If one or more \fIbinding\fR arguments are given, then
just display information for the given bindings.
Returns an empty string.
.TP
\fBshowProcs \fIname name ...\fR
Open a scratch window and display procedure information in it.  If
no \fIname\fR argument is given, then display information about all
the procedures that are currently defined.
If one or more \fIname\fR arguments are given, then
just display information for the named procedures.
Returns an empty string.
.TP
\fBshowVars \fIname name ...\fR
Open a scratch window and display variable values in it.  If
no \fIname\fR argument is given, then display the values of all
variables known in the context of the caller of \fBshowVars\fR.
If one or more \fIname\fR arguments are given, then
just show the values of those variables. Returns an empty string.
.TP
\fBmxTag \fIname\fR
Invoke the \fBmxTaginfo\fR command to look up \fIname\fR, then switch
to its file, select the definition of \fIname\fR,
and make the selected line visible in the window.
Returns an empty string.
.TP
\fBmxTagOpen \fIname\fR
Invoke the \fBmxTaginfo\fR command to look up \fIname\fR, then open
a new window on its file, select the definition of \fIname\fR,
and make the selected line visible in the new window.
Returns an empty string.

.SH BINDING APPENDIX
.PP
Here is a dump of the default key and mouse bindings.
Note that the mapping from the function Keysyms (e.g., F27)
to what is actually printed on the key may not be
that great.  It may be easier to scan through
the $mxLibrary/mxedit.bindings and $mxLibrary/mxedit.local
files.
.DS
<Key-R13>            => " mxCaretMove [mxMark eof] ; mxSee caret "
<Key-F27>            => " mxCaretMove 1.0 ; mxSee caret "
<Key-F35>            => " mxPageDown "
<Key-F29>            => " mxPageUp "
<Key-F30>            => " mxBack1char "
<Key-F32>            => " mxForw1char "
<Key-Down>           => " mxDown1Line "
<Key-Up>             => " mxUp1Line "
<Key-Help>           => " global mxLibrary ; mxOpen $mxLibrary/mxedit.tutorial "
<Key-F19>            => " mxFind "
<Key-F20>            => " mxDeleteSave "
<Key-F18>            => " mxPaste "
<Key-F16>            => " mxCopySave "
<Key-F14>            => " mxUndo "
<Key-F12>            => " mxHistory ignore mxRedo "
<Any-ButtonRelease-3> => "mxScanDone %W"
<Shift-B3-Motion>    => "mxScanDragto %W %y 10"
<Shift-Button-3>     => "mxScanMark %W %y"
<Shift-B2-Motion>    => "mxScanDragto %W %y 4"
<Shift-Button-2>     => "mxScanMark %W %y"
<Any-ButtonRelease-2> => "mxScanDone %W"
<B2-Motion>          => "mxScanDragto %W %y 1"
<Button-2>           => "mxScanMark %W %y"
<Control-ButtonRelease-3> => "
		mxHistory ignore "mxMouseUp %W ; mxRedoBarrier %W"
	    "
<Control-B3-Motion>  => "
		mxHistory ignore "mxSelAdjust %W @%x,%y"
	    "
<Control-Button-3>   => "
		    mxHistory ignore "mxSelAdjust %W @%x,%y"
		"
<Control-ButtonRelease-1> => "
		mxHistory ignore "mxMouseUp %W ; mxRedoBarrier %W"
	    "
<Control-B1-Motion>  => "
		mxHistory ignore "mxSelMove %W @%x,%y"
	    "
<Triple-Control-Button-1> => "
		mxHistory ignore "mxSelLine %W @%x,%y"
	    "
<Double-Control-Button-1> => "
		mxHistory ignore "mxSelWord %W @%x,%y"
	    "
<Control-Button-1>   => "
		mxHistory ignore "mxSelChar %W @%x,%y"
	    "
<ButtonRelease-3>    => "
		mxHistory ignore "mxMouseUp %W ; mxRedoBarrier %W"
	    "
<B3-Motion>          => "
		mxHistory ignore "mxCaretSelAdjust %W @%x,%y"
	    "
<Button-3>           => "
		    mxHistory ignore "mxCaretSelAdjust %W @%x,%y"
		"
<Shift-ButtonRelease-1> => "
		mxHistory ignore "mxMouseUp %W ; mxRedoBarrier %W"
	    "
<Shift-B1-Motion>    => "
		mxHistory ignore "mxCaretSelAdjust %W @%x,%y"
	    "
<Shift-Button-1>     => "
		    mxHistory ignore "mxCaretSelAdjust %W @%x,%y"
		"
<ButtonRelease-1>    => "
		mxHistory ignore "mxMouseUp %W ; mxRedoBarrier %W ; %W markparen @%x,%y"
	    "
<B1-Motion>          => "
		mxHistory ignore "mxCaretSelMove %W @%x,%y"
	    "
<Triple-Button-1>    => "
		mxHistory ignore "mxCaretSelLine %W @%x,%y"
	    "
<Double-Button-1>    => "
		mxHistory ignore "mxCaretSelWord %W @%x,%y"
	    "
<Button-1>           => "
		mxHistory ignore "mxCaretNoSelChar %W @%x,%y"
	    "
<Control-Shift-Key-question> => " mxCaretInfo "
<Control-Key-c>      => " mxCommandFocus "
<Mod1-Key-e>         => " mxEndOfLine "
<Mod1-Key-n>         => " mxForw1Word "
<Mod1-Key-w>         => " mxBack1Word "
<Mod1-Key-k>         => " mxUp1Line "
<Mod1-Key-Return>    => " mxNextLine "
<Mod1-Key-j>         => " mxDown1Line "
<Mod1-Key-l>         => " mxForw1char "
<Mod1-Key-h>         => " mxBack1char "
<Control-Key-k>      => " mxOpenLineAbove "
<Control-Key-j>      => " mxOpenLineBelow "
<Control-Key-x>      => " mxDeleteLine "
<Control-Key-e>      => " mxDeleteEndOfLine "
<Control-Key-n>      => " mxDeleteForwWord "
<Control-Key-w>      => " mxDeleteBackWord "
<Key-Delete>         => " mxDeleteBackChar "
<Control-Key-h>      => " mxDeleteBackChar "
<Control-Key-l>      => " mxDeleteForwChar "
<Key-Escape><Key-f>  => " mxFindClear "
<Key-Escape><Key-r>  => " mxReplaceClear "
<Mod1-Key-r>         => "mxFindInner replaceSel"
<Control-Key-r>      => "mxFindInner replace"
<Mod1-Key-b>         => "mxFindInner backSel"
<Control-Key-b>      => "mxFindInner backward"
<Mod1-Key-f>         => "mxFindInner forwSel"
<Control-Key-f>      => "mxFindInner forward"
<Mod1-Key-y>         => "mxOutdentSel"
<Mod1-Key-p>         => "mxIndentSel"
<Control-Key-y>      => "mxOutdentLine"
<Control-Key-p>      => "mxIndentLine"
<Mod1-Key-v>         => "mxMoveSel"
<Control-Key-v>      => "mxPaste"
<Key-Escape><Key-d>  => "mxDeleteNoSave"
<Control-Key-d>      => "mxDeleteSave"
<Mod1-Key-c>         => "mxCopySave"
<Control-Key-a>      => "mxHistory ignore mxRedo"
<Control-Key-u>      => "mxUndo"
<Key-Escape><Key-t>  => "
	set _t [mxMark [mxMark caret forw 1 word] back 1 char]
	mxSelection set [mxMark $_t back 1 word] $_t
	mxApplyToSelection mxTagOpen
    "
<Control-Key-g>      => "mxHistory next mxHistory 						{mxApplyToSelection mxLine}"
<Mod1-Key-t>         => "mxApplyToSelection mxTagOpen"
<Control-Key-t>      => "mxApplyToSelection mxTag"
<Key-Escape><Key-s>  => "mxSwitchBack"
<Mod1-Key-s>         => "mxApplyToSelection mxSwitch"
<Mod1-Key-o>         => "mxApplyToSelection mxOpen"
<Control-Key-o>      => "mxOpen $mxFile"
<Control-Key-q>      => "mxQuit"
<Control-Key-s>      => "mxSave"
<Mod1-Key-space>     => " mxExchDotMark "
<Control-Key-space>  => " mxCaretSelChar %W caret ; set mxMarkActive 1 "
<Mod1-Key-m><Key-z>  => "mxSee $mxMarkz; mxCaret $mxMarkz"
<Key-Escape><Key-m><Key-z> => "set mxMarkz [mxMark caret]"
<Mod1-Key-m><Key-y>  => "mxSee $mxMarky; mxCaret $mxMarky"
<Key-Escape><Key-m><Key-y> => "set mxMarky [mxMark caret]"
<Mod1-Key-m><Key-x>  => "mxSee $mxMarkx; mxCaret $mxMarkx"
<Key-Escape><Key-m><Key-x> => "set mxMarkx [mxMark caret]"
<Mod1-Key-m><Key-w>  => "mxSee $mxMarkw; mxCaret $mxMarkw"
<Key-Escape><Key-m><Key-w> => "set mxMarkw [mxMark caret]"
<Mod1-Key-m><Key-v>  => "mxSee $mxMarkv; mxCaret $mxMarkv"
<Key-Escape><Key-m><Key-v> => "set mxMarkv [mxMark caret]"
<Mod1-Key-m><Key-u>  => "mxSee $mxMarku; mxCaret $mxMarku"
<Key-Escape><Key-m><Key-u> => "set mxMarku [mxMark caret]"
<Mod1-Key-m><Key-t>  => "mxSee $mxMarkt; mxCaret $mxMarkt"
<Key-Escape><Key-m><Key-t> => "set mxMarkt [mxMark caret]"
<Mod1-Key-m><Key-s>  => "mxSee $mxMarks; mxCaret $mxMarks"
<Key-Escape><Key-m><Key-s> => "set mxMarks [mxMark caret]"
<Mod1-Key-m><Key-r>  => "mxSee $mxMarkr; mxCaret $mxMarkr"
<Key-Escape><Key-m><Key-r> => "set mxMarkr [mxMark caret]"
<Mod1-Key-m><Key-q>  => "mxSee $mxMarkq; mxCaret $mxMarkq"
<Key-Escape><Key-m><Key-q> => "set mxMarkq [mxMark caret]"
<Mod1-Key-m><Key-p>  => "mxSee $mxMarkp; mxCaret $mxMarkp"
<Key-Escape><Key-m><Key-p> => "set mxMarkp [mxMark caret]"
<Mod1-Key-m><Key-o>  => "mxSee $mxMarko; mxCaret $mxMarko"
<Key-Escape><Key-m><Key-o> => "set mxMarko [mxMark caret]"
<Mod1-Key-m><Key-n>  => "mxSee $mxMarkn; mxCaret $mxMarkn"
<Key-Escape><Key-m><Key-n> => "set mxMarkn [mxMark caret]"
<Mod1-Key-m><Key-m>  => "mxSee $mxMarkm; mxCaret $mxMarkm"
<Key-Escape><Double-Key-m> => ""
<Mod1-Key-m><Key-l>  => "mxSee $mxMarkl; mxCaret $mxMarkl"
<Key-Escape><Key-m><Key-l> => "set mxMarkl [mxMark caret]"
<Mod1-Key-m><Key-k>  => "mxSee $mxMarkk; mxCaret $mxMarkk"
<Key-Escape><Key-m><Key-k> => "set mxMarkk [mxMark caret]"
<Mod1-Key-m><Key-j>  => "mxSee $mxMarkj; mxCaret $mxMarkj"
<Key-Escape><Key-m><Key-j> => "set mxMarkj [mxMark caret]"
<Mod1-Key-m><Key-i>  => "mxSee $mxMarki; mxCaret $mxMarki"
<Key-Escape><Key-m><Key-i> => "set mxMarki [mxMark caret]"
<Mod1-Key-m><Key-h>  => "mxSee $mxMarkh; mxCaret $mxMarkh"
<Key-Escape><Key-m><Key-h> => "set mxMarkh [mxMark caret]"
<Mod1-Key-m><Key-g>  => "mxSee $mxMarkg; mxCaret $mxMarkg"
<Key-Escape><Key-m><Key-g> => "set mxMarkg [mxMark caret]"
<Mod1-Key-m><Key-f>  => "mxSee $mxMarkf; mxCaret $mxMarkf"
<Key-Escape><Key-m><Key-f> => "set mxMarkf [mxMark caret]"
<Mod1-Key-m><Key-e>  => "mxSee $mxMarke; mxCaret $mxMarke"
<Key-Escape><Key-m><Key-e> => "set mxMarke [mxMark caret]"
<Mod1-Key-m><Key-d>  => "mxSee $mxMarkd; mxCaret $mxMarkd"
<Key-Escape><Key-m><Key-d> => "set mxMarkd [mxMark caret]"
<Mod1-Key-m><Key-c>  => "mxSee $mxMarkc; mxCaret $mxMarkc"
<Key-Escape><Key-m><Key-c> => "set mxMarkc [mxMark caret]"
<Mod1-Key-m><Key-b>  => "mxSee $mxMarkb; mxCaret $mxMarkb"
<Key-Escape><Key-m><Key-b> => "set mxMarkb [mxMark caret]"
<Mod1-Key-m><Key-a>  => "mxSee $mxMarka; mxCaret $mxMarka"
<Key-Escape><Key-m><Key-a> => "set mxMarka [mxMark caret]"
<Mod1-Key-m>         => " set _foo "" "
<Key-Escape><Key-m>  => " set _foo "" "
<Lock-Key-BackSpace> => "mxDeleteBackChar"
<Lock-Key-Tab>       => ".mx.edit ! insert %A"
<Lock-Key-Return>    => "mxNewline ; mxSee caret"
<Key-BackSpace>      => "mxDeleteBackChar"
<Key-Tab>            => ".mx.edit ! insert %A"
<Key-Return>         => "mxNewline ; mxSee caret"
<Key-Escape>         => " set _foo """
<Any-Key>            => "%W ! insert %A"
.DE
.SH COMMAND APPENDIX
.PP
As a quick reference here is an extract of the TCL procedures
defined in the mxedit library.  A section is given for
each file in the library.  Consult the source,
e.g., "mxOpen $mxLibrary/mxedit.aliases", for
comments and details of the implementation.
This dump is displayed in a scratch window by the mxDumpProcHeaders command.

.DS
/project/tcl/lib/mxedit2.1/mxedit.aliases
proc mx { args } { eval mxOpen $args }
proc edit { args } 
proc mxu { filename } 
proc mxl { filename } 
proc mxr { filename } 
proc sw { args } 
proc save { args } 
proc quit {} 
proc reset {} 
proc fmt {} 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.bindings
proc mxShowBindings { args } 
proc mxBasicBindings { widget } 
proc mxClearMouseBindings { widget } 
proc mxRestoreMouseBindings { widget } 
proc mxClearKeyBindings { widget } 
proc mxRestoreKeyBindings { widget } 
proc mxScrollButton { widget B {modifier NONE} {speed 1} } 
proc mxScrollBindings { widget } 
proc mxOldScrollBindings { widget } 
proc mxOpenwinScrollBindings { widget } 
proc mxSelectButton { widget B {how Anchor} {modifier NONE} } 
proc mxSelectionBindings { widget } 
proc mxSelectionBindingsOriginal {widget} 
proc mxOpenwinSelectionBindings { widget } 
proc mxMotifSelectionBindings { widget } 
proc mxRightDrag { { widget NONE} } 
proc mxMiddlePaste { { widget NONE} } 
proc mxBindings { widget } 
proc mxKeyBindings { widget } 
proc mxMarkBindings { {widget NONE} } 
proc mxKillBindings { {widget NONE} } 
proc mxEntryBindings {} 
proc mxCommandBindings { entry } 
proc mxSearchBindings { entry } 
proc mxReplaceBindings { entry } 
proc mxBindLatin1 { widget } 
proc mxBindMarks { widget } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.command
proc mxCommandInit {} 
proc mxCommandEntry { parent { width 20 } { where {bottom fillx expand} } } 
proc mxCommandFocus { } 
proc mxCommandMenuEntry { menuName } 
proc mxCommandHide { } 
proc mxCommandShow { } 
proc mxDoCmd { } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.core
proc mxBind { args } 
proc mxCaret { args } 
proc mxCaretMove { mark } 
proc mxClean { args } 
proc mxColumn { args } 
proc mxControl { args } 
proc mxDelete { args } 
proc mxBatchDelete { args } 
proc mxExtract { args } 
proc mxHistory { args } 
proc mxGridsize { args } 
proc mxIndent { args } 
proc mxInsert { bytes args } 
proc mxBatchInsert { bytes args } 
proc mxMark { args } 
proc mxNewline {  } 
proc mxQuote {  } 
proc mxRead { args } 
proc mxReplace { args } 
proc mxSearch { args } 
proc mxSee { args } 
proc mxSelection { args } 
proc mxTaginfo { args } 
proc mxWritten { args } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.dirbrowser
proc DirShowWindow {{directory "-"}} 
proc DirPathWidget   {} { return ".dir.top.path.path" }
proc DirFileWidget   {} { return ".dir.top.file.file" }
proc DirFilterWidget {} { return ".dir.top.filter.filter" }
proc DirListWidget   {} { return ".dir.top.dir.list"  }
proc DirDescribeFile {file} 
proc DirRescan top 
proc DirRename top 
proc DirDeleteFile top 
proc DirOpenFile top 
proc DirInitDirectory {top directory} 
proc DirScanDirectory {top directory pattern} 
proc unlink { filename } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.emacs
proc emacsBindings {} 
proc emacsKeyBindings { {widget NONE} } 
proc emacsCommandBindings { entry } 
proc emacsSearchBindings { entry } 
proc emacsReplaceBindings { entry } 
proc emacsKill { what {kill kill} } 
proc emacsKillReset {} 
proc emacsYank {} 
proc emacsYankPop {} 
proc emacsMarkBindings {} 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.file
proc mxDialog { frame title text {quitlabel "Dismiss"} } 
proc mxUndoErrorDialog { text } 
proc mxUndoErrorNotify { text } 
proc mxRecoveryDialog { text } 
proc mxRecoveryFailedDialog { text } 
proc mxSave { args } 
proc mxSaveSel { } 
proc mxSaveAsInner { top } 
proc mxSaveAs { } 
proc mxSaveInner { filename writeCommand } 
proc mxReset { } 
proc mxResetAlways { } 
proc mxResetDialog { msg } 
proc mxSwitch { filename } 
proc mxSwitchAlways { filename } 
proc mxSwitchBack { } 
proc mxSwitchDialog { msg filename } 
proc mxQuit { } 
proc mxQuitSafe {} 
proc mxQuitDialog { msg } 
proc mxPlacePopUp { widget {where center} } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.global
proc mxKillAppend { text } 
proc mxKillNew { text } 
proc mxKillReset {} 
proc mxYank {} 
proc mxYankPop {} 
proc _mxPushKill {} 
proc _mxCurKill {} 
proc mxGblNewFile { interpName } 
proc mxGblSwitchFile { oldInterp newInterp } 
proc mxGblDeleteFile { interp } 
proc mxGblActivateFile { filename } 
proc mxListBoxHit { y } 
proc mxSendInterpName { remoteInterp cmdPrefix } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.local
proc mxLocalBindings {} 
proc mxSun4Bindings {} 
proc mxR6000Bindings {} 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.menus
proc mxMenuSetup { parent } 
proc mxCreateMenus { } 
proc mxMenu { label {where {left}} } 
proc mxMenuBind { sequence menuName label } 
proc mxMenuUnBind { menuName label } 
proc mxMenuUnBindAll { {menuName _ALL} } 
proc mxMenuAdd { menuName label command } 
proc mxMenuAddRadio { menuName label var value { command  {info library} } } 
proc mxMenuAddSeparator { menuName } 
proc mxMenuEntryConfigure { menuName label args } 
proc mxMenuInsert { menuName index label command } 
proc mxMenuDelete { menuName label } 
proc mxMenuDestroy {label} 
proc mxFileMenu { } 
proc mxEditMenu { } 
proc mxSearchMenu { } 
proc mxWindowMenu { } 
proc mxHelpMenu { } 
proc mxHelp { args } 
proc mxEmacsKeyBindings {} 
proc mxDefaultKeyBindings {} 
proc mxSetMotifMouseBindings {} 
proc mxDefaultMouseBindings {} 
proc mxFontMenu { } 
proc mxGeometryMenu { } 
proc mxUpperRight { } 
proc mxLowerRight { } 
proc mxUpperLeft { } 
proc mxLowerLeft { } 
proc mxFullRight { } 
proc mxFullLeft { } 
proc mxSetupTilingGeometry { charsWide linesHigh right left top bottom } 
proc mxSetupFullGeometry { menuName charsWide linesHigh right left top } 
proc mxExtrasMenu {} 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.mh
proc MhInit {} 
proc MhHelp {} 
proc MhMenuSignatureEntries { menuname } 
proc MhSignature { file } 
proc MhSendIt { rmtcmd } 
proc MhWhatNow {} 
proc MhEditDone {} 
proc MhEditAbort {} 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.search
proc mxSearchInit {} 
proc mxMakeFindTool { parent } 
proc mxPackFindTool {} 
proc mxHideFindTool { } 
proc mxFind { } 
proc mxFindClear { } 
proc mxSearchFocus { } 
proc mxReplaceClear { } 
proc mxReplaceFocus { } 
proc mxShowFind { } 
proc mxHideFind {} 
proc mxFindInner { op }  
proc mxMakePopUp { } 
proc mxHidePopUp {} 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.tcl_ui
proc TclInit {} 
proc tclEvalInner { string } 
proc tclDisplayCommand { string } 
proc tclDisplayResult { result } 
proc tclDisplay { string } 
proc tclEchoReset {} 
proc tclEcho { string } 
proc tclEndsWithNewline { string } 
proc tclListInterps {} 
proc tclSetInterpSel {} 
proc tclSetInterp { interp } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.tk
proc tkerror { msg } 
proc mxInit { font geometry args } 
proc mxSetup { parent filename {geometry 80x20} {font fixed} } 
proc mxCheckSessions { filename } 
proc mxNameWindow { window filename } 
proc mxWindowNameFix { } 
proc mxFeedbackSetup { parent name {width 58} {border 6} } 
proc mxFeedback { text } 
proc mxScroll { parent file feedback geometry font } 
proc mxSetScrollBindingProc { proc } 
proc mxSetSelectBindingProc { proc } 
proc mxChangeMouseBindings { name1 name2 op } 
proc mxChangeKeyBindings { name1 name2 op } 
proc mxEditFocus {} 
proc mxFont { fontname } 
.DE
.DS
/project/tcl/lib/mxedit2.1/mxedit.utils
proc mxUtilsInit {} 
proc mxUndo { } 
proc mxRedo { } 
proc mxDeleteNoSave { } 
proc mxDeleteSave { } 
proc mxCopySave { } 
proc mxDeleteForwChar { } 
proc mxDeleteBackChar { } 
proc mxDeleteBackWord { } 
proc mxDeleteForwWord { } 
proc mxDeleteEndOfLine { } 
proc mxDeleteLine { } 
proc mxMoveSel {  } 
proc mxPaste { } 
proc mxOpenLineBelow { } 
proc mxOpenLineAbove { } 
proc mxIndentLine { } 
proc mxOutdentLine { } 
proc mxIndentSel { } 
proc mxOutdentSel { } 
proc mxBack1char { } 
proc mxForw1char { } 
proc mxBack1Word { } 
proc mxForw1Word { } 
proc mxNextLine {}  
proc mxDown1Line { } 
proc mxUp1Line { } 
proc mxBeginOfLine { } 
proc mxEndOfLine { } 
proc mxPageUp { } 
proc mxPageDown { } 
proc mxApplyToSelection { prefix } 
proc mxRedoBarrier { widget } 
proc mxMouseUp { widget } 
proc mxCaretNoSelChar { widget mark } 
proc mxCaretSelChar { widget mark } 
proc mxCaretSelWord { widget mark } 
proc mxCaretSelLine { widget mark } 
proc mxCaretSelMove { widget mark } 
proc mxCaretSelAdjust { widget mark } 
proc mxSelChar { widget mark } 
proc mxSelMove { widget mark } 
proc mxSelWord { widget mark } 
proc mxSelLine { widget mark } 
proc mxSelAdjust { widget mark } 
proc mxScanMark { widget y } 
proc mxScanDragto { widget y {speed 1} } 
proc mxScanDone { widget } 
proc mxSizeChangeCallback { } 
proc mxStateChangeCallback { } 
proc mxAbbrev { abbrev args } 
proc mxInsertWords { args } 
proc mxLastCommand { {back 0} } 
proc mxGeometry { { xGeometry none } } 
proc screenwidth {} 
proc screenheight {} 
proc mxLine { { i _no_i_ } } 
proc mxTag { name } 
proc mxTagOpen { name } 
proc mxCaretInfo { } 
proc mxShellSel { args } 
proc mxIncrSel { pattern } 
proc mxHideGlobalWindow {} 
proc mxShowGlobalWindow {} 
proc mxExchDotMark {} 
proc mxShowDbUser {} 
proc mxShowProcs {args} 
proc mxShowVars {args} 
proc mxShowHistory { {when current} } 
proc mxShowKillBuffers { } 
proc mxDumpProcHeaders { args } 
.DE

.SH KEYWORDS
editor, X, Tcl, Tk
