/*
 * mxGlobal.c --
 *	A global (per-process) interpreter and associated info window
 *	are used as a shared context among windows.
 *
 * Copyright (c) 1993 Xerox Corporation.
 * Use and copying of this software and preparation of derivative works based
 * upon this software are permitted. Any distribution of this software or
 * derivative works must comply with all applicable United States export
 * control laws. This software is made available AS IS, and Xerox Corporation
 * makes no warranty about the software, its performance or its conformity to
 * any specification.
 */

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "tk.h"
#include "mxWidget.h"

static void DelayedMap _ANSI_ARGS_((ClientData clientData));;
char *MxEnvironmentSetup();

/*
 * MxGlobalEval --
 *	Evaluate an expression in the global interpreter.
 */
int
MxGlobalEval(clientData, interp, argc, argv)
    ClientData clientData;		/* process global interpreter */
    Tcl_Interp *interp;			/* Per-window interpreter */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    Tcl_Interp *gblInterp = (Tcl_Interp *)clientData;
    char *cmd;
    int status;

    cmd = Tcl_Merge(argc-1, argv+1);	/* Skip "mxGlobalEval" */
    status = Tcl_Eval(gblInterp, cmd);
    Tcl_SetResult(interp, gblInterp->result, TCL_VOLATILE);
    free(cmd);
    return status;
}

/*
 * MxGlobalWindow --
 *	Create a per-process info window.
 */
Tk_Window
MxGlobalWindow(interp, argc, argv)
    Tcl_Interp *interp;
    int argc;
    char *argv[];
{
    Tk_Window tkwin;
    char *display = NULL;
    char *globalCmd = NULL;
    char *libDir = MX_LIBRARY;
    int nowin = 0;
    char *args;
    struct stat statBuf;
    char buf[256];
    int i;
    extern int MxOpenCmd();

    for (i=0 ; i<argc ; i++) {
	if (strcmp(argv[i], "-display") == 0) {
	    display = argv[i+1];
	}
	if (strcmp(argv[i], "-libDir") == 0) {
	    libDir = argv[i+1];
	}
	if (strcmp(argv[i], "-globalCmd") == 0) {
	    globalCmd = argv[i+1];
	}
	if (strcmp(argv[i], "-nowin") == 0) {
	    nowin = 1;
	}
    }
    tkwin = Tk_CreateMainWindow(interp, display, "mxedit", "Mxedit");
    if (tkwin == NULL) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }
    args = MxEnvironmentSetup(tkwin, interp, libDir, argc, argv);
    Tcl_SetVar(interp, "mxVersion", MX_VERSION, TCL_GLOBAL_ONLY);

    /*
     * Create the mxOpen command so the global interp can field
     * requests to open files.
     */
    Tcl_CreateCommand(interp, "mxOpen", MxOpenCmd, (ClientData) interp,
	    (void (*)()) NULL);

    /*
     * Call out to the script-level to initialize the window
     * with all of its widgets.
     *
     * buf is used so that Tcl_Eval won't try to scribble on
     * a constant string.
     */
    strcpy(buf, "source $mxLibrary/global.tcl");
    if (Tcl_Eval(interp, buf) != TCL_OK) {
	    fprintf(stderr, "Global script \"%s\" failed: %s\n",
		    "$mxLibrary/global.tcl", interp->result);
	    fprintf(stderr, "**** TCL trace ****\n");
	    fprintf(stderr, "%s\n", Tcl_GetVar(interp, "errorInfo",
		TCL_GLOBAL_ONLY));
    }

    /*
     * Run the user-supplied command, which is most often
     * used to hook the mxedit back up to another interpreter.
     */
    if (globalCmd != NULL) {
	if (Tcl_Eval(interp, globalCmd) != TCL_OK) {
	    fprintf(stderr, "globalCmd \"%s\" failed: %s\n",
		    globalCmd, interp->result);
	    fprintf(stderr, "**** TCL trace ****\n");
	    fprintf(stderr, "%s\n", Tcl_GetVar(interp, "errorInfo",
		TCL_GLOBAL_ONLY));
	}
    }
    ckfree(args);
    if (!nowin) {
	/*
	 * Allow users to suppress the global window.
	 */
	Tk_DoWhenIdle(DelayedMap, (ClientData) tkwin);
    }
    return tkwin;
}
/*
 *----------------------------------------------------------------------
 *
 * DelayedMap --
 *
 *	This procedure is invoked by the event dispatcher once the
 *	startup script has been processed.  It waits for all other
 *	pending idle handlers to be processed (so that all the
 *	geometry information will be correct), then maps the
 *	application's main window.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The main window gets mapped.
 *
 *----------------------------------------------------------------------
 */

	/* ARGSUSED */
static void
DelayedMap(clientData)
    ClientData clientData;
{
    Tk_Window w = (Tk_Window)clientData;
    while (Tk_DoOneEvent(TK_IDLE_EVENTS) != 0) {
	/* Empty loop body. */
    }
    if (w == NULL) {
	return;
    }
    Tk_MapWindow(w);
}

/*
 * MxDestroyGlobalWindow --
 */
void
MxDestroyGlobalWindow(tkwin)
    Tk_Window tkwin;
{
    Tk_DestroyWindow(tkwin);
}
