#
# mxedit.global --
#	Support for state in the global interpreter.
#	A small window is created, plus state is maintained
#	for a stack of kill buffers (a la emacs).

########################### Kill Stack Support #############################

# mxKillAppend --
#	Append to the current kill buffer
#
proc mxKillAppend { text } {
    global mxKillBuf
    set top [_mxCurKill]
    append mxKillBuf($top) $text
}

# mxKillNew --
#	Push a new kill buffer
#
proc mxKillNew { text } {
    global mxKillBuf
    set top [_mxPushKill]
    set mxKillBuf($top) $text
}

# mxKillReset --
#	Reset the kill buffer stack
#
proc mxKillReset {} {
    global mxKillTop mxKillBuf
    set mxKillTop 0
    set mxKillBuf($mxKillTop) {}
}

# mxYank --
#	Return the top kill buffer
#
proc mxYank {} {
    global mxKillTop mxKillBuf
    if ![info exists mxKillTop] {
	return {}
    }
    return $mxKillBuf($mxKillTop)
}

# mxYankPop --
#	Pop the top of the kill buffer stack
#
proc mxYankPop {} {
    global mxKillTop mxKillBuf
    if ![info exists mxKillTop] {
	return
    }
    set mxKillBuf($mxKillTop) {}
    if {$mxKillTop > 0} {
	incr mxKillTop -1
    }
}

# _mxPushKill --
#	Push the stack pointer
#
proc _mxPushKill {} {
    global mxKillTop
    if ![info exists mxKillTop] {
	set mxKillTop 0
    } else {
	incr mxKillTop
    }
    return $mxKillTop
}

# _mxCurKill --
#	Return the current stack pointer
#
proc _mxCurKill {} {
    global mxKillTop
    if ![info exists mxKillTop] {
	set mxKillTop 0
    }
    return $mxKillTop
}
########################### Buffer list support ############################

# mxGblNewFile --
#	Add to the registry of files being edited by this process
#
proc mxGblNewFile { interpName } {
    global mxListBox
    $mxListBox insert end [lrange $interpName 1 end]
}

# mxGblSwitchFile --
#	Switch the registry of a file being edited by this process
#
proc mxGblSwitchFile { oldInterp newInterp } {
    global mxListBox

    set oldInterp [lrange $oldInterp 1 end]	;# Drop "mxedit"
    set newInterp [lrange $newInterp 1 end]
    set end [$mxListBox size]
    for {set i 0} {$i < $end} {incr i} {
	if {[string compare $oldInterp [$mxListBox get $i]] == 0} {
	    $mxListBox delete $i
	    $mxListBox insert $i $newInterp
	    break
	}
    }
}

# mxGblDeleteFile --
#	Delete a registry of a file.
#
proc mxGblDeleteFile { interp } {
    global mxListBox
    set interp [lrange $interp 1 end]
    set end [$mxListBox size]
    for {set i 0} {$i < $end} {incr i} {
	if {[string compare $interp [$mxListBox get $i]] == 0} {
	    $mxListBox delete $i
	    break
	}
    }
}

# mxGblActivateFile --
#	Open/raise the file window
#
proc mxGblActivateFile { filename } {
    set interp "mxedit $filename"
    send $interp {wm iconify .}
    send $interp {update ; after 500 wm deiconify .}
}

# mxListBoxHit --
#	Field a hit on the list box
#
proc mxListBoxHit { y } {
    global mxListBox
    set filename [$mxListBox get [$mxListBox nearest $y]]
    mxGblActivateFile $filename
}

########################### Send support ##############################

# mxSendInterpName --
#	This is designed to invoked as the global startup command
#	in order to communicate the interpreter name of the
#	process global interpreter back to the application that
#	execs mxedit.  For example:
#
#	set cmd [list mxSendInterpName [winfo name .] EditorIdent]
#	exec $Editor -globalCmd $cmd $draft &

proc mxSendInterpName { remoteInterp cmdPrefix } {
    set cmd [concat $cmdPrefix [list [winfo name .]]]
    send $remoteInterp $cmd
}

########################### Window setup ##############################

# Set things up for autoloading a bunch of utility procs
source [info library]/init.tcl
source $tk_library/tk.tcl
set auto_path "$mxLibrary $auto_path"

# Source the users initialization file so they can
# set controlling global variables and define hook procedures.
if [file exists ~/.mxedit] {
    catch {source ~/.mxedit}
}

utilsInit
colorsInit

wm minsize . 100 100

set msgText "
Mxedit version $mxVersion

Send bugs and comments to Brent Welch
welch@parc.xerox.com

(Suppress this window by setting
 mxNoGlobalWindow in your ~/.mxedit)
"
if [catch {message .title -justify center -background $paleBackground -text $msgText}] {
    message .title -justify center -background $paleBackground -text $msgText -font fixed
}
pack append . .title top

labeledListbox . .filelist "File List" 20x5 {top fill expand}
set mxListBox .filelist.list
bind $mxListBox <Double-1> {mxListBoxHit %y}

if [info exists mxNoGlobalWindow] {
    if {$mxNoGlobalWindow} {
	wm withdraw .
	return
    }
}

after 10000 {wm iconify .}
