#
# mxedit.alaises
#	Short aliases for commonly used commands.
#	All the mxedit TCL commands have the form mxFooBar,
#	e.g., mxOpen, mxSwitch, mxSave, etc.
#	This file contains a bunch of procs that violate this
#	naming convention by defining short aliases
#	Be careful about commands line "open" and "read",
#	which are already low-level TCL commands that do file operations.
#

# Variations on mxOpen

proc mx { args } { eval mxOpen $args }

# Provide an alias for mxOpen
proc edit { args } {
    mxFeedback "Edit $args"
    eval mxOpen $args
}

proc mxu { filename } {
    global newWindow
    set newWindow [mxOpen  $filename]
    send $newWindow "after 500 mxUpperLeft"
}
proc mxl { filename } {
    global newWindow
    set newWindow [mxOpen  $filename]
    send $newWindow "after 500 mxLowerLeft"
}
proc mxr { filename } {
    global newWindow
    set newWindow [mxOpen  $filename]
    send $newWindow "after 500 mxLowerRight"
}

# Save and Switch

proc sw { args } {
    if {[llength $args]>0} {
	eval mxSwitch $args
    } else {
	mxSwitchBack
    }
}

proc save { args } {
    eval mxSave $args
}

proc quit {} {
    mxQuit
}

proc reset {} {
    mxReset
}

# Apply the fmt command to the selection

proc fmt {} {
    mxShellSel fmt
}
