#---------dv---------Menue zur Layout (Preface) Einstellung------------------

#----------------------------------------------------------------------------
# diagtitlemenu {}     erzeugt Eingabezeile (Eingabeaufforderung und
#                      Eingabefeld)  fuer Diagrammtitel Untertitel, X- und
#                      Y-Achsenbezeichnung
#                      path : pfad, in den die Eingabezeile eingehaengt wird 
#                      dp   : pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc diagtitlemenu {path dp} {

   # erzeuge Kontainerwidget fuer das Titlemenu
   #
   frame $path.frame
   pack $path.frame -padx 5 -pady 5 

      # erzeuge Kontainerwidget fuer Eingabeaufforderungen 
      #  
      frame $path.frame.request
      pack $path.frame.request -side left
     
        # erzeuge label fuer Titeleingabeaufforderung
        #
        label $path.frame.request.title -text Title:
        pack $path.frame.request.title -anchor w
     
        # erzeuge label fuer Untertiteleingabeaufforderung
        #
        label $path.frame.request.subtitle -text Subtitle:
        pack $path.frame.request.subtitle -anchor w

        # erzeuge label fuer Eingabeaufforderung der X-Achsenbezeichnung
        # 
        label $path.frame.request.labelx -text LabelX:
        pack $path.frame.request.labelx -anchor w
     
        # erzeuge label fuer Eingabeaufforderung der Y-Achsenbezeichnung
        #
        label $path.frame.request.labely -text LabelY:
        pack $path.frame.request.labely -anchor w
   
     # erzeuge Kontainerwidget fuer Eingabefelder
     #
     frame $path.frame.input
     pack $path.frame.input -side left 
     
       # erzeuge Entry fuer Titeleingabe
       #
       entry $path.frame.input.title -text status($dp.titlebuffer) \
             -width 35 -relief sunken
       pack $path.frame.input.title -anchor w 

       # erzeuge Entry fuer Untertiteleingabe
       #
       entry $path.frame.input.subtitle -text status($dp.subtitlebuffer) \
             -width 35 -relief sunken
       pack $path.frame.input.subtitle -anchor w
   
       # erzeuge Entry fuer Achsenbezeichnugseingabe
       #
       entry $path.frame.input.axisx -text status($dp.labelxbuffer) \
             -width 35 -relief sunken
       pack $path.frame.input.axisx -anchor w 
   
       # erzeuge Entry fuer Achsenbezeichnugseingabe
       #
       entry $path.frame.input.axisy -text status($dp.labelybuffer) \
             -width 35 -relief sunken
       pack $path.frame.input.axisy -anchor w 
}

#-----------------------------------------------------------------------------
# diagxvaluesmenu {}  erzeugt Eingabezeile (Eingabeaufforderungen und
#                     Eingabefelder) fuer Skalierungswerte der xachse
#                     path : pfad, in den die Eingabezeile eingehaengt wird
#                     dp  : pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagxvaluesmenu {path dp} {

  #erzeuge Kontainerwidget fuer die Eingabezeile
  #
  frame $path.scalex 
  pack $path.scalex -padx 10
 
    #erzeuge Eingbeaufforderung und Eingabefeld fuer fromX  
    #
    label $path.scalex.fromxrequest  -text fromX
    pack $path.scalex.fromxrequest -side left
    entry $path.scalex.fromxinput -text status($dp.fromxbuffer) -width 10 \
                                  -relief sunken
    pack $path.scalex.fromxinput -side left
 
    #erzeuge Eingabeaufforderung und Eingabefeld fuer toX 
    #
    label $path.scalex.toxrequest -text toX
    pack $path.scalex.toxrequest -side left
    entry $path.scalex.toxinput -text status($dp.toxbuffer) -width 10 \
				-relief sunken
    pack $path.scalex.toxinput -side left
 
    #erzeuge Eingabeaufforderung und Eingabefeld fuer stepX 
    #
    label $path.scalex.stepxrequest -text stepX
    pack $path.scalex.stepxrequest -side left
    entry $path.scalex.stepxinput -text status($dp.stepxbuffer) -width 10 \
				  -relief sunken
    pack $path.scalex.stepxinput -side left
}
  
#-----------------------------------------------------------------------------
# diagyvaluesmenu {} erzeugt Eingabezeile (Eingabeaufforderungen und
#                Eingabefelder) fuer Skalierungswerte der yachse
#                path: pfad, in den die Eingabezeile eingehaengt wird
#                dp  : pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagyvaluesmenu {path dp} {

  #erzeuge Kontainerwidget fuer die Eingabezeile
  #
  frame $path.scaley
  pack $path.scaley -padx 10
 
    #erzeuge Eingbeaufforderung und Eingabefeld fuer fromY
    #
    label $path.scaley.fromyrequest  -text fromY
    pack $path.scaley.fromyrequest -side left
    entry $path.scaley.fromyinput -text status($dp.fromybuffer) -width 10 \
				  -relief sunken 
    pack $path.scaley.fromyinput -side left
 
    #erzeuge Eingabeaufforderung und Eingabefeld fuer toY
    #
    label $path.scaley.toyrequest -text toY
    pack $path.scaley.toyrequest -side left
    entry $path.scaley.toyinput -text status($dp.toybuffer) -width 10 \
				-relief sunken 
    pack $path.scaley.toyinput -side left
 
    #erzeuge Eingabeaufforderung und Eingabefeld fuer stepY
    #
    label $path.scaley.stepyrequest -text stepY
    pack $path.scaley.stepyrequest -side left
    entry $path.scaley.stepyinput -text status($dp.stepybuffer) -width 10 \
				  -relief sunken
    pack $path.scaley.stepyinput -side left
}

             
#----------------------------------------------------------------------------
# --- zur Zeit unbenutzt
# diagscxcolstate {} aktiviert/deaktiviert den Eingabeknopf fuer die Auswahl
#                 einer Spalte zur Skalierung der xAchse je nach Zustand der 
#                 globalen Variablen diagdata($dp.scxcolbuffer)
#                 path : Pfad, in den der Button eingehaengt wurde
#                 dp   : Pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc diagscxcolstate {path dp} {

  # Statusvariablen sichtbar machen
  # 
  global status

  if {$status($dp.scxcolbuffer) == "on"} {
     
      # Option "Skalierung aus Spalte" ist eingeschaltet =>
      # Knopfzustand und Rahmen entsprechend setzen
      #
      set state normal 
      set relief raised
  } {
     # Option "Skalierung aus Spalte" ist ausgeschaltet =>
     # Status auf "on"; Knopfzustand und Rahmen entsprechend setzen
     #
     set state disabled
     set relief ridge
  }
  # Status und Rahmen setzen
  #
  $path.colx.choose config -state $state -relief $relief
}   

#-----------------------------------------------------------------------------
# diagscxcolmenu {} erzeugt Menuezeile (Checkbutton und Pushbutton)
#                   fuer die Eingabe der Option "Skalierung der Xachse
#                   aus Spalte"
#                   path : Pfad, in den die Eingabezeile eingehaengt wird
#                   dp   : Pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagscxcolmenu {path dp} {

  # Diagrammvariablen und Statusvariablen sichtbar machen
  #
  global diagdata status 

  #erzeuge Kontainerwidget fuer die Eingabezeile
  #
  frame $path.colx -border 0
  pack $path.colx -padx 10 -fill x

    #erzeuge Checkbutton fuer Option Ein/Aus
    #
    checkbutton $path.colx.switch \
                -text "ScalesX from Column #$status($dp.scxcolindbuffer)" \
                -variable status($dp.scxcolbuffer) \
                -onvalue "on" -offvalue "off"

    pack $path.colx.switch -side left -expand true -fill x

    #erzeuge Button fuer Aktivierung des Auswahlmenues
    #
    button $path.colx.choose -text "Choose Column..." \
           -command "diagscxchoosemenu $path $dp {Choose Column for ScalesX} \
                     \"diagscxcolget $path $dp\""
                      
    pack $path.colx.choose -expand true -fill x

    # erzeuge Refreshroutine fuer Checkbutton/Pushbutton
    #
    proc $path.colx.refresh {path dp} {

         # Diagrammvariablen sichtbar machen
         #
         global diagdata 

         # status fuer Checkbutton/Pushbutton setzen
         #
         $path.switch configure -state $diagdata($dp.scxstate)
         $path.choose configure -state $diagdata($dp.scxstate)
    }
    # status durch Refreshaufruf setzen
    #
    $path.colx.refresh $path.colx $dp 
}
 
#----------------------------------------------------------------------------
# diagscalestate {} aktiviert/deaktiviert die Eingabemenues diagxvaluesmenu
#                 und diagyvaluesmenu je nach Zuatand der globalen Variablen
#                 diagdata($dp.autoscalebuffer)
#                 pfad : pfad, in den das diagscalmenu eingehaengt wurde
#                 dp   : pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc diagscalestate {path dp} {

  # Diagrammvariablen und Statusvariablen sichtbar machen 
  #
  global diagdata status

  # ermittle Pfad des layoutmenues (vorherige Ebene im Widgetbaum)
  #
  set layoutpath [cutpath $path]

  if {$status($dp.autoscalebuffer) == "on"} {
     #autoscale ist eingeschaltet => manuelle Eingabefelder deaktivieren
     #
     set state disabled 
     set relief ridge

     # Setze autoscalewerte
     #
     set auto [eval $diagdata($dp.calcautoscale) $dp]
     foreach i {fromxbuffer toxbuffer stepxbuffer\
                fromybuffer toybuffer stepybuffer} {
                set status($dp.$i) [lindex $auto 0]
                lvarpop auto
     }

     set foc [focus]
     if {$foc != "none"} {
        set top [winfo toplevel [focus]]
        if {$top == $layoutpath} {
           # Focus ist im Layout-Toplevel =>
           # Focus auf Titeleingabefenster
           #
           focus $layoutpath.frame.input.title
        }
     }
  } {
     #autoscale ist ausgeschaltet => manuelle Eingabefelder aktivieren
     #
     set state normal 
     set relief sunken 
  }

  # setze status in die Eingabefelder des SkalierungsMenues
  #
  foreach i {scalex.fromxinput scalex.toxinput scalex.stepxinput \
	     scaley.fromyinput scaley.toyinput scaley.stepyinput} {

      #setze je nach dem Zustand von autoscalebuffer Status und Rahmen 
      #
      $path.$i configure -state $state -relief $relief
  }

  # neue Return Bindungen realisieren
  #
  lvarcat list [findentries $layoutpath] $layoutpath 
  bindreturn $list "$layoutpath.switch.ok invoke"
}

#----------------------------------------------------------------------------
# diagscalemenu {} erzeugt Menue zur Skalierungseinstellung
#               path : Pfad, in den das Menue eingehaengt wird
#               dp   : pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc diagscalemenu {path dp} {
   
   #erzeuge Kontainerwidget fuer die Skalierungseinstellungen
   #
   frame $path.diagscale -relief raised -bd 1
   pack $path.diagscale -pady 10 -ipady 5 

     #erzeuge Skalierungsmenue-Ueberschrift
     #
     label $path.diagscale.heading -text "Scale Options"
     pack $path.diagscale.heading 

     #erzeuge checkbutton fuer auto-scale-option
     #
     checkbutton $path.diagscale.autoscale -text "Autoscale" \
		 -command "diagscalestate $path.diagscale $dp" \
		 -variable status($dp.autoscalebuffer) \
		 -onvalue on -offvalue off
     pack $path.diagscale.autoscale -fill x -padx 10

     #erzeuge Zeile fuer Skale-aus-Spalte Option   
     #
     diagscxcolmenu $path.diagscale $dp

     #erzeuge Skalierungswert-Eingabezeilen des Menues
     #
     diagxvaluesmenu $path.diagscale $dp
     diagyvaluesmenu $path.diagscale $dp

     # erzeuge Refresh Prozedur fuer Eingabefelder---------------------------
     #
     proc $path.diagscale.refresh {path dp} {

        # Status der Eingabefelder gemaess autoscale setzen 
        #
        diagscalestate $path $dp
     }
} 

#-----------------------------------------------------------------------------
# diagmiscmenu {} erzeugt Menue fuer Einstellung der Kurvenfarbe, Grid ein/aus
#                 und undefinierte Marken ein/aus 
#              path : Pfad, in dem das Menue eingehaengt wird
#              dp   : pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagmiscmenu {path dp} {

  # erzeuge Kontainerwidget fuer Einstellknoepfe 
  #
  frame $path.misc -relief raised -bd 1
  pack $path.misc -side left -expand true -ipady 5 -ipadx 10

    # erzeuge Ueberschrift fuer Representations-Menue
    #
    label $path.misc.heading -text "Miscellous"
    pack $path.misc.heading

    # erzeuge Frame fuer Knoepfe
    #
    frame $path.misc.frame -border 0
    pack $path.misc.frame

       # erzeuge Knoepf zum oeffnen der ColorSelectbox
       #
       button $path.misc.frame.color -text "Colors..."\
                  -width 10\
                  -command "busy {diagchoosecolors $path.choosecolors $dp}" 
       pack $path.misc.frame.color -fill x

       # erzeuge Checkbutton fuer Grid ein/aus - Option
       # 
       checkbutton $path.misc.frame.grid -text "Show Grid" -anchor w\
                   -width 10 -variable status($dp.gridbuffer) -onvalue on\
                   -offvalue off
       pack $path.misc.frame.grid -anchor w

       # erzeuge Checkbutton fuer "zeige Undefinierte Marken ein/aus" 
       #
       checkbutton $path.misc.frame.undefmarks -text "Mark undef"\
                   -anchor w -width 10 -variable status($dp.undefmarksbuffer)\
                   -onvalue on -offvalue off 
       pack $path.misc.frame.undefmarks -anchor w
}

#----------------------------------------------------------------------------
# diagsizemenu {} erzeugt Menue zur Diagrammgroesseneinstellung
#               path : Pfad, in den das Menue eingehaengt wird
#               dp   : pfad des zugehoerigen Diagramms
#---------------------------------------------------------------------------- 
#
proc diagsizemenu {path dp} {

  # erzeuge Kontainerwidget fuer Diagrammgroesseneinstellungsmenue
  #
  frame $path.size -relief raised -bd 1
  pack $path.size -side left -expand true -ipadx 10 -ipady 5

    # erzeuge Ueberschrift Groesseneinstellungen
    #
    label $path.size.heading -text "Diagram Size"
    pack $path.size.heading

    # erzeuge Einstellknoepfe fuer Groesseneinstellungen
    #
    radiobutton $path.size.normal -text "Normal" -width 10 -anchor w \
                -variable status($dp.sizebuffer) -value normal \
                -command "set status($dp.sizexbuffer) 500; \
                          set status($dp.sizeybuffer) 500; \
                          catch {refreshwindows $dp $path.othersize}"
    pack $path.size.normal

    radiobutton $path.size.big -text "Big" -width 10 -anchor w \
                -variable status($dp.sizebuffer) -value big \
                -command "set status($dp.sizexbuffer) 850; \
                          set status($dp.sizeybuffer) 850;\
                          catch {refreshwindows $dp $path.othersize}"

    pack $path.size.big 
     
    radiobutton $path.size.other -text "Other..." -width 10 -anchor w \
                -variable status($dp.sizebuffer) -value other \
                -command "diagothersizemenu $path $dp" 
    pack $path.size.other 

    # definiere Refreshproc
    #
    proc $path.size.refresh {path dp} {

     # Statusvariablen sichtbar machen
     #
     global status 

     if {$status($dp.sizexbuffer) == 500 && \
          $status($dp.sizeybuffer) == 500} {
          # Groesse entspricht Einstellung "normal" =>
          # Radiobutton "normal" einschalten 
          #
          set status($dp.sizebuffer) normal
     }  elseif {
         $status($dp.sizexbuffer) == 850 && \
          $status($dp.sizeybuffer) == 850 } {
          # Groesse entspricht Einstellung "big" =>
          # Radiobutton "big" einschalten
          # 
          set status($dp.sizebuffer) big
     } {
          # keine Standartgroesse gewaehlt =>
          # Radiobutton "other..." einschalten
          #
          set status($dp.sizebuffer) other
     } 
  } ; # Refreshprozedur

  # Zum initialisieren Refreshprozedur einmal aufrufen
  #
  $path.size.refresh $path.size $dp
}   

#-----------------------------------------------------------------------------
# diagrepmenu {} erzeugt Menue zur Einstellung der Representationsart
#              path : Pfad, in dem das Menue eingehaengt wird
#              dp   : pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagrepmenu {path dp} {

  #erzeuge Kontainerwidget fuer Representationsartenmenue
  #
  frame $path.diagrep -relief raised -bd 1
  pack $path.diagrep -side left -expand true -ipadx 10 -ipady 5 \
       -padx 5

    #erzeuge Ueberschrift fuer Representations-Menue
    #
    label $path.diagrep.heading -text "Representation"
    pack $path.diagrep.heading

    #erzeuge Einstellknoepfe fuer Darstellungsarten
    #
    checkbutton $path.diagrep.standard -text "Points" -anchor w \
                -width 10 -variable status($dp.pointsbuffer) -onvalue on \
                -offvalue off
    pack $path.diagrep.standard 
 
    checkbutton $path.diagrep.polygon -text "Polygon" -anchor w \
                -width 10 -variable status($dp.polygonbuffer) -onvalue on \
                -offvalue off 
    pack $path.diagrep.polygon
 
    checkbutton $path.diagrep.bspline -text "Bspline" -anchor w \
                -width 10 -variable status($dp.bsplinebuffer) -onvalue on \
                -offvalue off 
    pack $path.diagrep.bspline 
}

#-----------------------------------------------------------------------------
# nodoubleerr {}  gibt Fehlermeldung "nodouble" in Dialogbox aus 
#                 var : Inhalt wird vor Fehlermeldung geschrieben
#-----------------------------------------------------------------------------
#
proc nodoubleerr {var} {
  error "\"$var\" is not a number" 
}                    

#----------------------------------------------------------------------------
# nointerr {} gibt Fehlermeldung "noint" in dialogbox aus
#              var : Inhalt wird vor Fehlermeldung geschrieben
#----------------------------------------------------------------------------
#
proc nointerr {var} {
  error "\"$var\" is not an integer number"
}

#----------------------------------------------------------------------------
# nodateerr {} gibt Fehlermeldung "nodate" in Dialogbox aus
#              var : Inhalt wird vor Fehlermeldung geschrieben
#----------------------------------------------------------------------------
#
proc nodateerr {var} {
  error "\"$var\" is not a valid date. Must be \"YYMMDD\"."
}

#----------------------------------------------------------------------------
# notimeerr {} gibt Fehlermeldung "nodate" in Dialogbox aus
#              var : Inhalt wird vor Fehlermeldung geschrieben
#----------------------------------------------------------------------------
#
proc notimeerr {var} {
  error "\"$var\" is not a valid time. Must be \"HHMM\"."
}

#----------------------------------------------------------------------------
# testinteger {} testet, ob die Eingabezeile fromx,tox,stepx nur integer
#                Werte enthaelt und gibt entsprechende Fehlermeldungen aus
#                path : Pfad auf das Layout (Preface) Menue
#                dp   : Pfad des aktuellen Diagramms
#---------------------------------------------------------------------------
#
proc testinteger {path dp} {

  # Statusvariablen sichtbar machen 
  # 
  global status

  # testen und entsprechende Fehlermeldung ausgeben
  #
  if {![isint $status($dp.fromxbuffer)]} {
        focus $path.diagscale.scalex.fromxinput
        nointerr $status($dp.fromxbuffer)
        return
  }
  if {![isint $status($dp.toxbuffer)]} {
        focus $path.diagscale.scalex.toxinput
        nointerr $status($dp.toxbuffer)
        return
  }
  if {![isint $status($dp.stepxbuffer)]} {
       focus $path.diagscale.scalex.stepxinput
       nointerr $status($dp.stepxbuffer)
       return
  }
}
  
#----------------------------------------------------------------------------
# testreal {} testet, ob die Eingabezeile fromx,tox,stepx nur reelle 
#                Werte enthaelt und gibt entsprechende Fehlermeldungen aus
#                path : Pfad auf das Layout (Preface) Menue
#                dp   : Pfad des aktuellen Diagramms
#---------------------------------------------------------------------------
#
proc testreal {path dp} {
 
  # Statusvarablen sichtbar machen
  #
  global status
 
  # testen und entsprechende Fehlermeldung ausgeben
  #
  if {![isdouble $status($dp.fromxbuffer)]} {
        focus $path.diagscale.scalex.fromxinput
        nodoubleerr $status($dp.fromxbuffer)
        return
  }
  if {![isdouble $status($dp.toxbuffer)]} {
        focus $path.diagscale.scalex.toxinput
        nodoubleerr $status($dp.toxbuffer)
        return
  }
  if {![isdouble $status($dp.stepxbuffer)]} {
       focus $path.diagscale.scalex.stepxinput
       nodoubleerr $status($dp.stepxbuffer)
       return
  }
}

#-----------------------------------------------------------------------------
# testdate {} testet, ob die Eingabezeile fromx,tox,stepx nur Datumsangaben
#             der Form "YYMMDD" enthaelt und gibt entsprechende Fehlermeldungen
#             aus 
#             path : Pfad auf das Layout (Preface) Menue
#             dp   : Pfad des aktuellen Diagramms
#----------------------------------------------------------------------------
#
proc testdate {path dp} {
 
  # Statusvarablen sichtbar machen
  #
  global status
 
  # testen und entsprechende Fehlermeldung ausgeben
  #
  if {![getdate $status($dp.fromxbuffer) dummy]} {
        focus $path.diagscale.scalex.fromxinput
        nodateerr $status($dp.fromxbuffer)
        return
  }
  if {![getdate $status($dp.toxbuffer) dummy]} {
        focus $path.diagscale.scalex.toxinput
        nodateerr $status($dp.toxbuffer)
        return
  }
  if {![getdate $status($dp.stepxbuffer) dummy]} {
       focus $path.diagscale.scalex.stepxinput
       nodateerr $status($dp.stepxbuffer)
       return
  }
}

#----------------------------------------------------------------------------
# testtime {} testet, ob die Eingabezeile fromx,tox,stepx nur Zeitangaben 
#             der Form "HHMM" enthaelt und gibt entsprechende Fehlermeldungen
#             aus 
#             path : Pfad auf das Layout (Preface) Menue
#             dp   : Pfad des aktuellen Diagramms
#---------------------------------------------------------------------------
#
proc testtime {path dp} {
 
  # Statusvarablen sichtbar machen
  #
  global status
 
  # testen und entsprechende Fehlermeldung ausgeben
  #
  if {![gettime $status($dp.fromxbuffer) dummy]} {
        focus $path.diagscale.scalex.fromxinput
        notimeerr $status($dp.fromxbuffer)
        return
  }
  if {![gettime $status($dp.toxbuffer) dummy]} {
        focus $path.diagscale.scalex.toxinput
        notimeerr $status($dp.toxbuffer)
        return
  }
  if {![gettime $status($dp.stepxbuffer) dummy]} {
       focus $path.diagscale.scalex.stepxinput
       notimeerr $status($dp.stepxbuffer)
       return
  }
}

#----------------------------------------------------------------------------
# diagprefaceok {} wird nach Betaetigung des ok-Knopfes im Preface-Menue
#                  aufgerufen;
#                  Testet, ob die Eingabepuffer sinnvolle Werte enthalten;
#                  falls ok=> -die Puffervariablen werden zurueckgeschrieben 
#                  sonst   =>  focus auf fehlerhaftes Feld; Fehlermeldung 
#                  path : Pfad auf das Layput (Preface) Menue
#                  dp   : pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc diagprefaceok {path dp} {

  # Diagrammvariablen und Statusvariablen sichtbar machen 
  #
  global diagdata status

  # teste, ob alle aktivierten Entrys gueltige Zahlen enthalten
  #
  
  if {$status($dp.autoscalebuffer) == "off"} {

      # Eingabezeie fromx,tox,stepx je nach domain testen 
      #
      eval $diagdata($dp.testscaleinput) $path $dp
  
      # Eingabezeile fromy,toy,stepy testen
      #			
      if {![isdouble $status($dp.fromybuffer)]} {
          focus $path.diagscale.scaley.fromyinput 
          nodoubleerr $status($dp.fromybuffer) 
          return
      }
      if {![isdouble $status($dp.toybuffer)]} {
          focus $path.diagscale.scaley.toyinput  
          nodoubleerr $status($dp.toybuffer)  
          return
      }
      if {![isdouble $status($dp.stepybuffer)]} {
          focus $path.diagscale.scaley.stepyinput  
          nodoubleerr $status($dp.stepybuffer) 
          return
      }


   if {[expr $status($dp.fromxbuffer)]>=[expr $status($dp.toxbuffer)]} {

          #Feld fromX ist groesser oder gleich Feld toX 
          #
          focus $path.diagscale.scalex.fromxinput    
          error {The input-field "fromX" must contain a smaller value than the\
                 field "toX"} 
          # Anmerkung: hierhin wird nicht zurueckverzweigt

      }

      if {[expr $status($dp.fromybuffer)]>=[expr $status($dp.toybuffer)]} {

          #Feld fromY ist groesser oder gleich Feld toY
          #
          focus $path.diagscale.scaley.fromyinput
          error {The input-field "fromY" must contain a smaller value than the\
                 field "toY"} 
          # Anmerkung: hierhin wird nicht zurueckverzweigt
      }

      # Scalepuffervariablen zurueckschreiben
      #
      set diagdata($dp.fromx) $status($dp.fromxbuffer)
      set diagdata($dp.tox)   $status($dp.toxbuffer)
      set diagdata($dp.stepx) $status($dp.stepxbuffer)
      set diagdata($dp.fromy) $status($dp.fromybuffer)
      set diagdata($dp.toy)   $status($dp.toybuffer)
      set diagdata($dp.stepy) $status($dp.stepybuffer)
  }
  
  # restlichen Variablenpuffer zurueckschreiben
  #
  set diagdata($dp.title)      $status($dp.titlebuffer) 
  set diagdata($dp.subtitle)   $status($dp.subtitlebuffer)
  set diagdata($dp.labelx)     $status($dp.labelxbuffer)
  set diagdata($dp.labely)     $status($dp.labelybuffer)
  set diagdata($dp.autoscale)  $status($dp.autoscalebuffer) 
  set diagdata($dp.sizex)      $status($dp.sizexbuffer)
  set diagdata($dp.sizey)      $status($dp.sizeybuffer)
  set diagdata($dp.points)     $status($dp.pointsbuffer)
  set diagdata($dp.polygon)    $status($dp.polygonbuffer)
  set diagdata($dp.bspline)    $status($dp.bsplinebuffer)
  set diagdata($dp.scxcol)     $status($dp.scxcolbuffer)
  set diagdata($dp.scxcolind)  $status($dp.scxcolindbuffer)
  set diagdata($dp.grid)       $status($dp.gridbuffer)
  set diagdata($dp.undefmarks) $status($dp.undefmarksbuffer)
}   

#----------------------------------------------------------------------------
# diagswitchmenu {} erzeugt eine Menuezeile zum Bestaetigen oder Abbrechen der
#                 preface-Einstellungen
#                 path : Pfad, in den die zeile eingehaengt wird
#                 dp   : pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc diagswitchmenu {path dp} {

   # erzeuge Kontainerwidget signal 
   #
   frame $path.switch 
   pack $path.switch -pady 10 -ipadx 5 -ipady 5 -fill y  -fill x -expand true

     # erzeuge OK-Button (bei Betaetigung Pruefung und Uebername veraenderter
     # Werte
     #
     button $path.switch.ok -text " OK " \
            -command "busy {diagprefaceok $path $dp; destroy $path;
                            setoldfocus; refreshwindows $dp .}" 
     pack $path.switch.ok -padx 10 -side left -fill both -expand true 

     # erzeuge update-Button
     #
     button $path.switch.update -text "update" \
            -command "busy {diagprefaceok $path $dp; refreshwindows $dp .}"
     pack $path.switch.update -padx 10 -side left -fill both -expand true

     # erzeuge Cancel-Button (bei Betaetigung keine Uebername veraenderter
     # Werte
     #
     button $path.switch.cancel -text "Cancel" -command "setoldfocus;\
                                                         destroy $path"
     pack $path.switch.cancel -padx 10 -side right -fill both -expand true
}

#----------------------------------------------------------------------------
# fillprefbuffers {} kopiert die aktuellen preface (layout) - Variablen
#                    in die zugehoerigen Puffer-Variablen
#                    dp : Pfad des zugehoerigen Diagramms
#----------------------------------------------------------------------------
#
proc fillprefbuffers {dp} {

   # Diagrammvariablen unnd Statusvariablen sichtbar machen
   #
   global diagdata status

  # kopiere aktuelle Werte in die Puffervariablen
  #
  set status($dp.titlebuffer)      $diagdata($dp.title)
  set status($dp.subtitlebuffer)   $diagdata($dp.subtitle)
  set status($dp.labelxbuffer)     $diagdata($dp.labelx)
  set status($dp.labelybuffer)     $diagdata($dp.labely)
  set status($dp.fromxbuffer)      $diagdata($dp.fromx)
  set status($dp.toxbuffer)        $diagdata($dp.tox)
  set status($dp.stepxbuffer)      $diagdata($dp.stepx)
  set status($dp.fromybuffer)      $diagdata($dp.fromy)
  set status($dp.toybuffer)        $diagdata($dp.toy)
  set status($dp.stepybuffer)      $diagdata($dp.stepy)
  set status($dp.autoscalebuffer)  $diagdata($dp.autoscale)
  set status($dp.sizexbuffer)      $diagdata($dp.sizex)
  set status($dp.sizeybuffer)      $diagdata($dp.sizey)
  set status($dp.pointsbuffer)     $diagdata($dp.points)
  set status($dp.polygonbuffer)    $diagdata($dp.polygon)
  set status($dp.bsplinebuffer)    $diagdata($dp.bspline)
  set status($dp.scxcolbuffer)     $diagdata($dp.scxcol)
  set status($dp.scxcolindbuffer)  $diagdata($dp.scxcolind)
  set status($dp.gridbuffer)       $diagdata($dp.grid)
  set status($dp.undefmarksbuffer) $diagdata($dp.undefmarks)
} 

#----------------------------------------------------------------------------
# diagprefacemenu {} ermoeglicht dem Benutzer Voreinstellungen fuer die 
#                    Diagrammroutinen einzugeben 
#                    path : kompletter Pfadname des Menues 
#                    dp   : pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagprefacemenu {path dp} { 

# FensterAufbau :
#
# +------------preface---------------+
# |           diagtitle              |
# +----------------------------------+
# |           diagscale              |
# +----------------------------------+
# | +-----------contain------------+ |
# | |diagsize | diagrep | diagmisc | |
# | +------------------------------+ |
# +----------------------------------+
# |          diagswitch              |
# +----------------------------------+
#

  # falls toplevel schon existiert, Fenster hervorheben
  #
  if {[winfo exist $path]} {
      myraise $path
      return
  }

  # Diagrammvariablen sichtbar machen
  #
  global diagdata
 
  # erzeuge toplevel-fenster
  # 
  toplevel $path
  
  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path Layout

  # alten focus speichern
  #
  savefocus

  # setze Titel des Layoutmenues je nach ZeichenModus
  #
  set diag [string toupper $diagdata($dp.frametitle)]
  wm title $path "$diag $diagdata($dp.layouttitle)"

  # refresh-Routine erzeugen------------------------------------
  #
  proc $path.refresh {path dp} { 

    # Diagrammvariablen sichtbar machen
    #
    global diagdata

    # erstelle Puffervariablen; *buffer sind Puffervariablen; die eigentlichen
    #    Variablen werden erst geaendert, wenn der ok Knopf gedrueckt wird
    #
    fillprefbuffers $dp

    # Titel je nach Modus setzen
    #
    set diag [string toupper $diagdata($dp.frametitle)]
    wm title $path "$diag $diagdata($dp.layouttitle)"

  } ; # refreshproc

  # ------------------------------------------------------------
  # erstelle Puffervariablen; *buffer sind Puffervariablen; die eigentlichen
  #    Variablen werden erst geaendert, wenn der ok Knopf gedrueckt wird
  #
  fillprefbuffers $dp

  # realisiere Menue gemaess Aufbauskizze:
  #
  diagtitlemenu $path $dp
  diagscalemenu $path $dp
  frame $path.contain
  pack $path.contain -expand true -fill x -padx 10 -pady 5
    diagsizemenu $path.contain $dp
    diagrepmenu $path.contain $dp
    diagmiscmenu $path.contain $dp
  diagswitchmenu $path $dp
  update 

  #setze Status der Eingabefelder gemaess autoscale durch Refreshaufruf
  #
  $path.diagscale.refresh $path.diagscale $dp 

  # spezielles Verhalten des Menues: 
  #       return : Eingaben bestaetigen (wirkt wie Betaetigung des ok-Knopfes)

  # focus auf Titeleingabefenster
  #
  focus $path.frame.input.title  
}
