# -------dv-------------Menue zum waehlen der Kurvenfarben--------------------

# ----------------------------------------------------------------------------
# hexcol{} - Wandelt eine hexadezimale rgb Farbangabe in eine Liste von
#            3 Dezimalzahlen um und gibt diese zurueck.
#
#            hexcol "#ff00ff"  ->  "255 0 255"
#            hexcol "#f0f"     ->  "15 0 15"
#            hexcol "aaa"      ->  "0 0 0"
#            
#            c : umzuwandelnde HexadezimalZahl
# ----------------------------------------------------------------------------
#
proc hexcol { c } {

 set rgb ""

 if { [cindex $c 0] != "#" } then {
    # kein gueltiges Format
    #
    return "0 0 0"
 }

 # Laenge der Farbangabe ohne "#"
 #
 set l [clength $c]
 incr l -1

 # Anzahl der Stellen einer Zahl
 #
 set s [expr "$l / 3"]

 # Zahlen konvertieren
 #
 scan [crange $c 1 $s] "%x" dummy
 lappend rgb $dummy

 scan [crange $c [expr "1 + $s"] [expr "$s + $s"]] "%x" dummy
 lappend rgb $dummy

 scan [crange $c [expr "1 + (2 * $s)"] [expr "3 * $s"]] "%x" dummy
 lappend rgb $dummy

 return $rgb
}


# ----------------------------------------------------------------------------
# makeHr() Hilfsroutine; setzt die aktuelle R Farbe im R Balken
#          path   : Pfad des diagcolorschoose Menue
#          dp     : aktueller diagrammwidgetpfad
#          height : zu setzende Position
# ----------------------------------------------------------------------------
#
proc makeHr { path dp heigth } {

set win $path.r.inner

# heigth in eine hexadezimale Zahl umwandeln
#
set col [format "%.2x" $heigth]

# Farbe setzen
#
set col "#${col}0000"
$win configure -relief sunken -background $col
}                       

# ----------------------------------------------------------------------------
# makeHg() Hilfsroutine; setzt die aktuelle G Farbe im G Balken
#          path   : Pfad des diagcolorschoose Menue
#          dp     : aktueller diagrammwidgetpfad
#          height : zu setzende Position
# ----------------------------------------------------------------------------
#
proc makeHg { path dp heigth } {

set win $path.g.inner

# heigth in eine hexadezimale Zahl umwandeln
#
set col [format "%.2x" $heigth]

# Farbe setzen
#
set col "#00${col}00"
$win configure -relief sunken -background $col
}   

# ----------------------------------------------------------------------------
# makeHb() Hilfsroutine; setzt die aktuelle B Farbe im B Balken
#          path   : Pfad des diagcolorschoose Menue
#          dp     : aktueller diagrammwidgetpfad
#          height : zu setzende Position
# ----------------------------------------------------------------------------
#
proc makeHb {path dp heigth } {

set win  $path.b.inner

# heigth in eine hexadezimale Zahl umwandeln
#
set col [format "%.2x" $heigth]

set status($dp.bcol) $col

# Farbe setzen
#
set col "#0000${col}"
$win configure -relief sunken -background $col
}  

# ----------------------------------------------------------------------------
# makeHrgb() Hifsroutine ; aktualisiert die Farbe des selektierten Kurventitels
#                          und die Hexadezimale Darstellung der Farbe 
#            path : Pfad des diagcolorchoose Menues
#            dp   : aktueller Diagrammwidgetpfad
# ----------------------------------------------------------------------------
#
proc makeHrgb {path dp} {

  # Stellung der Regler ermitteln
  #
  set rcol [format "%.2x" [$path.r.slider get]]
  set gcol [format "%.2x" [$path.g.slider get]]
  set bcol [format "%.2x" [$path.b.slider get]]

  # Hexadezimale Anzeige erneuern
  #
  $path.rgb.hexr configure -text "0x$rcol"
  $path.rgb.hexg configure -text "0x$gcol"
  $path.rgb.hexb configure -text "0x$bcol"

  # Index des selectierten Eintrags ermitteln
  #
  set selected [$path.frame.listbox curselection]

  if {$selected != ""} {

     # es gibt eine Selectierung =>
     # Farbe des selectierten Eintrags setzen
     #
     $path.frame.listbox item configure $selected\
          -foreground "#$rcol$gcol$bcol"
  }
  update idletask
}

# ----------------------------------------------------------------------------
# setsliders {} Hilfsroutine; 
#               setzt die Slider und die r,g,b Farbfelder gemaess der Farbe
#               des aktuell gewaehlten Titels
# ----------------------------------------------------------------------------
#
proc setsliders {path dp} {
  
  # Index des selectierten Eintrags ermitteln
  #
  set selected [$path.frame.listbox curselection]

  if {$selected != ""} {

     # es gibt eine Selectierung =>
     # Farbe des selectierten Eintrags ermitteln
     #
     set collist [$path.frame.listbox item configure $selected -foreground]
     set color [lindex $collist 4]

     # r-g-b Werte ermitteln
     #
     set colors [hexcol $color]

     set r [lindex $colors 0]
     set g [lindex $colors 1]
     set b [lindex $colors 2]

     # setze Farben
     #
     makeHr $path $dp $r
     makeHg $path $dp $g
     makeHb $path $dp $b

     # setze Slider
     #
     $path.r.slider set $r
     $path.g.slider set $g
     $path.b.slider set $b
  }
} 

# ----------------------------------------------------------------------
# gettitlesindex {} Prozedur, die Titel bereits gewaehlter Kurven in die 
#                   Listbox des  diagchoosecolors Menue im Modus
#                   "domainindex" in der zugehoerigen Farbe eintraegt
#                   path : Pfad des diagchoosecolors Menue
#                   dp   : aktueller Datensatz
# ----------------------------------------------------------------------
#                   
proc gettitlesindex {path dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # alte Titel gegebenenfalls loeschen
   #
   catch {$path.frame.listbox delete 0 end}

   # Titel der gewaehlten Kurven eintragen
   #
   foreach title $diagdata($dp.curvelist) {

       # Titel in die Listbox eintragen
       #
       $path.frame.listbox insert end $diagdata($dp.coltitle$title)

       # Farbe dieses Titels ermitteln:
       #
       set color [getcolor $dp $title] 

       # Titel in Farbe darstellen
       #
       $path.frame.listbox item configure end -foreground $color
   }
}
 
# --------------------------------------------------------------------------
# gettitlesreal   {} Prozedur, die Titel bereits gewaehlter Kurven in die 
#                   Listbox des  diagchoosecolors Menue im Modus
#                   "domainreal" in der zugehoerigen Farbe eintraegt
#                   path : Pfad des diagchoosecolors Menue
#                   dp   : aktueller Datensatz
# --------------------------------------------------------------------------
#                   
proc gettitlesreal {path dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # alte Titel gegebenenfalls loeschen
   #
   catch {$path.frame.listbox delete 0 end}

   # Titel der gewaehlten Kurven eintragen
   #
   set i 0
   foreach title $diagdata($dp.curvelist) {

       if {[expr $i%2] == 0} {
          set dom $title
       } {
          set cod $title

          # Titel in die Listbox eintragen
          #
          $path.frame.listbox insert end\
              "$diagdata($dp.coltitle$dom)->$diagdata($dp.coltitle$cod)"

          # Farbe dieses Titels ermitteln:
          #
          set color [getcolor2 $dp $dom $cod] 

          # Titel in Farbe darstellen
          #
          $path.frame.listbox item configure end -foreground $color
      }
      incr i
   }
}

# ----------------------------------------------------------------------------
# diagcolorsokindex {} setzt die aktuell gewaehlten Farben des 
#                      diagchoosecolors Menu in die Index/Farbliste fuer den
#                      den Modus domainint
#                      path : Pfad des diagchoosecolors Menues
#                      dp   : aktueller Diagrammdatensatz
# ---------------------------------------------------------------------------- 
#
proc diagcolorsokindex {path dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   set i 0 
   foreach col $diagdata($dp.curvelist) {

      # gewaehlte Farbe ermitteln
      #
      set collist [$path.frame.listbox item configure $i -foreground]
      set color [lindex $collist 4]

      if {[getcolor $dp $col] != $color} {
         # Die gewahlte Farbe fuer die Kurve mit Index $col ist nicht
         # gleich der gespeicherten bzw. generierten Farbe =>
         # Farbe abspeichern
         #
         putcolor $dp $col $color
      }
   incr i
   }
}

# ----------------------------------------------------------------------------
# diagcolorsokreal {} setzt die aktuell gewaehlten Farben des diagchoosecolors
#                     Menue in die Index/Index/Farbliste fuer
#                     den Modus domainreal
#                     path: Pfad des diagchoosecolors Menues
#                     dp  : aktueller Diagrammdatensatz
# ----------------------------------------------------------------------------
#
proc diagcolorsokreal {path dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   set i 0 ; # Index auf i'te Spalte
   set j 0 ; # Index auf j'te Kurve

   foreach col $diagdata($dp.curvelist) {

      if {[expr $i%2] == 0} {
 
         # Urbildspalte merken
         #
         set dom $col
      } {
         # Bildspalte merken
         #
         set cod $col
   
         # gewaehlte Farbe ermitteln
         #
         set collist [$path.frame.listbox item configure $j -foreground]
         set color [lindex $collist 4]
   
         # Zeiger auf naechste Kurve
         #
         incr j

         if {[getcolor2 $dp $dom $cod] != $color} {
            # Die gewaehlte Farbe fuer die Kurve mit Urbildspalte $dom und
            # Bildspalte $cod ist nicht gleich der gespeicherten bzw. 
            # generierten Farbe => Farbe abspeichern
            #
            putcolor2 $dp $dom $cod $color
         }
      }
   incr i
   }
}

#----------------------------------------------------------------------------
# buildlistbox {} Hilfroutine; erzeugt die Listbox fuer die Darstellung der
#                 Kurventitel im diagcolorschoose Menue
#                 path : Pfad des diagcolorchoose Menue
#                 dp   : aktueller Diagrammwidgepfad
#---------------------------------------------------------------------------- 
#
proc buildlistbox {path dp} {

  # Frame fuer Listbox und Scrollbar erzeugen
  #
  frame $path.frame -relief raised
  pack $path.frame -expand true -fill both -padx 20 -pady 5

  # Schriftart der Ueberschrift ermitteln
  #
  set labelfont [lindex [$path.title configure -font] 4]

  # Listbox erzeugen
  #
  disjointlistbox $path.frame.listbox\
                  -font $labelfont\
                  -height 6 -width 0\
                  -yscroll "$path.frame.scroll set"
  pack $path.frame.listbox -side right -expand true -fill both

  # vertikale Skrollbar erzeugen
  #
  scrollbar $path.frame.scroll \
            -command "$path.frame.listbox yview"
  pack $path.frame.scroll -side left -fill y

  # Bindings fuer Single-Select Listbox 
  #
  append b {%W select from [%W nearest %y]} "; setsliders $path $dp"

  bind $path.frame.listbox <1>               $b
  bind $path.frame.listbox <B1-Motion>       $b 
  bind $path.frame.listbox <Shift-1>         " "
  bind $path.frame.listbox <2>               " "
  bind $path.frame.listbox <B2-Motion>       " "
  bind $path.frame.listbox <3>               " "
  bind $path.frame.listbox <B3-Motion>       " "
  bind $path.frame.listbox <Shift-3>         " "
  bind $path.frame.listbox <Shift-B3-Motion> " "
}

#-----------------------------------------------------------------------------
# buildsliders {} Hilfsroutine; erstellt die Schieberegler und zugehoerige
#                 Farbfelder fuer das diagcolorschoose Menue
#                 path : Pfad des diagcolorchoose Menue
#                 dp   : aktueller Datensatz
#                 cmd  : Callback,der nach dem benutzen eines Reglers
#                        aufgerufen wird
#-----------------------------------------------------------------------------
#
proc buildsliders {path dp cmd} {

   # Baue Slider
   #
   frame $path.colors

   # R Achse
   #
   frame $path.r
   label $path.r.text   -text "R:" \
                        -foreground "#ff0000"
   scale $path.r.slider -orient vertical  -length 256 -from 0 -to 255\
                        -command "eval $cmd; makeHr $path $dp"\
                        -tickinterval 25
   frame $path.r.inner  -geometry 20x40 -relief sunken -borderwidth 2\
                        -background "#000000" -class DontChangeColor
   frame $path.r.space  -width 20

   pack $path.r.text   -side top  -fill x
   pack $path.r.space  -side left -fill y
   pack $path.r.slider -side left
   pack $path.r.inner  -side left -fill y

   # G Achse
   #
   frame $path.g
   label $path.g.text   -text "G:" \
                        -foreground "#00af00"
   scale $path.g.slider -orient vertical  -length 256 -from 0 -to 255 \
                        -command "eval $cmd; makeHg $path $dp"\
                        -tickinterval 25
   frame $path.g.inner  -geometry 20x40 -relief sunken -borderwidth 2 \
                        -background "#000000" -class DontChangeColor
   frame $path.g.space  -width 20 

   pack $path.g.text    -side top  -fill x
   pack $path.g.space   -side left -fill y
   pack $path.g.slider  -side left
   pack $path.g.inner   -side left -fill y

   # b Achse
   #
   frame $path.b
   label $path.b.text   -text "B:" \
                        -foreground "#0000ff"
   scale $path.b.slider -orient vertical  -length 256 -from 0 -to 255 \
                        -command "eval $cmd; makeHb $path $dp"\
                        -tickinterval 25
   frame $path.b.inner  -geometry 20x40 -relief sunken -borderwidth 2 \
                        -background "#000000" -class DontChangeColor
   frame $path.b.spacel -width 20
   frame $path.b.spacer -width 20

   pack $path.b.text    -side top  -fill x
   pack $path.b.spacel  -side left -fill y
   pack $path.b.slider  -side left
   pack $path.b.inner   -side left -fill y
   pack $path.b.spacer  -side left -fill y
  
   # RGB- Rahmen zusammenbauen
   #
   pack $path.r   -in $path.colors -side left
   pack $path.g   -in $path.colors -side left
   pack $path.b   -in $path.colors -side left
}

#-----------------------------------------------------------------------------
# buildhexlabel {} Hilfsroutine; erstellt die Label fuer die Anzeige der
#                  Mischfarbe im diagcolorchoose Menue
#                  path: Pfadname des diagcolorchoose Menues
#                  dp  : aktueller Diagrammwidgetpfad
#-----------------------------------------------------------------------------
#
proc buildhexlabel {path dp} {

   # RGB - Hex-Darstellung 
   #
   frame $path.rgb
   label $path.rgb.text -text "current RGB-Color:" -anchor w
   label $path.rgb.hexr -text "0x0" -width 4 
   label $path.rgb.hexg -text "0x0" -width 4 
   label $path.rgb.hexb -text "0x0" -width 4
  
   pack $path.rgb -padx 5
   pack $path.rgb.text   -side left 
   pack $path.rgb.hexr $path.rgb.hexg $path.rgb.hexb -side left
}
 
# ----------------------------------------------------------------------------
# diagchoosecolors {} Menue , um Diagrammkurven Farben zuzuordnen 
#                path: Pfadname des Fensters.
#                dp  : Name des aktuellen Datensatzes
# ----------------------------------------------------------------------------
proc diagchoosecolors {path dp} {

  # Falls dieses Fenster schon offen ist, mache nichts mehr.
  #
  if {1 == [winfo exists $path]} {
     myraise $path
     return
  }

  # Diagrammvariablen sichtbar machen
  #
  global diagdata
 
  # Toplevelfenster erzeugen
  #
  toplevel $path

  # Rahmentitel setzen
  #
  set wintitle "[string toupper $diagdata($dp.frametitle)] Color Select Box"
  wm title $path $wintitle 

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path Choose

  # alten Focus sichern und focus auf auf dieses Toplevelfenster
  #
  savefocus
  focus $path

  # Fenster aufbauen---------------------------------------------------------

  # Titel setzen
  #
  label $path.title -text "Select Color of Curves" 
  pack $path.title -side top -pady 5 
  
  # Listbox fuer Kurventitel erzeugen
  #
  buildlistbox $path $dp

  # Hexadezimale Darstellung der MischFarbe 
  #
  buildhexlabel $path $dp
  
  # Slider einbauen
  #
  buildsliders $path $dp "makeHrgb $path $dp"
  pack $path.colors -side top -fill x

  # Knopfleiste erstellen
  #
  frame  $path.but
  pack $path.but    -side top -fill x -pady 10

  button $path.but.ok -text " O K " \
         -command "busy {eval $diagdata($dp.colorsok) $path $dp;\
                   destroy $path;\
                   setoldfocus; refreshwindows $dp . }"

  button $path.but.update -text "update"\
         -command "busy {eval $diagdata($dp.colorsok) $path $dp;\
                   refreshwindows $dp .}"

  button $path.but.cancel -text "Cancel"\
                      -command "destroy $path; setoldfocus"

  pack $path.but.ok $path.but.update $path.but.cancel\
       -side left -ipady 5 -padx 10 -fill x -expand true

  # Bindungen fuer Ok-Aktivierung durch 'Return' realisieren
  #
  bindreturn "[winfo children $path] $path" "$path.but.ok invoke"

  # Refreshprozedur erzeugen-------------------------------------------------
  #
  proc $path.refresh {path dp} { 

     # Diagrammvariablen sichtbar machen
     #
     global diagdata

     # Setze Defaultwerte
     # Listbox je nach Modus mit bereits gewaehlten Kurven fuellen
     # 
     eval $diagdata($dp.gettitles) $path $dp

     # ersten Eintrag selectieren
     #
     $path.frame.listbox select at 0

     # Setze Defaultwerte
     #
     setsliders $path $dp

  } ; # refreshproc

  # zum initialisieren Refreshprozedur einmal aufrufen
  #
  $path.refresh $path $dp
}
