#---------dv----------------Routinen zum Einstellen des  domain---------------

#-----------------------------------------------------------------------------
# colschoose {} Hilfsroutine, die fuer den Modus "domaininteger" eine
#               Kurvenauswahlbox aufruft
#               dp : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc colschoose {dp} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  diagcolschoosemenu $dp\_choose $dp {Choose Column To Draw}\
                  "diagcolsget $dp\_choose $dp" 
}

#-----------------------------------------------------------------------------
# colsassign {} Hilfroutine, die z.B. fuer den Modus "domainreal" eine
#               Kurvenauswahlbox aufruft
#               dp : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc colsassign {dp} {

  # Diagrammvariablen sichtbar machen
  #
  global diagdata

  diagcolsassignmenu $dp\_assign $dp {Assign Column To Draw}\
             "diagcolsassignok $dp\_assign $dp"
}

#-----------------------------------------------------------------------------
# curvechoose {} Hilfroutine, die fuer das gewaehlte domain eine Kurvenauswahl-
#                box aufruft
#                dp : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc curvechoose {dp {pos {}}} {

   # Diagrammvariablen und Statusvariablen sichtbar machen
   #
   global diagdata status

   # Position des Kurvenauswahlmenues initialisieren
   #
   set status($dp.poscurvechoose) $pos

   # Kurvenauswahlbox je nach Modus aufrufen
   #
   eval $diagdata($dp.curveselect) $dp
}

#-----------------------------------------------------------------------------
# setdomainindex {} Routine, die die Callbacks und Daten fuer den Diagrammodus
#                     "domaininteger" setzt; in diesem Modus werden 
#                     die Elemente der Datentabelle gegen ihre 
#                     Zeilenindizees angetragen. 
#                     dp : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc setdomainindex {dp} {

   # Diagrammdaten sichtbar machen
   #
   global diagdata

   if {$diagdata($dp.lastdomain) == "index"} {
      # Indexmodus schon eingeschaltet => nicht umschalten
      #
      return
   } 

   #-------datamenue----------------------------------------------------------

   # Methode, Datenkurven auszuwaehlen, setzen
   #
   set diagdata($dp.curveselect) colschoose

   #-------layoutmenu---------------------------------------------------------

   # Fenstertitel fuer Layout (preface) Menue setzen
   #
   set diagdata($dp.layouttitle) "Layout For Index Domain" 

   # Zustand fuer "Scale from Column" - Zeile im Layout Menue setzen
   #
   set diagdata($dp.scxstate) normal

   # Methode, fromx tox stepx -Daten zu ueberpruefen
   #
   set diagdata($dp.testscaleinput) testinteger

   # Methode, Wertebereiche zu berechnen 
   #
   set diagdata($dp.calcautoscale) autoscaleindex

   # Methode, Skalierungsstrings zu berechnen
   #
   set diagdata($dp.scalesx) scalesxindex

   # Methode, Kurven in ein Diagramm einzuzeichnen
   #
   set diagdata($dp.drawcurves) drawindex

   # Methode, Spaltentitel fuer das Colorchoosemenu zu setzen
   #
   set diagdata($dp.gettitles) gettitlesindex

   # Methode, gewaehlte Farben im Colorchoosemenu in die Index/Farbliste 
   # zu setzen
   #
   set diagdata($dp.colorsok) diagcolorsokindex 

   #----------Modusanpassung--------------------------------------------------

   # Kurven des letzten Modus speichern und Liste fuer Modus
   # domainint einsetzen
   #
   set last $diagdata($dp.lastdomain)
   set diagdata($dp.curvelist$last) $diagdata($dp.curvelist)
   set diagdata($dp.curvelist) $diagdata($dp.curvelistindex)

   # KurvenFarben des letzten Modus speichern
   #
   set diagdata($dp.colors$last) $diagdata($dp.colors)
   set diagdata($dp.colors) $diagdata($dp.colorsindex) 
   set diagdata($dp.lastdomain) index
 
   # Callback fuer Transformation (bei Index Diagrammen nur kopieren) 
   #
   set diagdata($dp.transform) tab2index

   # Transformation durchfuehren (bei Index Diagrammen nur Daten Kopieren)
   #
   tab2index $diagdata($dp.diagrambuf) $dp

   # Fensterinhalte erneuern
   #
   busy {refreshwindows $dp .}
}

#-----------------------------------------------------------------------------
# setdomainreal {}  Routine, die die Callbacks und Daten fuer den Diagrammodus
#                   "domainreal" setzt; in diesem Modus werden Elemente
#                   einer Spalte gegen Elemente einer weiteren Spalte
#                   angetragen
#                   dp : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc setdomainreal {dp} {

   # Diagrammdaten sichtbar machen
   #
   global diagdata

   if {$diagdata($dp.lastdomain) == "real"} {
      # realmodus schon eingeschaltet => nicht umschalten
      #
      return
   } 

   # aktuelle Pufferdaten
   #
   set db $diagdata($dp.diagrambuf)

   # ---------datamenu--------------------------------------------------------

   # Methode, Datenkurven auszuwaehlen, setzen 
   #
   set diagdata($dp.curveselect) colsassign

   # ---------layoutmenu------------------------------------------------------

   # Fenstertitel fuer Layout (preface) Menue setzen
   #
   set diagdata($dp.layouttitle) "Layout For Real Domain" 

   # Zustand fuer "Scale from Column" - Zeile im Layoutmenue setzen
   #
   set diagdata($dp.scxstate) disabled

   # Methode, fromx tox stepx -Daten zu ueberpruefen
   #
   set diagdata($dp.testscaleinput) testreal

   # Methode, Skalierungsbereiche zu berechnen
   #
   set diagdata($dp.calcautoscale) autoscalereal  

   # Methode, Skalierungsstrings zu berechnen
   #
   set diagdata($dp.scalesx) scalesxreal

   # Methode, Spaltentitel fuer das Colorchoosemenu zu setzen
   #
   set diagdata($dp.gettitles) gettitlesreal

   # Methode, gewaehlte Farben im diagcolorschoose Menu in die Index/Farbliste 
   # zu setzen
   #
   set diagdata($dp.colorsok) diagcolorsokreal 

   # ---------diagramm--------------------------------------------------------

   # Methode, Kurven in ein Diagramm einzuzeichnen
   #
   set diagdata($dp.drawcurves) drawreal

   # ---------Modusanpassung--------------------------------------------------

   # Kurven des letzten Modus speichern und Liste fuer Modus
   # domainreal einsetzen
   #
   set last $diagdata($dp.lastdomain)
   set diagdata($dp.curvelist$last) $diagdata($dp.curvelist)
   set diagdata($dp.curvelist) $diagdata($dp.curvelistreal)

   # KurvenFarben des letzten Modus speichern
   #
   set diagdata($dp.colors$last) $diagdata($dp.colors)
   set diagdata($dp.colors) $diagdata($dp.colorsreal) 
   set diagdata($dp.lastdomain) real

   # Callback fuer Transformation setzen
   # (bei reelen Diagrammen nur Daten kopieren) 
   #
   set diagdata($dp.transform) tab2real

   # Transformation durchfuehren (bei reelen Diagrammen nur Daten kopieren)
   #
   tab2real $diagdata($dp.diagrambuf) $dp 

   # Fensterinhalte erneuern
   #
   busy {refreshwindows $dp .}
}


#-----------------------------------------------------------------------------
# setdomaindate{}  Routine, die die Callbacks und Daten fuer den Diagrammodus
#                   "domaindate" setzt; in diesem Modus werden Elemente
#                   einer Spalte gegen Elemente einer weiteren Spalte
#                   angetragen, wobei die Werte der Urbildspalte als
#                   Zeitwerte der Form "YYMMDD" ausgewertet werden:
#                   Beispiel: 911018 wird als 18.10.'91 berechnet 
#                   dp : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc setdomaindate {dp} {

   # Diagrammdaten sichtbar machen
   #
   global diagdata

   if {$diagdata($dp.lastdomain) == "date"} {
      # Zeitmodus schon eingeschaltet => nicht umschalten
      #
      return
   } 

   # ---------datamenu--------------------------------------------------------

   # Methode, Datenkurven auszuwaehlen, setzen 
   #
   set diagdata($dp.curveselect) colsassign

   # ---------layoutmenu------------------------------------------------------

   # Fenstertitel fuer Layout (preface) Menue setzen
   #
   set diagdata($dp.layouttitle) "Layout For Date Domain (YYMMDD)" 
   
   # Zustand fuer "Scale from Column" - Zeile im Layoutmenue setzen
   #
   set diagdata($dp.scxstate) disabled

   # Methode, fromx tox stepx -Daten zu ueberpruefen
   #
   set diagdata($dp.testscaleinput) testreal

   # Methode, Skalierungsbereiche zu berechnen
   #
   set diagdata($dp.calcautoscale) autoscalereal 

   # Methode, Skalierungsstrings zu berechnen
   #
   set diagdata($dp.scalesx) scalesxdate

   # Methode, Spaltentitel fuer das Colorchoosemenu zu setzen
   #
   set diagdata($dp.gettitles) gettitlesreal    

   # Methode, gewaehlte Farben im diagcolorschoose Menu in die Index/Farbliste 
   # zu setzen
   #
   set diagdata($dp.colorsok) diagcolorsokreal 

   # ---------diagramm--------------------------------------------------------

   # Methode, Kurven in ein Diagramm einzuzeichnen
   #
   set diagdata($dp.drawcurves) drawreal

   # ---------Modusanpassung--------------------------------------------------

   # Kurven des letzten Modus speichern und Liste fuer Modus
   # domaindate einsetzen
   #
   set last $diagdata($dp.lastdomain)
   set diagdata($dp.curvelist$last) $diagdata($dp.curvelist)
   set diagdata($dp.curvelist) $diagdata($dp.curvelistdate)

   # KurvenFarben des letzten Modus speichern
   #
   set diagdata($dp.colors$last) $diagdata($dp.colors)
   set diagdata($dp.colors) $diagdata($dp.colorsdate) 
   set diagdata($dp.lastdomain) date

   # Callback fuer Transformation setzen
   #
   set diagdata($dp.transform) tabdate2real 

   # Transformation durchfuehren 
   #
   tabdate2real $diagdata($dp.diagrambuf) $dp

   # Fensterinhalte erneuern
   #
   busy {refreshwindows $dp .}
}


#-----------------------------------------------------------------------------
# setdomaintime {}  Routine, die die Callbacks und Daten fuer den Diagrammodus
#                   "domaintime" setzt; in diesem Modus werden Elemente
#                   einer Spalte gegen Elemente einer weiteren Spalte
#                   angetragen, wobei die Werte der Urbildspalte als
#                   Zeitwerte der Form "HHMM" ausgewertet werden:
#                   Beispiel: 1510 wird als 15 Uhr 10  berechnet 
#                   dp : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc setdomaintime {dp} {

   # Diagrammdaten sichtbar machen
   #
   global diagdata

   if {$diagdata($dp.lastdomain) == "time"} {
      # realmodus schon eingeschaltet => nicht umschalten
      #
      return
   } 

   # ---------datamenu--------------------------------------------------------

   # Methode, Datenkurven auszuwaehlen, setzen 
   #
   set diagdata($dp.curveselect) colsassign

   # ---------layoutmenu------------------------------------------------------

   # Fenstertitel fuer Layout (preface) Menue setzen
   #
   set diagdata($dp.layouttitle) "Layout For Time Domain (HHMM)" 
   
   # Zustand fuer "Scale from Column" - Zeile im Layoutmenue setzen
   #
   set diagdata($dp.scxstate) disabled

   # Methode, fromx tox stepx -Daten zu ueberpruefen
   #
   set diagdata($dp.testscaleinput) testreal

   # Methode, Skalierungsbereiche zu berechnen
   #
   set diagdata($dp.calcautoscale) autoscalereal

   # Methode, Skalierungsstrings zu berechnen
   #
   set diagdata($dp.scalesx) scalesxtime

   # Methode, Spaltentitel fuer das Colorchoosemenu zu setzen
   #
   set diagdata($dp.gettitles) gettitlesreal

   # Methode, gewaehlte Farben im diagcolorschoose Menu in die Index/Farbliste 
   # zu setzen
   #
   set diagdata($dp.colorsok) diagcolorsokreal

   # ---------diagramm--------------------------------------------------------

   # Methode, Kurven in ein Diagramm einzuzeichnen
   #
   set diagdata($dp.drawcurves) drawreal

   # ---------Modusanpassung--------------------------------------------------

   # Kurven des letzten Modus speichern und Liste fuer Modus
   # domaintime einsetzen
   #
   set last $diagdata($dp.lastdomain)
   set diagdata($dp.curvelist$last) $diagdata($dp.curvelist)
   set diagdata($dp.curvelist) $diagdata($dp.curvelisttime)

   # KurvenFarben des letzten Modus speichern
   #
   set diagdata($dp.colors$last) $diagdata($dp.colors)
   set diagdata($dp.colors) $diagdata($dp.colorstime) 
   set diagdata($dp.lastdomain) time

   # Callback fuer Transformation setzen 
   #
   set diagdata($dp.transform) tabtime2real 

   # Transformation durchfuehren 
   #
   tabtime2real $diagdata($dp.diagrambuf) $dp
 
   # Fensterinhalte erneuern
   #
   busy {refreshwindows $dp .}
}
