#--------dv------------------Routinen des Menues Data-------------------------

#-----------------------------------------------------------------------------
# diagcolsget {}  ermittelt die Indizees der aktuell gewahlten Spaltentitel
#                 (call-back fuer den Ok-knopf in diagcolschoosemenu {})
#                 path : Pfad, in den das diagcolschoosemenu eingehaengt wurde
#                 dp   : Pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagcolsget {path dp} {

  # Diagramm und -Statusdaten sichtbar machen
  #
  global diagdata status

  # Liste ausgewaehlter Spaltenindizees ermitteln 
  # 
  set selected [$path.frame.listbox curselection]

  # Liste zu zeichnender Kurven initialisieren
  #
  set diagdata($dp.curvelist) "" 

  # Transformation der Indizees der Liste gewaehlter Spaltentitel
  #
  foreach col $selected {
     lappend diagdata($dp.curvelist) $status($dp.listtoarray$col)  
  } 
}

#-----------------------------------------------------------------------------
# diagcolschoosemenu {} erzeugt Listbox zur Auswahl von Zahlenspalten des
#                  gewaehlten Datensatzes
#                  path : Pfad, in den die Auswahlbox eingehaengt wird
#                  dp   : Pfad des Diagramms
#                  head : Kopfzeile, die in der Listbox erscheint
#                  cmd  : Kommandos, die auf "OK-gedrueckt" ausgefuehrt werden
#-----------------------------------------------------------------------------
#
proc diagcolschoosemenu {path dp head cmd} {

  # Diagramm und Statusdaten sichtbar machen
  #
  global diagdata status

  # "$cmd" zwischenspeichern, damit die Refreshroutine darauf zugreifen kann
  # 
  set status($dp.cmd) $cmd

  # falls toplevel schon existiert, Fenster hervorheben
  #
  if {[winfo exist $path]} {
      myraise $path noclear
      return
  }

  # toplevel, in das die Listbox eingehaengt wird, erzeugen
  #
  toplevel $path

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path Choose 

  # alten Focus sichern und focus auf auf dieses Toplevelfenster 
  #
  savefocus
  focus $path

  # Groesse des Toplevels initialisieren
  #
  wm geometry $path 200x300$status($dp.poscurvechoose)

  # minimale Groesse festlegen und damit Fenstergroesse veraenderbar machen
  #
  wm minsize $path 100 100
 
  # Label setzen
  #
  label $path.heading -text $head 
  pack  $path.heading -fill x

  # Frame fuer Listbox und Scrollbar erzeugen
  #
  frame $path.frame -relief raised
  pack $path.frame -expand true -fill both 

  # Schriftart der Ueberschrift ermitteln
  #
  set labelfont [lindex [$path.heading configure -font] 4]

  # Listbox erzeugen
  #
  disjointlistbox $path.frame.listbox\
                  -font $labelfont\
                  -height 0 -width 0\
                  -yscroll "$path.frame.scroll set"
  pack $path.frame.listbox -side right -expand true -fill both

  # vertikale Skrollbar erzeugen
  #
  scrollbar $path.frame.scroll \
            -command "$path.frame.listbox yview"
  pack $path.frame.scroll -side left -fill y

  # Refreshprozedur definieren
  #
  proc $path.refresh {path dp} {

      # Diagramm und Statusdaten sichtbar machen
      #
      global diagdata status

      if {$diagdata($dp.curveselect) != "colschoose"} {
 
         # dieses curveselectmenu ist faelschlicherweise offen =>
         # Position dieses Fensters feststellen
         #
         regexp {.*(\+[0-9]*\+[0-9]*)} [wm geometry $path] all pos 

         # Menue zerstoeren
         # (sicherheitshalber disjointlistbox zerstoeren)
         # 
         $path.frame.listbox destroy
         destroy $path
 
         # passendes curveselectsmenu je nach Modus aufrufen;
         # Position dieses Fensters uebergeben
         #
         curvechoose $dp $pos
 
         return
      } {
         # richtiges curveselectmenue ist offen
         # => Refresh durchfuehren

         # Titel setzen
         #
         wm title $path\
            "[string toupper $diagdata($dp.frametitle)] Column Select Box\
              for $diagdata($dp.domain) domain"
 
         # Eintraege der Listbox loeschen
         #
         $path.frame.listbox select clear
         $path.frame.listbox delete 0 end

         # vorhandene Spalten eintragen
         #
         set ref 0
         loop i 0 $diagdata($dp.colnum) {
            if {$diagdata($dp.coltype$i) == "number" } {
                # nur Titel von Zahlenspalten einfuegen
                #
                $path.frame.listbox insert end $diagdata($dp.coltitle$i)
 
                # Referenzindextabellen erstellen
                # 
                set status($dp.arraytolist$i) $ref
                set status($dp.listtoarray$ref) $i 
                incr ref
             }
         } 

         # bereits ausgewaehlte Titel selectiert darstellen
         #
         foreach col $diagdata($dp.curvelist) {
              $path.frame.listbox select\
                  from $status($dp.arraytolist$col) keep 
         }

         # Ok-Knopf anpassen
         #
         $path.switch.ok config -text "OK "\
             -command "busy {eval $status($dp.cmd);\
                      $diagdata($dp.transform) $diagdata($dp.diagrambuf) $dp;\
                      destroy $path;\
                      refreshwindows $dp .;\
                      setoldfocus}"
       
         # update-Knopf anpassen 
         #
         $path.switch.update config -text "update"\
             -command "busy {eval $status($dp.cmd);\
                       $diagdata($dp.transform) $diagdata($dp.diagrambuf) $dp;\
                       refreshwindows $dp .}"
              
     } ; # if falsches curveselectmenu
   } ; #  Refreshprozedur

   # Return-Taste wie Ok-Knopf Bestaetigung
   #
   bind $path <Return> "$path.switch.ok invoke"
 
   # toggle-Funktion auf Maustaste-1
   #
   bind $path.frame.listbox <1> {%W select toggle [%W nearest %y]}
 
   # Blockselection von Maustaste-1-Bewegung loeschen
   #
   bind $path.frame.listbox <B1-Motion> " "
 
   # Blockselection auf shift-Maustaste-1
   #
   bind $path.frame.listbox\
        <Shift-1> {%W select to [%W nearest %y]}
 
   # Frame fuer Ok-,update und Abbruch-Knopf realisieren
   #
   frame $path.switch
   pack $path.switch -fill x
 
   # Ok-Knopf realisieren
   #
   button $path.switch.ok 
   pack $path.switch.ok -side left -padx 5 -pady 5 -expand true -fill both 
 
   # update-Knopf realisieren
   #
   button $path.switch.update
   pack $path.switch.update -side left -padx 5 -pady 5 -expand true\
                           -fill both
 
   # Cancel-Knopf realisieren
   #
   button $path.switch.cancel -text "Cancel"\
                              -command "setoldfocus; destroy $path"
   pack $path.switch.cancel -side left -padx 5 -pady 5 -expand true\
      -fill both
 
   # Listbox durch Refreshaufruf initialisieren
   #
   busy {$path.refresh $path $dp}
}

#-----------------------------------------------------------------------------
# assignisin {} Hilfsprozedur von assignselected; stellt fest, ob eine
#               zugeordnete Kurve bereits vorhanden ist
#               dp    : Pfad des aktuellen Diagramms
#               colind: zuletzt gewaehlter Spaltenindex 
#               return  -1                       , falls Kurve nicht vorhanden
#                       Index der "domain-Spalte", falls Kurve vorhanden  
#-----------------------------------------------------------------------------
#
proc assignisin {dp colind} {

  # Statusvariablen sichtbar machen
  #
  global status

  # Teste, ob diese Kurve bereits selectiert wurde
  #
  set isin -1 
  loop i 0 [llength $status($dp.curvelistbuffer)] 2 {
       set aktind  [lindex $status($dp.curvelistbuffer) [expr $i+1]]
       set lastind [lindex $status($dp.curvelistbuffer) $i]
       set lastcolind $status($dp.assignlastind)
 
       if {$aktind == $colind && $lastind == $lastcolind} {
          # die ausgewaehlte Kurve ist bereits in der Listbox => 
          #
          set isin $i
          break
       } ; # if 
  } ; # loop
  return $isin
}
 
#-----------------------------------------------------------------------------
# assignselected {} wird aufgerufen, wenn der select-Knopf im diagcolassign-
#                   menue betaetigt wird
#                   path : Pfad des diagcolsassignmenu
#                   dp   : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
# 
proc assignselected {path dp} {

  # Status und Diagrammvariablen sichtbar machen
  #
  global diagdata status

  # Index des aktuell gewaehlten Eintrags ermitteln
  #
  set ind [$path.choose.columns.list.listbox curselection]

  if {$ind != ""} {
     # es wurde ein Titel ausgewaehlt =>
     # zugehoerigen Spaltenindex ermitteln
     #
     set colind $status($dp.aslisttoarray$ind)

     # zugehoerigen String ermitteln
     #
     set colstr $diagdata($dp.coltitle$colind)
 
     # Spaltentitel gewaehlt=>
     #
     if {[expr $status($dp.assignstatus)%2] == 0} {
        # Zustand des Eingabeautomats auf "Urbild eingeben" => 
        # gewaehlten Spaltentitel sichern
        #
        set status($dp.assignlastind) $colind
 
        # setze gewahlten Titel in den Anzeigenstring 
        #  
        set status($dp.assignreport) "$colstr->"

        # neue Eingabeaufforderung setzen
        #
        $path.report.clickreq config -text "select codomain: "

     } {
        # Zustand des Eingabeautomats auf "Bild eingeben" =>
        #
        # Positionierung der Spalten in der Listbox vorbereiten
        #
        set pre [$path.choose.curves.list.scroll get]
        set totalunits [lindex $pre 0]
        set windowunits [lindex $pre 1]

        set isin [assignisin $dp $colind]
        if {$isin != -1} {
           # die ausgewaehlte Kurve ist vorhanden =>
           # Position der Kurventitel in der Listbox feststellen 
           # 
           set pos [expr $isin/2] 
           
           # festgestellte Position selectieren
           #
           $path.choose.curves.list.listbox select from $pos 

           # selectierte Zeile moeglichst ans ende der Listbox
           #
           $path.choose.curves.list.listbox yview\
                 [expr $pos-$windowunits+1]
         } {
           # die ausgewaehlte Kurve ist noch nicht vorhanden=>
           # gewaehlten Titel an Anzeigenstring anhaengen
           #
           append status($dp.assignreport) $colstr

           # Indizees der gewaehlten Spalten an die Kurvenpufferliste anhaengen
           #
           lappend status($dp.curvelistbuffer)\
           $status($dp.assignlastind) $colind

           # gewaehlte Kurve in AnzeigenListbox
           #
           $path.choose.curves.list.listbox insert end\
               $status($dp.assignreport)
        
           # Ergebnis selectieren
           #
           $path.choose.curves.list.listbox select from end

           # Ergebnis moeglichst an letzte sichtbare Position in der Listbox
           #
           $path.choose.curves.list.listbox yview\
           [expr $totalunits-$windowunits+1]

         } ; # gewaehlte Kurve nicht vorhanden 

         # neue Eingabeaufforderung setzen
         #
         $path.report.clickreq config -text "select domain: "
  
         # Reportlabelstring loeschen
         #
         set status($dp.assignreport) "" 

     } ; # if Zustand auf "Bild eingeben"

     # Anzeigenstring darstellen
     #
     $path.report.chosen config -text $status($dp.assignreport)

     # Status des Eingabeautomaten aendern
     #
     incr status($dp.assignstatus)

  } ; # if Titel gewaehlt
}
  
#-----------------------------------------------------------------------------
# assignselect {} erzeugt Listbox mit Zahlenspalten fuer das
#                 diagcolsassignmenu  um Spalten zueinander zuweisen zu koenen
#                 path : pfad des diagcolassignmenu 
#                 dp   : pfad des aktuellen Diagramms
#----------------------------------------------------------------------------- 
#
proc assignselect {path dp} {

  # Diagrammdaten und Statusdaten sichtbar machen
  #
  global diagdata status

  # Pfadvariable anpassen
  #
  set p "$path.choose.columns"

  # Frame fuer widget anlegen
  #
  frame $p
  pack $p -fill both -expand true -side left -padx 5

  # Ueberschrift erzeugen
  #
  label $p.head -text "columns"
  pack $p.head

  # Frame fuer Listbox und Scrollbar erzeugen
  #
  frame $p.list -relief raised
  pack $p.list -fill both -expand true

  # vertikale Skrollbar erzeugen
  #
  scrollbar $p.list.scroll \
             -command "$p.list.listbox yview"
  pack $p.list.scroll -side left -fill y

  # Listbox erzeugen 
  #
  listbox $p.list.listbox\
          -yscroll "$p.list.scroll set"\
          -geometry 1x1
  pack $p.list.listbox -side left -expand true -fill both

  # Bindings fuer "nur einzelne Eintraege auswaehlen" setzen 
  #
  tk_listboxSingleSelect $p.list.listbox

  # erzeuge Refreshprozedur
  #
  proc $p.refresh {p dp} { 

     # Diagrammdaten und Statusdaten sichtbar machen
     #
     global diagdata status

     # eventuell vorhandene alten Titel loeschen
     #
     $p.list.listbox delete 0 end

     # Spaltentitel in Listbox
     #
     set ref 0
     loop i 0 $diagdata($dp.colnum) {
        if {$diagdata($dp.coltype$i) == "number" } {
           # nur Titel von Zahlenspalten einfuegen
           #
           $p.list.listbox insert end $diagdata($dp.coltitle$i)
 
           # Referenzindextabellen erstellen
           #
           set status($dp.asarraytolist$i) $ref
           set status($dp.aslisttoarray$ref) $i
           incr ref
        }
     } ; # loop 
  } ; # Refreshproc

  # Fenster durch Aufruf der Refreshprozedur initialisieren
  #
  $p.refresh $p $dp

  # Auswahlknopf erzeugen 
  #
  button $p.do -text "select" -command "assignselected $path $dp"
  pack $p.do -pady 5 -fill x 

  # Auswahl auch per Doppelklick ermoeglichen
  #
  bind $p.list.listbox <Double-Button-1> \
       "$p.do invoke"
}

#-----------------------------------------------------------------------------
# assignremove {} loescht den aktuell selectierten Eintrag der der 
#                 Kurvenanzeigebox ; wird von assignedshow aufgerufen
#                 path : Pfad des diagcolsassignmenu
#                 dp   : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc assignremove {path dp} {

   # Statusvariablen sichtbar machen
   #
   global status

   # Index des selektierten Eintrags ermitteln
   #
   set index [$path.choose.curves.list.listbox curselection] 

   if {$index != ""} {
      # es ist ein Eintrag selectiert =>
 
      # Eintraege aus der Listbox loeschen
      #
      $path.choose.curves.list.listbox delete $index
 
      # zu loeschende Stelle in der Kurvenpufferliste ermitteln
      # 
      set remove [expr $index*2]
 
      # die zugehoerigen Spalten aus der Pufferliste entfernen
      #
      lvarpop status($dp.curvelistbuffer) $remove
      lvarpop status($dp.curvelistbuffer) $remove

   } ; # Eintrag selectiert
}   

#-----------------------------------------------------------------------------
# assignedshow {} erzeugt Listbox zur Anzeige mit Zahlenspalten fuer das
#                 diagcolsassignmenu
#                 path : pfad des diagcolsassignmenu 
#                 dp   : pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc assignedshow {path dp} {

  # Diagrammdaten und Statusdaten sichtbar machen
  #
  global diagdata status

  # Pfad der Auswahlbox anpassen
  #
  set p "$path.choose.curves"

  # Frame fuer widget anlegen
  #
  frame $p
  pack $p -fill both -expand true -side left -padx 5

   # Ueberschrift erzeugen
   #
   label $p.head -text "curves"
   pack $p.head

   # Frame fuer Listbox und Scrollbar erzeugen
   #
   frame $p.list -relief raised
   pack $p.list -fill both -expand true

   # vertikale Skrollbar erzeugen
   #
   scrollbar $p.list.scroll \
             -command "$p.list.listbox yview"
   pack $p.list.scroll -side left -fill y

   # Listbox erzeugen 
   #
   listbox $p.list.listbox\
           -yscroll "$p.list.scroll set"\
           -geometry 1x1
   pack $p.list.listbox -side left -expand true -fill both

   # Bindings fuer "nur einzelne Eintraege auswaehlen" setzen 
   #
   tk_listboxSingleSelect $p.list.listbox

   # Refreshprozedur fuer Kurvenlistbox definieren
   #
   proc $p.refresh {p dp} {

      # Diagrammdaten und Statusdaten sichtbar machen
      #
      global diagdata status

      $p.list.listbox delete 0 end
 
      # Voreingestellten Zuordnungen in die Listbox
      #
      set i 0
      foreach col $diagdata($dp.curvelist) {
        incr i
        if {[expr $i%2] == 1} {
           set curvetitle "$diagdata($dp.coltitle$col)->"                
        } {
           append curvetitle $diagdata($dp.coltitle$col)
           $p.list.listbox insert end $curvetitle
        }
      }
      # Laenge der Kurvenliste feststellen
      #
      set l [llength $status($dp.curvelistbuffer)]

      if {[expr $l%2] == 1} {
         # Anzahl der Elemente ist ungerade => 
         # letztes Element loeschen 
         #
         lvarpop status($dp.curvelistbuffer) end 
      }

      # initialisiere Status des Eingabeautomates
      #
      set status($dp.assignstatus) 0

      # initialisiere Inhalt der Report-Anzeige
      #
      set status($dp.assignreport) ""

   } ; # Refreshproc

   # Fenster durch aufruf der Refreshprozedur initialisieren
   #
   $p.refresh $p $dp

   # Auswahlknopf erzeugen 
   #
   button $p.do -text "remove" -command "assignremove $path $dp" 
   pack $p.do -pady 5 -fill x 

   # Auswahl auch per Doppelklick ermoeglichen
   #
   bind $p.list.listbox <Double-Button-1> \
       "$p.do invoke"
}

#-----------------------------------------------------------------------------
# diagcolsassignok {} wird aufgerufen, wenn der ok-Knopf im diagcolsassignmenu
#                 betaetigt wird ;
#                 kopiert die eingestellten Spaltenzuordnungen in die 
#                 Kurvenliste
#                 path : Pfad des Menues
#                 dp   : Pfad des aktuellen Diagramms
#-----------------------------------------------------------------------------
#
proc diagcolsassignok {path dp} {

   # Diagramm -und Statusvariablen sichtbar machen
   #
   global diagdata status

   # Pufferliste kopieren
   # 
   set diagdata($dp.curvelist) $status($dp.curvelistbuffer)
}
     
#-----------------------------------------------------------------------------
# diagcolsassignmenu {} erzeugt widget zur Definition (und Auswahl) von Kurven 
#                  path : Pfad, in den das widget eingehaengt wird
#                  dp   : Pfad des Diagramms
#                  head : Kopfzeile, die in dem widget erscheint
#                  cmd  : Kommandos, die auf "OK-gedrueckt" ausgefuehrt werden
#----------------------------------------------------------------------------- 
#
proc diagcolsassignmenu {path dp head cmd} {

  # Fenster Aufbau
  #
  # +---------assign-------------+
  # | +--------choose----------+ |
  # | |selectbox | assignedbox | |
  # | +------------------------+ |       
  # | +--------report----------+ |
  # | | clickreq | chosen      | |
  # | +------------------------+ |
  # | +--------switch----------+ |
  # | |   ok     |    cancel   | |
  # | +------------------------+ |
  # +----------------------------+ 

  # Diagramm und Statusvariablen sichtbar machen
  #
  global diagdata status

  # "$cmd" zwischenspeichern, damit die Refreshroutine darauf zugreifen kann
  # 
  set status($dp.cmd) $cmd
  
  # falls Toplevel schon existiert Fenster nur hervorheben 
  #
  if {[winfo exist $path]} {
      myraise $path noclear
      return
  }
 
  # toplevel, in das das widget eingehaengt wird erzeugen
  #
  toplevel $path

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path Assign
 
  # alten Focus sichern und focus auf auf dieses Toplevelfenster
  #
  savefocus
  focus $path
 
  # Groesse des Toplevels initialisieren
  #
  wm geometry $path 400x300$status($dp.poscurvechoose)
 
  # minimale Groesse festlegen und damit Fenstergroesse veraenderbar machen
  #
  wm minsize $path 200 200
 
  # Refreshpozedur definieren
  #
  proc $path.refresh {path dp} {

    # Diagrammvariablen und Statusvariablen sichtbar machen
    #
    global diagdata status

    if {$diagdata($dp.curveselect) != "colsassign"} {

       # dieses curveselectmenu ist faelschlicherweise offen =>
       # Position festhalten
       #
       regexp {.*(\+[0-9]*\+[0-9]*)} [wm geometry $path] all pos 

       # Menue zerstoeren 
       #
       destroy $path

       # passendes curveselectsmenu je nach Modus aufrufen;
       # Position dieses Menues uebergeben
       #
       curvechoose $dp $pos 

       return
    } {
       # richtiges curveselectmenu ist offen =>
       # Kurvenliste in Puffer
       #
       set status($dp.curvelistbuffer) $diagdata($dp.curvelist)

       # Titel setzen
       #
       wm title $path\
          "[string toupper $diagdata($dp.frametitle)] Curve Select Box\
            for $diagdata($dp.domain) domain"
   
       # Ok-Knopf anpassen
       #
       $path.switch.ok config -text "OK"\
          -command "busy {eval $status($dp.cmd);\
                        $diagdata($dp.transform) $diagdata($dp.diagrambuf) $dp;\
                        destroy $path;\
                        refreshwindows $dp .;\
                        setoldfocus}"
     
       # update-Knopf anpassen
       #
       $path.switch.update config -text "update"\
           -command "busy {eval $status($dp.cmd);\
                     $diagdata($dp.transform) $diagdata($dp.diagrambuf) $dp;\
                     refreshwindows $dp .}"
       } ; # if falsches curveselectmenu
     } ; # Refreshproc
  
  # Frame fuer Ok-Knopf und Abbruch-Knopf realisieren
  #
  frame $path.switch
  pack $path.switch -fill x

  # Ok-Knopf realisieren
  #
  button $path.switch.ok
  pack $path.switch.ok -side left -padx 5 -pady 5 -expand true \
       -fill both

  # Return-Taste wie Ok-Knopf Bestaetigung
  #
  bind $path <Return> "$path.switch.ok invoke"

  # update-Knopf realisieren
  #
  button $path.switch.update 
  pack $path.switch.update -side left -padx 5 -pady 5 -expand true \
      -fill both

  # Cancel-Knopf realisieren
  #
  button $path.switch.cancel  -text "Cancel"\
        -command "setoldfocus; destroy $path"
  pack $path.switch.cancel -side left -padx 5 -pady 5 -expand true\
        -fill both

  # Refreshprozedur zum initialisieren Aufrufen
  #
  $path.refresh $path $dp

  # Label setzen
  #
  label $path.heading -text $head
  pack $path.heading -before $path.switch -fill x

  # frame choose erzeugen
  #
  frame $path.choose
  pack $path.choose -before $path.switch -expand true -fill both

   # Listbox fuer Spaltenzuordnung
   #
   assignselect $path $dp

   # Listbox fuer Anzeige zugeordneter Spalten
   #
   assignedshow $path $dp

  # Frame report setzen
  #
  frame $path.report
  pack $path.report -before $path.switch
 
   # Anklickaufforderungslabel setzen
   #
   label $path.report.clickreq -text "select domain:"
   pack $path.report.clickreq -side left
 
   # Zustandsanzeige setzen
   #
   label $path.report.chosen
   pack $path.report.chosen -side left
}
