# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc useredit_passwd_create {w} \
{
catch \
{
	global BACKGROUND_COLOR_ADD_EDIT

	toplevel $w.passwd
	wm title $w.passwd "PASSWD [wm title $w]"

	upvar #0 tmp_passwd($w) tmp_passwd_old
	upvar #0 tmp_passwd($w.newpasswd) tmp_passwd_new
	upvar #0 tmp_passwd($w.passwd) tmp_passwd
	set tmp_passwd_new $tmp_passwd_old
	set tmp_passwd {}

	frame $w.passwd.pw -border 5 -background $BACKGROUND_COLOR_ADD_EDIT

	frame $w.passwd.pw.old
	label $w.passwd.pw.old.label -relief flat -width 20 -anchor e -text "Encrypted Passwd:"
	label $w.passwd.pw.old.entry -relief sunken -anchor w -text $tmp_passwd_old
	pack append $w.passwd.pw.old \
		$w.passwd.pw.old.label {left} \
		$w.passwd.pw.old.entry {right expand fillx}

	frame $w.passwd.pw.new
	label $w.passwd.pw.new.label -relief flat -width 20 -anchor e -text "Enter Passwd:"
	entry $w.passwd.pw.new.entry -relief sunken -width 20
	pack append $w.passwd.pw.new \
		$w.passwd.pw.new.label {left} \
		$w.passwd.pw.new.entry {right fillx}

	button $w.passwd.pw.button -relief raised -text "OK" -command "useredit_passwd_ok1 $w"

	pack append $w.passwd.pw \
		$w.passwd.pw.old {top fillx} \
		$w.passwd.pw.new {top fillx} \
		$w.passwd.pw.button {top fillx}

	frame $w.passwd.control -border 5 -background $BACKGROUND_COLOR_ADD_EDIT
	button $w.passwd.control.apply -text "Apply Changes" -command "useredit_passwd_apply $w"
	button $w.passwd.control.control -width 17 -text "Cancel" -command "destroy $w.passwd"
	pack append $w.passwd.control \
		$w.passwd.control.apply {left} \
		$w.passwd.control.control {right}

	pack append $w.passwd $w.passwd.pw {top} $w.passwd.control {bottom fillx}

	bind $w.passwd.pw.new.entry <Any-Key> "useredit_passwd_keypress $w %A"
	bind $w.passwd.pw.new.entry <Delete> "useredit_passwd_delete $w"
	bind $w.passwd.pw.new.entry <BackSpace> "useredit_passwd_delete $w"
	bind $w.passwd.pw.new.entry <Control-h> "useredit_passwd_delete $w"
	bind $w.passwd.pw.new.entry <Return> "useredit_passwd_ok1 $w"
}
}

proc useredit_passwd_keypress {w key} \
{
	upvar #0 tmp_passwd($w.passwd) tmp_passwd
	set c [$w.passwd.pw.new.entry index insert]
	if { ($key>=" ") && ($key<="~") } \
	{
		$w.passwd.pw.new.entry insert $c "#"
		set tmp_passwd "[string range $tmp_passwd 0 [expr "$c-1"]]$key[string range $tmp_passwd $c end]"
		return
	}
}

proc useredit_passwd_delete {w} \
{
	upvar #0 tmp_passwd($w.passwd) tmp_passwd
	set c [$w.passwd.pw.new.entry index insert]
	set tmp_passwd "[string range $tmp_passwd 0 [expr "$c-2"]][string range $tmp_passwd $c end]"
	backspace $w.passwd.pw.new.entry
}

proc useredit_passwd_ok1 {w} \
{
	upvar tmp_passwd_save($w.passwd) tmp_passwd_save
	upvar #0 tmp_passwd($w.passwd) tmp_passwd
	set tmp_passwd_save $tmp_passwd
	set tmp_passwd {}
	$w.passwd.pw.new.label config -text "Verify Password:"
	$w.passwd.pw.new.entry delete 0 end
	bind $w.passwd.pw.new.entry <Return> "useredit_passwd_ok2 $w"
	$w.passwd.pw.button config -command "useredit_passwd_ok2 $w"
}

proc useredit_passwd_ok2 {w} \
{
	upvar tmp_passwd($w.newpasswd) tmp_passwd_old
	upvar tmp_passwd_save($w.passwd) tmp_passwd_save
	upvar #0 tmp_passwd($w.passwd) tmp_passwd
	if { [string compare $tmp_passwd $tmp_passwd_save] == 0 } \
	{
		set tmp_passwd_old [passwd_crypt $tmp_passwd]
		$w.passwd.pw.old.entry config -text $tmp_passwd_old
	}
	set tmp_passwd {}
	$w.passwd.pw.new.label config -text "Enter Password:"
	$w.passwd.pw.new.entry delete 0 end
	bind $w.passwd.pw.new.entry <Return> "useredit_passwd_ok1 $w"
	$w.passwd.pw.button config -command "useredit_passwd_ok1 $w"
}

proc useredit_passwd_apply {w} \
{
	upvar tmp_passwd($w.newpasswd) tmp_newpasswd
	upvar tmp_passwd($w) tmp_passwd
	set tmp_passwd $tmp_newpasswd
	$w.useredit.entry.password config -text $tmp_passwd
	destroy $w.passwd
}