########################################################################
#
# Copyright (c) 1994 John F. Sefler.
# All rights reserved.
#
########################################################################
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written
# agreement is hereby granted, provided the above copyright notice and
# the following two paragraphs appear in all copies of this software.
#
# IN NO EVENT SHALL JOHN F. SEFLER BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF HE HAS
# BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# JOHN F. SEFLER SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT
# NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
# "AS IS" BASIS, AND JOHN F. SEFLER HAS NO OBLIGATION TO PROVIDE
# MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
#
########################################################################

########################################################################
#
# GetNearestFontFromPixels Arguments:
#	family  window name in which to center the dialog
#	weight	window name for the toplevel dialog
#	slant	window title decoration for window manager
#	pixels	the message string to display
#	search_direction	-1 searches for smaller pixels (default)
#				 1 searches for larger pixels
#
# Return Value:
#	The actual font name:
#          -*-family-weight-slant-*-*-pixels-*-*-*-*-*-*-*
#
# Usage Example:
#	set font [GetNearestFontFromPixels helvetica bold o 24]
#
# Note:
#	If a legal font is not found, the following is returned.
#          -*-*-*-*-*-*-*-*-*-*-*-*-*-*
#
# Author: John F. Sefler
#
########################################################################
proc GetNearestFontFromPixels {family weight slant pixels {search_direction -1}} {

  # use a dummy label to try out the fonts
  set w .dummyFontLabel
  label $w -text dummyFontLabel

  # start trying font iterations until one works
  for {set iter 1} {$iter <= 100 && $pixels > 0} {incr iter} {

    set font -*-$family-$weight-$slant-*-*-$pixels-*-*-*-*-*-*-*

    # is this font any good?
    set error_no [catch {$w configure -font $font}]

    # if it is, return it
    if {$error_no == 0} { destroy $w; return $font }

    # increment the pixel size by the search_direction
    incr pixels $search_direction
  }

  # the number of iterations has exceeded, will a pixel size of * work?
  set font -*-$family-$weight-$slant-*-*-*-*-*-*-*-*-*-*
  set error_no [catch {$w configure -font $font}]
  if {$error_no == 0} { destroy $w; return $font }

  # a legal pixel size for this font was not found
  set font -*-*-*-*-*-*-*-*-*-*-*-*-*-*
  destroy $w; return $font
}
