#---------------------------------------------------------------------------
#
#	Message Creation
#
#---------------------------------------------------------------------------

# widget message {name -text -relief -textfont -layout -aspect}
#	Create a new message widget with the given contents displayed.
#
#
defwidget Message

defmethod Message new {name args} {

  args	text {relief sunken} {textfont text} {aspect 200} layout

  message $name \
	-aspect $aspect -relief $relief \
	-borderwidth 2 -padx 5 -pady 5 \
	-background [Color slot bg] \
	-foreground [Color slot fg] \
	-font [Font slot $textfont] \
	-justify left \
	-text $text

  Message instantiate $name $layout
}

defmethod Message get {} {
  lindex [$self! configure -text] 4
}

defmethod Message set {text} {
  $self! configure -text $text
  return
}
