#---------------------------------------------------------------------------
#
#	Create logo frame
#
#---------------------------------------------------------------------------

Font usef logo,0 \
	"-*-new century schoolbook-medium-r-normal--*-100-%s-%s-*-*-*-*" 75 100

Font usef logo,1 \
	"-*-new century schoolbook-bold-r-normal--*-100-%s-%s-*-*-*-*" 75 100

Font use logo,2 \
	"-*-new century schoolbook-medium-r-normal--*-120-100-100-*-*-*-*" \
	"-*-new century schoolbook-medium-r-normal--*-140-75-75-*-*-*-*"

Font usef logo,3 \
	"-*-new century schoolbook-bold-i-normal--*-240-%s-%s-*-*-*-*" 100 75

Font use logo,4 \
	"-*-lucida-bold-r-normal-sans-*-180-100-100-*-*-*-*" \
	"-*-helvetica-bold-r-normal--*-180-100-100-*-*-*-*" \
	"-*-helvetica-bold-r-normal--*-180-75-75-*-*-*-*"

Font use logo,5 \
	"-*-times-medium-r-normal--*-120-100-100-*-*-*-*" \
	"-*-times-medium-r-normal--*-140-75-75-*-*-*-*"

Font usef logo,6 \
	"-*-new century schoolbook-bold-r-normal--*-240-%s-%s-*-*-*-*" 100 75

Font use logo,7 \
	"-*-lucida-bold-r-normal-sans-*-100-75-75-*-*-*-*" \
	"-*-helvetica-bold-r-normal--*-100-100-100-*-*-*-*" \
	"-*-helvetica-bold-r-normal--*-100-75-75-*-*-*-*"

Font use logo,8 \
	"-*-new century schoolbook-bold-r-normal--*-120-100-100-*-*-*-*" \
	"-*-new century schoolbook-bold-r-normal--*-140-75-75-*-*-*-*"

#---------------------------------------------------------------------------
#
#	Create a new logo panel (logo size: 220x100)
#
#---------------------------------------------------------------------------

defwidget Logos
defwidget Logo Window {{win_h 100} {win_w 220}}
defwidget Canvaslogo Logo
defwidget Photologo Logo

defmethod Logos new {name args} {
  global system

  args	{dir horizontal} logos layout {max 4}

  if { $logos == "application" } then {
    set logos [assoc $system(application) [lrange $system(applogos) 1 end]]
    if { $logos == {} } then {
      set logos [lindex $system(applogos) 0]
    }
    set logos [concat $system(logos) [list $system(application)] $logos]
  } elseif { $logos == "system" } then {
      set logos [concat $system(logos) [list $system(system)]]
  }

  # Width and height of a single logo -- hardwired!
  set win_w [Logo slot win_w]
  set win_h [Logo slot win_h]

  # Separator space between logos and enclosing frame
  set win_sep 20
  set n [llength ${logos}]

  if { $dir == "horizontal" } then {
    set n_x [expr {($n >= $max) ? $max : $n}]
    set n_y [expr ($n+$max-1)/$max]
  } else {
    set n_x [expr ($n+$max-1)/$max]
    set n_y [expr {($n >= $max) ? $max : $n}]
  }

  Frame new $name -layout $layout \
	-width [expr $win_sep+($win_w+$win_sep)*$n_x] \
	-height [expr $win_sep+($win_h+$win_sep)*$n_y]
  defsuper $name Logos

  set x 0
  set y 0

  foreach logo ${logos} {
    set w [anon $name]

    Logo:$logo new $w

    place $w -in $name -anchor center \
	-relx [expr (2.0*$x+1.0)/(2.0*$n_x)] \
	-rely [expr (2.0*$y+1.0)/(2.0*$n_y)]

    if { $dir == "horizontal" } then {
      incr x
      if { $x == $max } {
	set x 0
	incr y
      }
    } else {
      incr y
      if { $y == $max } {
	set y 0
	incr x
      }
    }
  }

  return $name
}

Window addDemo Logos

defmethod Logos demo {} {

  set t [Toplevel new * -title "New Toplevel" -info true -resizable true]
  Logos new *$t -layout {top fill} -dir vertical \
	-logos {FhG-IAO Dornier Prestige Demo Tina-AIT Tina-CT Tina-MP IBM
		Consens EEC Enterprise Porsche Inventar}
  Button new *$t -layout {padx 20 pady 20 bottom} \
	-textfont largebold -text "Dismiss" \
	-action [list $t Dismiss]
  $t layout center
}

#---------------------------------------------------------------------------

defmethod Photologo new {frame} {
  global system

  set win_w [Logo slot win_w]
  set win_h [Logo slot win_h]

  if { $system(has_photo) } {
    Frame new $frame -relief sunken
    defsuper $frame $self
    if { [Color pick mono color] == "mono" } {
      photo $frame.im -blank black -geometry ${win_w}x${win_h} \
	-ditherlevel 2 -palette 2
    } {
      photo $frame.im -blank black -geometry ${win_w}x${win_h}
    }
    Window instantiate $frame.im {top}
    $self draw $frame.im
  } {
    Frame new $frame -relief sunken -width ${win_w} -height ${win_h}
  }
  return $frame
}

defmethod Canvaslogo new {w} {

  set win_w [Logo slot win_w]
  set win_h [Logo slot win_h]

  Canvas new $w -width ${win_w} -height ${win_h} \
	-background [Color pick white #f0f0ff]
  defsuper $w $self
  set id0 [$w! create rect 0 0 1 1 -tags JUNK]
  $self draw $w
  set id1 [$w! create rect 0 0 1 1 -tags JUNK]

  for {} {$id0 <= $id1} {incr id0} {
    catch [list $w! addtag logo withtag $id0]
  }
  $w! delete JUNK
  return $w
}

defmethod Logo draw {where} {
  error "No drawing method has been defined for the $self logo."
}

#---------------------------------------------------------------------------

defmethod Canvaslogo draw(spectrum) {xbox ybox dxbox dybox} {

  if {[Color pick mono color] == "mono"} then {
    return
  }

  set up {10 20 30 40 50 60 70 80 90 a0 b0 c0 d0 e0 f0 ff}
  set down {f0 e0 d0 c0 b0 a0 90 80 70 60 50 40 30 20 10 00}
  set colors { #ff0000 }

  foreach i $up {lappend colors #ff${i}00}
  foreach i $down {lappend colors #${i}ff00}
  foreach i $up {lappend colors #00ff${i}}
  foreach i $down {lappend colors #00${i}ff}
  foreach i $up {lappend colors #${i}00ff}

  set n [llength $colors]
  set seg [expr ($dxbox*1.0)/$n]
  set dybox [expr $ybox+$dybox]

  set nextx0 $xbox
  foreach col $colors {
    set x0 $nextx0
    set nextx0 [expr $x0+$seg]
    $self! create polygon $x0 $ybox $nextx0 $ybox ${nextx0} $dybox $x0 $dybox \
	-fill $col
  }
}

defmethod Canvaslogo draw(shades) {xbox ybox dxbox dybox} {

  if {[Color pick mono color] == "mono"} then {
    return
  }

  for {set i 100} {$i < 256} {incr i 5} {
    set r [format "%02x" [expr 80+$i/3]]
    set g [format "%02x" [expr 80+$i/3]]
    set b [format "%02x" [expr $i]]
    lappend colors "#${r}${g}${b}"
  }

  set n [llength $colors]
  set seg [expr ($dxbox*1.0)/$n]
  set dybox [expr $ybox+$dybox]

  set nextx0 $xbox
  foreach col $colors {
    set x0 $nextx0
    set nextx0 [expr $x0+$seg]
    $self! create polygon $x0 $ybox $nextx0 $ybox ${nextx0} $dybox $x0 $dybox \
	-fill $col
  }
}

defmethod Canvaslogo draw(eec) {w r {color black} {tags eec}} {
  global sin cos

  for {set arc 0} {$arc < 360} {incr arc 30} {
    set x [expr $r*$sin($arc)+$r]
    set y [expr $r*$cos($arc)+$r]
    $w! create polygon \
	[expr $x+0.0] [expr $y-3.0] \
	[expr $x+1.0] [expr $y-1.0] \
	[expr $x+2.5] [expr $y-1.0] \
	[expr $x+1.5] [expr $y+0.0] \
	[expr $x+2.5] [expr $y+2.5] \
	[expr $x-0.0] [expr $y+1.0] \
	[expr $x-2.5] [expr $y+2.5] \
	[expr $x-1.5] [expr $y+0.0] \
	[expr $x-2.5] [expr $y-1.0] \
	[expr $x-1.0] [expr $y-1.0] \
	-fill $color -tags $tags
  }
}

proc create(sincos) {} {
  global sin cos

  set pi 3.1415926536
  set r 25
  for {set arc 0} {$arc < 360} {incr arc 30} {
    set sin($arc) [expr sin($pi*$arc/180)]
    set cos($arc) [expr cos($pi*$arc/180)]
  }
}
create(sincos)

#---------------------------------------------------------------------------
#
#	Draw FhG-IAO Logo
#
defmethod {Logo:FhG-IAO Canvaslogo} draw {w} {

  set col [Color pick black #08e008]

  # IAO frame
  $w! create rectangle 32 11 109 88

  # I
  $w! create rectangle 37 50 50 83
  $w! create oval 38 59 49 63

  # A
  $w! create line 55 50 77 50 77 82 68 82 68 75 64 75 64 82 55 82 55 50
  $w! create rectangle 64 58 69 67

  # O
  $w! create rectangle 82 50 104 83
  $w! create rectangle 91 58 95 75

  # FhG bitmap
  $w! create bitmap 112 11 -anchor nw -foreground $col \
	-bitmap @[the(image) logo-fhg]
}

#---------------------------------------------------------------------------
#
#	Draw Dornier Logo
#

defmethod {Logo:Dornier Canvaslogo} draw {w} {

  set col [Color pick black #00a8ff]

  # two lines of text plus separator line
  $w create text 80 49 -anchor sw -fill $col \
	-font [Font slot logo,4] -text "Dornier"
  $w create line 81 51 211 51
  $w create text 81 56 -anchor nw -fill black \
	-font [Font slot logo,5] -text "Deutsche Aerospace"

  # simple lines of the Dornier star
  $w create line 5 51 34 45 40 51 -fill $col
  $w create line 34 45 40 16 -fill $col
  $w create line 46 45 75 51 -fill $col
  $w create line 40 86 34 57 -fill $col

  # filled polygons of the Dornier star
  $w create polygon 5 51 40 51 34 57 -fill $col
  $w create polygon 40 16 40 51 46 45 -fill $col
  $w create polygon 75 51 41 51 46 57 -fill $col
  $w create polygon 40 86 46 57 40 52 -fill $col
}

#---------------------------------------------------------------------------
#
#	Draw Prestige Logo
#

defmethod {Logo:Prestige Canvaslogo} draw {w} {

  # Draw animation
  $w draw(spectrum) 0 0 [Logo slot win_w] [Logo slot win_h]

  set f1 [Font slot logo,0]
  set f2 [Font slot logo,1]

  # Draw text
  $w! create text 110 60 -anchor s -fill black \
	-font $f1 -text "Planning, Resource Scheduling"
  $w! create text 110 75 -anchor s -fill black \
	-font $f1 -text "Timeline Generation"
  $w! create text 5 95 -anchor sw -fill black \
	-font $f2 -text "Juergen Wagner"
  $w! create text 215 95 -anchor se -fill black \
	-font $f2 -text "FhG-IAO Stuttgart"

  # Draw large letters
  $w! create text 110 10 -anchor n -fill black \
	-font [Font slot logo,3] -text "Prestige"
}

#---------------------------------------------------------------------------
#
#	Draw TINA Logos
#

defmethod {Logo:Tina Canvaslogo} draw {w} {

  # Draw shades of blue
  $w draw(shades) 0 0 [Logo slot win_w] [Logo slot win_h]

  set col [Color pick black #00a8ff]

  set f1 [Font slot logo,1]

  # simple lines of the Dornier star
  $w create line 5 51 34 45 40 51 -fill $col
  $w create line 34 45 40 16 -fill $col
  $w create line 46 45 75 51 -fill $col
  $w create line 40 86 34 57 -fill $col

  # filled polygons of the Dornier star
  $w create polygon 5 51 40 51 34 57 -fill $col
  $w create polygon 40 16 40 51 46 45 -fill $col
  $w create polygon 75 51 41 51 46 57 -fill $col
  $w create polygon 40 86 46 57 40 52 -fill $col

  # Draw text
  $w create text 140 65 -anchor s -fill black \
	-font [Font slot logo,2] -text "Timeline Assistant"
  $w create text 5 95 -anchor sw -fill black \
	-font $f1 -text "FhG-IAO"
  $w create text 215 95 -anchor se -fill black \
	-font $f1 -text "Dornier"

  # Draw large letters
  $w create text 140 10 -anchor n -fill black \
	-font [Font slot logo,6] -text "T  I  N  A"

  # Draw descriptive text
  $w! create text 140 65 -anchor n -fill black \
	-font [Font slot logo,0] -text "([$self slot description])"
}

defobject Logo:Demo Logo:Tina \
  {{description {Satellite AIT - Demo}}}

defobject Logo:Tina-AIT Logo:Tina \
  {{description {Satellite AIT}}}

defobject Logo:Tina-CT Logo:Tina \
  {{description {Crew Training}}}

defobject Logo:Tina-MP Logo:Tina \
  {{description {Mission Planning}}}

#---------------------------------------------------------------------------

defmethod {Logo:IBM Canvaslogo} draw {w} {

  set color [Color pick black #0030ff]
  set bg [lindex [$w! configure -background] 4]

  # I
  $w! create polygon 0 0 8 0 8 4 6 4 6 12 8 12 8 16 0 16 0 12 2 12 2 4 0 4 \
	-fill $color -tags ibm-i
  $w! scale ibm-i 0 0 4 4
  $w! move ibm-i 29 20

  # B
  $w! create polygon 0 0 7 0 7 16 0 16 0 12 2 12 2 4 0 4 \
	-fill $color -tags ibm-b
  $w! create oval 3 0 11 8 -fill $color -tags ibm-b -outline $color
  $w! create oval 3 8 11 16 -fill $color -tags ibm-b -outline $color
  $w! create rect 5 4 7 6 -fill $bg -tags ibm-b
  $w! create rect 5 10 7 12 -fill $bg -tags ibm-b
  $w! scale ibm-b 0 0 4 4
  $w! move ibm-b 70 20

  # M
  $w! create polygon 0 0 5 0 8 8 11 0 16 0 16 4 14 4 14 12 16 12 16 16 11 16 \
	11 8 8 16 5 8 5 16 0 16 0 12 2 12 2 4 0 4 \
	-fill $color -tags ibm-m
  $w! scale ibm-m 0 0 4 4
  $w! move ibm-m 123 20

  # Lines
  set win_w [Logo slot win_w]
  set win_h [Logo slot win_h]
  for {set y 1} {$y < $win_h} {set y [expr $y+8]} {
    $w! create rect 0 $y $win_w [expr $y+4] -fill $bg -tags line \
	-width 0 -outline $bg
  }
}

#---------------------------------------------------------------------------

defmethod {Logo:Consens Canvaslogo} draw {w} {

  set win_w [Logo slot win_w]
  set win_h [Logo slot win_h]

  $w! create rectangle 0 0 $win_w $win_h -fill [Color pick white #123f82]
  $w! create text 80 50 -font [Font slot logo,4] \
	-text "CONSENS" \
	-anchor w -fill [Color pick black #f8d702]
  $w! create text 110 97 -font [Font slot logo,7] \
	-text "ESPRIT III Project EP 6896" \
	-anchor s -fill [Color pick black #f8d702]

  $w! create polygon 0 0 57 0 57 8 12 8 12 17 57 17 57 24 0 24 \
	-fill [Color pick black #4289f4] -tags poly0
  $w! scale poly0 0 0 2.8 2.8
  $w! move poly0 46 17

  $w! create polygon 0 0 57 0 57 8 12 8 12 17 57 17 57 24 0 24 \
	-fill [Color pick black #255aa9] -tags poly
  $w! scale poly 0 0 2.8 2.8
  $w! move poly 42 13

  set r 25
  $self draw(eec) $w $r [Color pick black #f8d702]
  $w! move eec 20 10
}

#---------------------------------------------------------------------------

defmethod {Logo:EEC Canvaslogo} draw {w} {
  global sin cos

  set win_w [Logo slot win_w]
  set win_h [Logo slot win_h]

  $w create rectangle 0 0 $win_w $win_h -fill [Color pick black #7488e0]

  set r 20
  $self draw(eec) $w $r [Color pick white #ffff3a]
  $w! scale eec 0 0 2 2
  $w! move eec [expr $win_w/2-2*$r] [expr $win_h/2-2*$r]
}

#---------------------------------------------------------------------------

defmethod {Logo:Enterprise Photologo} draw {w} {

  readppm $w [the(image) fancy ppm]
}

#---------------------------------------------------------------------------

defmethod {Logo:Porsche Photologo} draw {w} {

  $w put 0 0 220 100 1 1 #6a5acd
  readppm $w [the(image) logo-porsche ppm] 78 18
}

#---------------------------------------------------------------------------

defmethod {Logo:Tocen Canvaslogo} draw {w} {

  # Draw animation
  $w draw(spectrum) 0 0 [Logo slot win_w] [Logo slot win_h]

  # Draw large letters
  set f [Font slot logo,2]
  $w create text 110 10 -anchor n -fill black \
	-font $f -text "Team-Oriented"
  $w create text 110 40 -anchor n -fill black \
	-font $f -text "Cooperation"
  $w create text 110 70 -anchor n -fill black \
	-font $f -text "Environment"
}

#---------------------------------------------------------------------------

defmethod {Logo:Inventar Canvaslogo} draw {w} {

  # to do
}

#---------------------------------------------------------------------------

defmethod {Logo:Disketten Canvaslogo} draw {w} {

  # to do
}
