# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Set of alarms dialog
#
# Commands
#
#	alarm_set <leader> <resultvar> <initial alarm list>
#
#	Interact with user to determine set of alarm times.
#	The result is a list of elements ranging over 0..60 and is
#	stored in resultvar.  Returns true iff dialog is not cancelled.

# Hidden global variables
#
#	as_init			Created as dialog window?
#	as_done			Is as interaction finished
#	as_value		List of values

set as_init 0
set as_done 0
set as_value ""

proc alarm_set {leader var init} {
    as_make

    set result [as_interact $leader $init]
    if $result {
	global as_value
	upvar $var returnVar

	set returnVar $as_value
    }
    return $result
}

proc as_make {} {
    global as_init as_done as_value
    if {$as_init} {return}
    set as_init 1

    set f .as_dialog

    toplevel $f -class Dialog -geometry ""
    wm title $f "Set Alarm Times"
    wm protocol $f WM_DELETE_WINDOW {set as_done 0}

    frame $f.top -relief raised -bd 1
    frame $f.adj -relief raised -bd 1
    frame $f.mid -relief raised -bd 1
    frame $f.bot -relief raised -bd 1
    frame $f.bot.default -relief sunken -bd 1

    message $f.text -aspect 400 -text {Select set of alarm times in minutes.  Use the sliders to adjust each individual alarm.  Use the two buttons at the top to change the number of different alarm times.}

    button $f.yes -text Okay -command {set as_done 1}
    button $f.no -text Cancel -command {set as_done 0}

    button $f.adj.add -text {Add Alarm} -command {as_add}
    button $f.adj.del -text {Remove Alarm} -command {as_del}

    pack append $f.top $f.text {right expand fill padx 5m pady 5m}

    pack append $f.adj $f.adj.add {left expand padx 5m pady 5m}
    pack append $f.adj $f.adj.del {left expand padx 5m pady 5m}

    pack append $f.bot.default $f.yes {left padx 3m pady 3m}
    pack append $f.bot $f.no  {left expand padx 5m pady 5m}
    pack append $f.bot $f.bot.default {left expand}

    pack append $f $f.top {top expand fill}
    pack append $f $f.adj {top fill expand pady 1m}
    pack append $f $f.mid {top fill}
    pack append $f $f.bot {bottom fill}

    bind $f <Control-c> {set as_done 0}
    bind $f <Return> {set as_done 1}

    wm withdraw $f
    update
}

proc as_interact {leader init} {
    global as_value
    global as_done
    set f .as_dialog

    # Initialize dialog

    set i 0
    foreach alarm $init {
	as_make_child $i $alarm
	incr i
    }

    # Run dialog
    set as_done -1
    dialog_run $leader $f $f as_done

    # Construct return value
    set i 0
    set as_value {}
    foreach child [winfo children $f.mid] {
	lappend as_value [$f.mid.$i get]
	destroy $f.mid.$i
	incr i
    }
    set as_value [lsort -integer $as_value]

    return $as_done
}

proc as_make_child {i init} {
    set f .as_dialog

    scale $f.mid.$i \
	-from 0 -to 60 \
	-length 3i \
	-showvalue 1 \
	-tickinterval 0\
	-orient vertical
    $f.mid.$i set $init
    pack append $f.mid $f.mid.$i {left expand fillx}

    $f.mid.0 configure -tickinterval 15
}

proc as_add {} {
    as_make_child [llength [winfo children .as_dialog.mid]] 0
}

proc as_del {} {
    set count [llength [winfo children .as_dialog.mid]]
    if {$count > 0} {
	destroy .as_dialog.mid.[expr $count - 1]
    }
}
