# find.tcl
#
# Find tool.
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Find_Setup {} {
    global find

    if ![info exists find(entry)] {
	set find(dir) forw

	set t [Widget_Toplevel .find "Exmh Find Tool" Find]

	set f [Widget_Frame $t but Menubar]
	Widget_AddBut $f quit "Dismiss" { FindDestroy }

	Widget_AddBut $f next "Next" {Find_It forw} {left padx 1}
	Widget_AddBut $f prev "Prev" {Find_It prev} {left padx 1}
	set find(choice) FTOC
	Widget_RadioBut $f ftoc "FTOC" find(choice) {left padx 1}
	Widget_RadioBut $f msg "Msg" find(choice) {left padx 1}

	set f [Widget_Frame $t rim Rim]
	$f configure -bd 10
	set f [Widget_Frame $f rim Rim]
	$f configure -bd 2 -relief raised
	Widget_Label $f label {left fill} -text "Pattern: "
	set find(entry) [Widget_Entry $f entry {right fill expand} -bg white]
	Bindings_Search $find(entry)
	focus $find(entry)
    } else {
	if {[catch {wm state .find} state] == 0} {
	    if {$state != "normal"} {
		catch {wm geometry .find $find(geometry)}
		wm deiconify .find
	    } else {
		catch {raise .find}
	    }
	}
	Find_It forw
    }
}
proc FindDestroy {} {
    global find
    set find(geometry) [wm geometry .find]
    wm withdraw .find
    Exmh_Focus
}
proc Find_It { {dir _default_} } {
    global find
    if ![info exists find(entry)] {
	Find_Setup
	return
    }
    if [catch {$find(entry) configure}] {
	unset find(entry)
	Find_Setup
	return
    }
    if {$dir == "_default_"} {
	set dir $find(dir)
    }
    set find(dir) $dir
    if {$find(choice) == "FTOC"} {
	Ftoc_Find [$find(entry) get] $dir
	return
    }
    if {$find(choice) == "Msg"} {
	Msg_Find [$find(entry) get] $dir
	return
    }
}
