#!/usr/local/bin/wish -f
#
# This macro checks the "send" command and executes xauth
#
global env

wm withdraw .

proc ClearXhost { } {

   set s ""
   catch {set s [exec xhost 2>/dev/null]}
   set s [lrange [split $s "\n"] 1 end]
   if {$s == ""} {return 1}
   set erg [tk_dialog .err "update message:" \
"NOTE: the following hosts are included\n \
in your xhosts:\n \
$s \n \
should they be removed now ?" \
      warning -1 NO YES]
   if {$erg} {
      foreach i $s {
         catch {eval exec xhost -$i}
      }
   }
   set erg [tk_dialog .err "update message:" \
"Now enabling access control ?" \
      warning -1 NO YES]
   if {$erg} {
      catch {eval "exec xhost -"}
   }
   return 0
}

if {[catch {send "tkedit" "NoAction"}]} {
   set erg [tk_dialog .err "update message:" \
"NOTE: The send command did not work\n \
The following is an attempt to fix this.\n \
If this is not a stand-alone system, you\n \
should consider understanding the xauth\n \
mechanism and do everything by hand" \
      warning -1 "Go on" "skip"]
   if {$erg} {exit}
   if {![file exists ~/.Xauthority]} {
       set erg [tk_dialog .err "update message:" \
"You do not have a .Xauthority file yet!\n \
Do you want me to call xauth add ?" \
      warning -1 NO YES]
      if {$erg} {
         scan [exec id] "uid=%d %s gid=%d" uid dummy gid
         set x [format "%010x%010x%012x" $uid $gid [pid]]
         catch {eval "exec xauth add $env(DISPLAY) . $x"}
         ClearXhost
      }
   } else {
      if {[eval exec xauth list $env(DISPLAY)] == ""} {
         set erg [tk_dialog .err "update message:" \
"You do have a .Xauthority file,\n \
but this Display is not in the file.\n \
Do you want me to add this Display ?" \
         warning -1 NO YES]
         if {$erg} {
            scan [exec xauth list] "%s %s %s" disp prot key
            catch {eval "exec xauth add $env(DISPLAY) $prot $key"}
            ClearXhost
         }
      } else {
         if {[ClearXhost]} {
            tk_dialog .err "update message:" \
"You do have a .Xauthority file\n \
and your Display is in the file.\n \
and xhost is empty, access control enabled.\n \
Make shure your XServer is reading\n \
your .Xdefault file (-auth option)\n \
Please read the xauth man pages." \
            warning -1 "I'll have a look"
         }
      }
   }
} else {
   tk_dialog .err "update message:" \
"NOTE: The send command works" \
      warning -1 "So what ?"
}

exit
