#!/usr/local/bin/tclsh
# $Id: demo.tcl,v 1.5 1995/05/10 16:10:55 jfontain Exp $

source shql.tcl

dbdebug 1

# Create database mydb
dbcreate shql 'mydb'

# Connect to database mydb
set connection [dbconnect shql 'mydb']

# Create table customer
dbsql $connection "create table customer(name char(30), age int, status char(1))"

# Put one person in the table
dbsql $connection "insert into customer values('Fred', 32, 'G')"

# Study the table
set cursor [dbcursor $connection "select * from customer"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Add two more people
dbsql $connection "insert into customer values ('Barney', 29, 'G', 'Wilma', 28, 'D')"
set cursor [dbcursor $connection "select * from customer"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Get customers with 'G' status
set cursor [dbcursor $connection "select * from customer where status = 'G'"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Get sorted list of customers by age
set cursor [dbcursor $connection "select * from customer order by age num"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Make a table to hold customer status codes and their descriptions
dbsql $connection "create table codes(code char(1), description char(10))"

# Insert status codes
dbsql $connection "insert into codes values ('G', 'Good', 'B', 'Bad', 'D', 'Dead Beat')"

# Create a view so we can see the customer name and status description
dbsql $connection "create view custstat(customer.status = codes.code)"

# Look at the table
set cursor [dbcursor $connection "select * from custstat"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

set cursor [dbcursor $connection "select * from customer, codes where status = code"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Replace 'Barney' with 'Bad Bart'
dbsql $connection "update customer set name = 'Bad Bart', status = 'X' where age = 29"
set cursor [dbcursor $connection "select * from customer"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Get all customers that have invalid status'es
set cursor [dbcursor $connection "select * from customer where status not in select code from codes"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Remove 'Fred'
dbsql $connection "delete from customer where age = 32"

# Get rid of view
dbsql $connection "drop view custstat"

# Create a holding table for old customers
dbsql $connection "create table oldcust(name char(30), status char(1))"

# Copy old customer to new table
dbsql $connection "insert into oldcust (name status) select name status from customer where age > 28"

set cursor [dbcursor $connection "select avg(age) from customer"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

set cursor [dbcursor $connection "select name from customer where age = select min(age) from customer"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Look at table
set cursor [dbcursor $connection "select * from oldcust"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Delete customers moved over
dbsql $connection "delete from customer where age > 28"

set cursor [dbcursor $connection "select * from customer"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Try a union of the two tables
set cursor [dbcursor $connection "select name age from customer union select name status from oldcust"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Show example of executing Unix commands using the Tcl exec command
dbsql $connection "insert into customer values ('[exec date]', [exec ls | wc -l], 'Y')"

set cursor [dbcursor $connection "select * from customer"]
while {[llength [set row [dbcontinue $cursor]]]>0} {
#    puts $row
}

# Clean up
dbsql $connection "drop table codes"
dbsql $connection "drop table customer"
dbsql $connection "drop table oldcust"
